/*
 * Decompiled with CFR 0.152.
 */
package thelm.packagedastral.client.renderer;

import com.mojang.blaze3d.matrix.MatrixStack;
import hellfirepvp.astralsorcery.client.util.ColorizationHelper;
import hellfirepvp.astralsorcery.client.util.RenderingConstellationUtils;
import hellfirepvp.astralsorcery.client.util.RenderingDrawUtils;
import hellfirepvp.astralsorcery.common.constellation.IConstellation;
import hellfirepvp.astralsorcery.common.constellation.world.DayTimeHelper;
import hellfirepvp.astralsorcery.common.crafting.helper.WrappedIngredient;
import hellfirepvp.astralsorcery.common.crafting.recipe.SimpleAltarRecipe;
import hellfirepvp.astralsorcery.common.lib.ColorsAS;
import hellfirepvp.astralsorcery.common.util.data.Vector3;
import java.awt.Color;
import java.util.List;
import net.minecraft.client.renderer.IRenderTypeBuffer;
import net.minecraft.client.renderer.tileentity.TileEntityRenderer;
import net.minecraft.client.renderer.tileentity.TileEntityRendererDispatcher;
import net.minecraft.item.ItemStack;
import net.minecraft.world.World;
import thelm.packagedastral.tile.TraitCrafterTile;
import thelm.packagedauto.client.RenderTimer;

public class TraitCrafterRenderer
extends TileEntityRenderer<TraitCrafterTile> {
    public TraitCrafterRenderer(TileEntityRendererDispatcher rendererDispatcher) {
        super(rendererDispatcher);
    }

    public void render(TraitCrafterTile tile, float partialTicks, MatrixStack matrixStack, IRenderTypeBuffer buffer, int combinedLight, int combinedOverlay) {
        if (TraitCrafterTile.requiresStructure && tile.structureValid) {
            IConstellation c;
            int time = RenderTimer.INSTANCE.getTicks();
            SimpleAltarRecipe recipe = tile.effectRecipe;
            if (recipe != null && (c = recipe.getFocusConstellation()) != null) {
                float dayAlpha = DayTimeHelper.getCurrentDaytimeDistribution((World)tile.func_145831_w()) * 0.6f;
                int max = 3000;
                int t = time % max;
                float halfAge = max / 2;
                float tr = 1.0f - Math.abs(halfAge - (float)t) / halfAge;
                tr = (float)((double)tr * 1.3);
                RenderingConstellationUtils.renderConstellationIntoWorldFlat((IConstellation)c, (MatrixStack)matrixStack, (IRenderTypeBuffer)buffer, (Vector3)new Vector3(0.5, 0.03, 0.5), (double)(5.5 + (double)tr), (double)2.0, (float)(0.1f + dayAlpha));
            }
            matrixStack.func_227860_a_();
            matrixStack.func_227861_a_(0.5, 4.5, 0.5);
            long id = tile.func_174877_v().func_218275_a();
            if (recipe != null) {
                List traitInputs = recipe.getRelayInputs();
                if (!traitInputs.isEmpty()) {
                    int amount = 60 / traitInputs.size();
                    for (int i = 0; i < traitInputs.size(); ++i) {
                        WrappedIngredient ingredient = (WrappedIngredient)traitInputs.get(i);
                        ItemStack traitInput = ingredient.getRandomMatchingStack((long)time);
                        Color color = ColorizationHelper.getColor((ItemStack)traitInput).orElse(ColorsAS.CELESTIAL_CRYSTAL);
                        RenderingDrawUtils.renderLightRayFan((MatrixStack)matrixStack, (IRenderTypeBuffer)buffer, (Color)color, (long)(0x1231943167156902L | id | (long)i * 20817L), (int)20, (float)2.0f, (int)amount);
                    }
                } else {
                    RenderingDrawUtils.renderLightRayFan((MatrixStack)matrixStack, (IRenderTypeBuffer)buffer, (Color)Color.WHITE, (long)(id * 31L), (int)15, (float)1.5f, (int)35);
                    RenderingDrawUtils.renderLightRayFan((MatrixStack)matrixStack, (IRenderTypeBuffer)buffer, (Color)ColorsAS.CELESTIAL_CRYSTAL, (long)(id * 16L), (int)10, (float)1.0f, (int)25);
                }
                RenderingDrawUtils.renderLightRayFan((MatrixStack)matrixStack, (IRenderTypeBuffer)buffer, (Color)Color.WHITE, (long)(id * 31L), (int)10, (float)1.0f, (int)10);
            } else {
                RenderingDrawUtils.renderLightRayFan((MatrixStack)matrixStack, (IRenderTypeBuffer)buffer, (Color)Color.WHITE, (long)(id * 31L), (int)15, (float)1.5f, (int)35);
                RenderingDrawUtils.renderLightRayFan((MatrixStack)matrixStack, (IRenderTypeBuffer)buffer, (Color)ColorsAS.CELESTIAL_CRYSTAL, (long)(id * 16L), (int)10, (float)1.0f, (int)25);
            }
            matrixStack.func_227865_b_();
        }
    }
}

