/*
 * Decompiled with CFR 0.152.
 */
package thelm.packagedastral.ingredient;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonSyntaxException;
import hellfirepvp.astralsorcery.common.constellation.ConstellationRegistry;
import hellfirepvp.astralsorcery.common.constellation.IConstellation;
import hellfirepvp.astralsorcery.common.constellation.IWeakConstellation;
import hellfirepvp.astralsorcery.common.item.crystal.ItemAttunedCrystalBase;
import hellfirepvp.astralsorcery.common.lib.ItemsAS;
import java.util.ArrayList;
import java.util.stream.Stream;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.JSONUtils;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.common.crafting.IIngredientSerializer;
import net.minecraftforge.common.crafting.StackList;
import net.minecraftforge.registries.IForgeRegistryEntry;

public class AttunedCrystalIngredient
extends Ingredient {
    public static final ResourceLocation ID = new ResourceLocation("packagedastral:attuned_crystal");
    public static final IIngredientSerializer<AttunedCrystalIngredient> SERIALIZER = new Serializer();
    private final boolean hasToBeCelestial;
    private final boolean canBeCelestial;
    private final IWeakConstellation constellation;

    public AttunedCrystalIngredient(boolean hasToBeCelestial, boolean canBeCelestial, IWeakConstellation constellation) {
        super(AttunedCrystalIngredient.getItems(hasToBeCelestial, canBeCelestial, constellation));
        this.hasToBeCelestial = hasToBeCelestial;
        this.canBeCelestial = canBeCelestial;
        this.constellation = constellation;
    }

    private static Stream<Ingredient.IItemList> getItems(boolean hasToBeCelestial, boolean canBeCelestial, IWeakConstellation constellation) {
        ItemStack stack;
        if (hasToBeCelestial) {
            canBeCelestial = true;
        }
        ArrayList<ItemStack> stacks = new ArrayList<ItemStack>();
        if (!hasToBeCelestial) {
            stack = new ItemStack((IItemProvider)ItemsAS.ATTUNED_ROCK_CRYSTAL);
            ItemsAS.ATTUNED_ROCK_CRYSTAL.setAttunedConstellation(stack, constellation);
            stacks.add(stack);
        }
        if (canBeCelestial) {
            stack = new ItemStack((IItemProvider)ItemsAS.ATTUNED_CELESTIAL_CRYSTAL);
            ItemsAS.ATTUNED_CELESTIAL_CRYSTAL.setAttunedConstellation(stack, constellation);
            stacks.add(stack);
        }
        return Stream.of(new StackList(stacks));
    }

    public boolean test(ItemStack stack) {
        if (super.test(stack)) {
            ItemAttunedCrystalBase item = (ItemAttunedCrystalBase)stack.func_77973_b();
            return item.getAttunedConstellation(stack) == this.constellation;
        }
        return false;
    }

    public boolean isSimple() {
        return false;
    }

    public JsonElement func_200304_c() {
        JsonObject json = new JsonObject();
        json.addProperty("type", ID.toString());
        json.addProperty("hasToBeCelestial", Boolean.valueOf(this.hasToBeCelestial));
        json.addProperty("canBeCelestial", Boolean.valueOf(this.canBeCelestial));
        json.addProperty("constellation", this.constellation.getRegistryName().toString());
        return json;
    }

    public IIngredientSerializer<? extends Ingredient> getSerializer() {
        return SERIALIZER;
    }

    private static class Serializer
    implements IIngredientSerializer<AttunedCrystalIngredient> {
        private Serializer() {
        }

        public AttunedCrystalIngredient parse(JsonObject json) {
            boolean hasToBeCelestial = JSONUtils.func_151209_a((JsonObject)json, (String)"hasToBeCelestial", (boolean)false);
            boolean canBeCelestial = JSONUtils.func_151209_a((JsonObject)json, (String)"canBeCelestial", (boolean)true);
            ResourceLocation constellationName = new ResourceLocation(JSONUtils.func_151200_h((JsonObject)json, (String)"constellation"));
            IConstellation constellation = ConstellationRegistry.getConstellation((ResourceLocation)constellationName);
            if (constellation instanceof IWeakConstellation) {
                return new AttunedCrystalIngredient(hasToBeCelestial, canBeCelestial, (IWeakConstellation)constellation);
            }
            throw new JsonSyntaxException("Unknown or non-attunable constellation '" + constellationName + "'");
        }

        public AttunedCrystalIngredient parse(PacketBuffer buffer) {
            boolean hasToBeCelestial = buffer.readBoolean();
            boolean canBeCelestial = buffer.readBoolean();
            IConstellation constellation = (IConstellation)buffer.readRegistryId();
            if (constellation instanceof IWeakConstellation) {
                return new AttunedCrystalIngredient(hasToBeCelestial, canBeCelestial, (IWeakConstellation)constellation);
            }
            throw new IllegalArgumentException("Read non-attunable constellation '" + constellation.getRegistryName() + "'");
        }

        public void write(PacketBuffer buffer, AttunedCrystalIngredient ingredient) {
            buffer.writeBoolean(ingredient.hasToBeCelestial);
            buffer.writeBoolean(ingredient.canBeCelestial);
            buffer.writeRegistryId((IForgeRegistryEntry)ingredient.constellation);
        }
    }
}

