/*
 * Decompiled with CFR 0.152.
 */
package thelm.packagedastral.integration.patchouli.component;

import com.google.common.collect.Lists;
import com.google.gson.annotations.SerializedName;
import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.systems.RenderSystem;
import hellfirepvp.astralsorcery.client.util.RenderingConstellationUtils;
import hellfirepvp.astralsorcery.common.block.tile.altar.AltarType;
import hellfirepvp.astralsorcery.common.constellation.IConstellation;
import hellfirepvp.astralsorcery.common.crafting.helper.WrappedIngredient;
import hellfirepvp.astralsorcery.common.crafting.recipe.SimpleAltarRecipe;
import java.awt.Color;
import java.util.List;
import java.util.function.UnaryOperator;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.AbstractGui;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.MathHelper;
import thelm.packagedauto.util.MiscHelper;
import vazkii.patchouli.api.IComponentRenderContext;
import vazkii.patchouli.api.ICustomComponent;
import vazkii.patchouli.api.IVariable;

public class AltarRecipeGridComponent
implements ICustomComponent {
    public static final ResourceLocation DISCOVERY_GRID = new ResourceLocation("packagedastral:textures/gui/patchouli/discovery_grid.png");
    public static final ResourceLocation ATTUNEMENT_GRID = new ResourceLocation("packagedastral:textures/gui/patchouli/attunement_grid.png");
    public static final ResourceLocation CONSTELLATION_GRID = new ResourceLocation("packagedastral:textures/gui/patchouli/constellation_grid.png");
    public static final ResourceLocation TRAIT_GRID = new ResourceLocation("packagedastral:textures/gui/patchouli/trait_grid.png");
    @SerializedName(value="recipe")
    public IVariable recipeRaw;
    transient SimpleAltarRecipe recipe;
    transient int x;
    transient int y;

    public void onVariablesAvailable(UnaryOperator<IVariable> lookup) {
        ResourceLocation recipeId = new ResourceLocation(((IVariable)lookup.apply(this.recipeRaw)).asString());
        IRecipe recipe = MiscHelper.INSTANCE.getRecipeManager().func_215367_a(recipeId).orElse(null);
        if (recipe instanceof SimpleAltarRecipe) {
            this.recipe = (SimpleAltarRecipe)recipe;
        }
    }

    public void build(int componentX, int componentY, int pageNum) {
        this.x = componentX < 0 ? 9 : componentX;
        this.y = componentY < 0 ? 12 : componentY;
    }

    public void render(MatrixStack matrixStack, IComponentRenderContext context, float partialTicks, int mouseX, int mouseY) {
        if (this.recipe != null) {
            Minecraft mc = Minecraft.func_71410_x();
            RenderSystem.enableBlend();
            switch (this.recipe.getAltarType()) {
                case DISCOVERY: {
                    mc.field_71446_o.func_110577_a(DISCOVERY_GRID);
                    break;
                }
                case ATTUNEMENT: {
                    mc.field_71446_o.func_110577_a(ATTUNEMENT_GRID);
                    break;
                }
                case CONSTELLATION: {
                    mc.field_71446_o.func_110577_a(CONSTELLATION_GRID);
                    break;
                }
                case RADIANCE: {
                    mc.field_71446_o.func_110577_a(TRAIT_GRID);
                }
            }
            AbstractGui.func_238463_a_((MatrixStack)matrixStack, (int)(this.x - 1), (int)(this.y - 1), (float)1.0f, (float)1.0f, (int)100, (int)119, (int)128, (int)128);
            if (this.recipe.getAltarType() == AltarType.RADIANCE) {
                IConstellation constellation = this.recipe.getFocusConstellation();
                if (constellation != null) {
                    RenderingConstellationUtils.renderConstellationIntoGUI((Color)Color.BLACK, (IConstellation)constellation, (MatrixStack)matrixStack, (float)this.x, (float)this.y, (float)0.0f, (float)98.0f, (float)98.0f, (double)1.2f, () -> Float.valueOf(0.9f), (boolean)true, (boolean)false);
                }
                List ingredients = Lists.transform((List)this.recipe.getRelayInputs(), WrappedIngredient::getIngredient);
                float degreePerInput = 360.0f / (float)ingredients.size();
                int ticksElapsed = context.getTicksInBook();
                float currentDegree = (Screen.func_231173_s_() ? (float)ticksElapsed : (float)ticksElapsed + partialTicks) - 90.0f;
                for (Ingredient ingredient : ingredients) {
                    double radians = Math.toRadians(currentDegree);
                    double xPos = (double)(this.x + 3 + 38) + Math.cos(radians) * 48.0;
                    double yPos = (double)(this.y + 3 + 38) + Math.sin(radians) * 48.0;
                    matrixStack.func_227860_a_();
                    matrixStack.func_227861_a_(xPos - (double)MathHelper.func_76128_c((double)xPos), yPos - (double)MathHelper.func_76128_c((double)yPos), 0.0);
                    context.renderIngredient(matrixStack, MathHelper.func_76128_c((double)xPos), MathHelper.func_76128_c((double)yPos), mouseX, mouseY, ingredient);
                    matrixStack.func_227865_b_();
                    currentDegree += degreePerInput;
                }
            }
            for (int yy = 0; yy < 5; ++yy) {
                for (int xx = 0; xx < 5; ++xx) {
                    Ingredient ingredient = this.recipe.getInputs().getIngredient(yy * 5 + xx);
                    context.renderIngredient(matrixStack, this.x + 3 + xx * 19, this.y + 3 + yy * 19, mouseX, mouseY, ingredient);
                }
            }
        }
    }
}

