/*
 * Decompiled with CFR 0.152.
 */
package thelm.packagedastral.network.packet;

import hellfirepvp.astralsorcery.common.crafting.recipe.SimpleAltarRecipe;
import hellfirepvp.astralsorcery.common.lib.SoundsAS;
import hellfirepvp.astralsorcery.common.tile.altar.TileAltar;
import hellfirepvp.astralsorcery.common.util.sound.CategorizedSoundEvent;
import hellfirepvp.astralsorcery.common.util.sound.SoundHelper;
import java.util.function.Supplier;
import net.minecraft.client.Minecraft;
import net.minecraft.client.world.ClientWorld;
import net.minecraft.network.PacketBuffer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.RegistryKey;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.fml.network.NetworkEvent;
import net.minecraftforge.fml.network.PacketDistributor;
import thelm.packagedastral.network.PacketHandler;
import thelm.packagedastral.tile.IHasFakeAltar;
import thelm.packagedauto.util.MiscHelper;

public class FinishCraftEffectPacket {
    private BlockPos pos;
    private SimpleAltarRecipe recipe;
    private boolean doEffect;

    public FinishCraftEffectPacket(BlockPos pos, SimpleAltarRecipe recipe, boolean doEffect) {
        this.pos = pos;
        this.recipe = recipe;
        this.doEffect = doEffect;
    }

    public FinishCraftEffectPacket(BlockPos pos, ResourceLocation recipe, boolean doEffect) {
        this.pos = pos;
        this.recipe = MiscHelper.INSTANCE.getRecipeManager().func_215367_a(recipe).map(r -> (SimpleAltarRecipe)r).get();
        this.doEffect = doEffect;
    }

    public void encode(PacketBuffer buf) {
        buf.func_179255_a(this.pos);
        buf.func_192572_a(this.recipe.func_199560_c());
        buf.writeBoolean(this.doEffect);
    }

    public static FinishCraftEffectPacket decode(PacketBuffer buf) {
        return new FinishCraftEffectPacket(buf.func_179259_c(), buf.func_192575_l(), buf.readBoolean());
    }

    public void handle(Supplier<NetworkEvent.Context> ctx) {
        ctx.get().enqueueWork(() -> {
            ClientWorld world = Minecraft.func_71410_x().field_71441_e;
            if (world.func_195588_v(this.pos)) {
                TileEntity te = world.func_175625_s(this.pos);
                if (te instanceof IHasFakeAltar) {
                    TileAltar fakeAltar = ((IHasFakeAltar)te).getFakeAltar();
                    this.recipe.getCraftingEffects().forEach(effect -> {
                        try {
                            effect.onCraftingFinish(fakeAltar, false);
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                    });
                }
                SoundHelper.playSoundClientWorld((CategorizedSoundEvent)SoundsAS.ALTAR_CRAFT_FINISH, (BlockPos)this.pos, (float)0.6f, (float)1.0f);
            }
        });
        ctx.get().setPacketHandled(true);
    }

    public static void finishCraft(BlockPos pos, SimpleAltarRecipe recipe, boolean doEffect, RegistryKey<World> dimension, double range) {
        PacketHandler.INSTANCE.send(PacketDistributor.NEAR.with(() -> new PacketDistributor.TargetPoint((double)pos.func_177958_n() + 0.5, (double)pos.func_177956_o() + 0.5, (double)pos.func_177952_p() + 0.5, range, dimension)), (Object)new FinishCraftEffectPacket(pos, recipe, doEffect));
    }
}

