/*
 * Decompiled with CFR 0.152.
 */
package thelm.packagedastral.recipe;

import com.google.common.collect.ImmutableList;
import hellfirepvp.astralsorcery.common.lib.BlocksAS;
import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.ints.IntRBTreeSet;
import it.unimi.dsi.fastutil.ints.IntSet;
import java.util.List;
import java.util.Map;
import net.minecraft.item.ItemStack;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.vector.Vector3i;
import net.minecraft.util.text.IFormattableTextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import thelm.packagedastral.recipe.AttunementPackageRecipeInfo;
import thelm.packagedauto.api.IGuiIngredientWrapper;
import thelm.packagedauto.api.IPackageRecipeInfo;
import thelm.packagedauto.api.IPackageRecipeType;
import thelm.packagedauto.api.IRecipeLayoutWrapper;

public class AttunementPackageRecipeType
implements IPackageRecipeType {
    public static final AttunementPackageRecipeType INSTANCE;
    public static final ResourceLocation NAME;
    public static final IntSet SLOTS;
    public static final IntSet SLOTS_ALTAR;
    public static final List<ResourceLocation> CATEGORIES;
    public static final Vector3i COLOR;
    public static final Vector3i COLOR_DISABLED;

    protected AttunementPackageRecipeType() {
    }

    public ResourceLocation getName() {
        return NAME;
    }

    public IFormattableTextComponent getDisplayName() {
        return new TranslationTextComponent("recipe.packagedastral.attunement");
    }

    public IFormattableTextComponent getShortDisplayName() {
        return new TranslationTextComponent("recipe.packagedastral.attunement.short");
    }

    public IPackageRecipeInfo getNewRecipeInfo() {
        return new AttunementPackageRecipeInfo();
    }

    public IntSet getEnabledSlots() {
        return SLOTS;
    }

    public List<ResourceLocation> getJEICategories() {
        return CATEGORIES;
    }

    public Int2ObjectMap<ItemStack> getRecipeTransferMap(IRecipeLayoutWrapper recipeLayoutWrapper) {
        Int2ObjectOpenHashMap map = new Int2ObjectOpenHashMap();
        Map ingredients = recipeLayoutWrapper.getItemStackIngredients();
        int index = 0;
        int[] slotArray = SLOTS_ALTAR.toIntArray();
        for (Map.Entry entry : ingredients.entrySet()) {
            IGuiIngredientWrapper ingredient = (IGuiIngredientWrapper)entry.getValue();
            if (ingredient.isInput()) {
                ItemStack displayed = (ItemStack)((IGuiIngredientWrapper)entry.getValue()).getDisplayedIngredient();
                if (displayed != null && !displayed.func_190926_b()) {
                    map.put(slotArray[index], (Object)displayed);
                }
                ++index;
            }
            if (index < 25) continue;
            break;
        }
        return map;
    }

    public Object getRepresentation() {
        return new ItemStack((IItemProvider)BlocksAS.ALTAR_ATTUNEMENT);
    }

    public Vector3i getSlotColor(int slot) {
        if (!SLOTS.contains(slot) && slot != 85) {
            return COLOR_DISABLED;
        }
        return COLOR;
    }

    static {
        int j;
        int i;
        INSTANCE = new AttunementPackageRecipeType();
        NAME = new ResourceLocation("packagedastral:attunement");
        CATEGORIES = ImmutableList.of((Object)new ResourceLocation("astralsorcery:altar_attunement"), (Object)new ResourceLocation("astralsorcery:altar_discovery"));
        COLOR = new Vector3i(139, 139, 139);
        COLOR_DISABLED = new Vector3i(64, 64, 64);
        SLOTS_ALTAR = new IntRBTreeSet();
        for (i = 2; i < 7; ++i) {
            for (j = 2; j < 7; ++j) {
                SLOTS_ALTAR.add(9 * i + j);
            }
        }
        SLOTS = new IntRBTreeSet();
        for (i = 3; i < 6; ++i) {
            for (j = 3; j < 6; ++j) {
                SLOTS.add(9 * i + j);
            }
        }
        SLOTS.add(20);
        SLOTS.add(24);
        SLOTS.add(56);
        SLOTS.add(60);
    }
}

