/*
 * Decompiled with CFR 0.152.
 */
package thelm.packagedastral.recipe;

import hellfirepvp.astralsorcery.common.block.tile.altar.AltarType;
import hellfirepvp.astralsorcery.common.crafting.recipe.SimpleAltarRecipe;
import hellfirepvp.astralsorcery.common.lib.RecipeTypesAS;
import hellfirepvp.astralsorcery.common.tile.altar.TileAltar;
import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.ints.IntRBTreeSet;
import it.unimi.dsi.fastutil.ints.IntSet;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.stream.IntStream;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.ListNBT;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;
import net.minecraftforge.items.IItemHandlerModifiable;
import net.minecraftforge.items.ItemStackHandler;
import thelm.packagedastral.recipe.ConstellationPackageRecipeType;
import thelm.packagedastral.recipe.IAltarPackageRecipeInfo;
import thelm.packagedauto.api.IPackagePattern;
import thelm.packagedauto.api.IPackageRecipeInfo;
import thelm.packagedauto.api.IPackageRecipeType;
import thelm.packagedauto.util.MiscHelper;
import thelm.packagedauto.util.PackagePattern;

public class ConstellationPackageRecipeInfo
implements IAltarPackageRecipeInfo {
    public static final IntSet SLOTS_MATRIX = new IntRBTreeSet();
    SimpleAltarRecipe recipe;
    List<ItemStack> input = new ArrayList<ItemStack>();
    List<ItemStack> matrix = NonNullList.func_191197_a((int)21, (Object)ItemStack.field_190927_a);
    ItemStack output = ItemStack.field_190927_a;
    List<IPackagePattern> patterns = new ArrayList<IPackagePattern>();

    public void read(CompoundNBT nbt) {
        this.input.clear();
        this.patterns.clear();
        IRecipe recipe = MiscHelper.INSTANCE.getRecipeManager().func_215367_a(new ResourceLocation(nbt.func_74779_i("Recipe"))).orElse(null);
        MiscHelper.INSTANCE.loadAllItems(nbt.func_150295_c("Matrix", 10), this.matrix);
        this.output = ItemStack.func_199557_a((CompoundNBT)nbt.func_74775_l("Output"));
        if (recipe instanceof SimpleAltarRecipe) {
            this.recipe = (SimpleAltarRecipe)recipe;
        }
        this.input.addAll(MiscHelper.INSTANCE.condenseStacks(this.matrix));
        int i = 0;
        while (i * 9 < this.input.size()) {
            this.patterns.add((IPackagePattern)new PackagePattern((IPackageRecipeInfo)this, i));
            ++i;
        }
    }

    public CompoundNBT write(CompoundNBT nbt) {
        if (this.recipe != null) {
            nbt.func_74778_a("Recipe", this.recipe.func_199560_c().toString());
        }
        ListNBT matrixTag = MiscHelper.INSTANCE.saveAllItems(new ListNBT(), this.matrix);
        nbt.func_218657_a("Matrix", (INBT)matrixTag);
        nbt.func_218657_a("Output", (INBT)this.output.func_77955_b(new CompoundNBT()));
        return nbt;
    }

    public IPackageRecipeType getRecipeType() {
        return ConstellationPackageRecipeType.INSTANCE;
    }

    @Override
    public int getLevel() {
        return 2;
    }

    public boolean isValid() {
        return this.recipe != null;
    }

    public List<IPackagePattern> getPatterns() {
        return Collections.unmodifiableList(this.patterns);
    }

    public List<ItemStack> getInputs() {
        return Collections.unmodifiableList(this.input);
    }

    @Override
    public ItemStack getOutput() {
        return this.output.func_77946_l();
    }

    @Override
    public SimpleAltarRecipe getRecipe() {
        return this.recipe;
    }

    @Override
    public List<ItemStack> getMatrix() {
        return Collections.unmodifiableList(this.matrix);
    }

    @Override
    public List<ItemStack> getRelayInputs() {
        return Collections.emptyList();
    }

    @Override
    public List<ItemStack> getRemainingItems() {
        return MiscHelper.INSTANCE.getRemainingItems(this.matrix);
    }

    @Override
    public int getLevelRequired() {
        return this.recipe.getAltarType().ordinal();
    }

    @Override
    public int getTimeRequired() {
        return this.recipe.getDuration();
    }

    @Override
    public int getStarlightRequired() {
        return this.recipe.getStarlightRequirement();
    }

    public void generateFromStacks(List<ItemStack> input, List<ItemStack> output, World world) {
        this.recipe = null;
        this.input.clear();
        this.patterns.clear();
        TileAltar fakeAltar = new TileAltar().updateType(AltarType.CONSTELLATION, true);
        ItemStackHandler handler = new ItemStackHandler(25);
        int[] slotArray = ConstellationPackageRecipeType.SLOTS.toIntArray();
        int[] slotArray1 = SLOTS_MATRIX.toIntArray();
        for (int i = 0; i < 21; ++i) {
            ItemStack toSet = input.get(slotArray[i]);
            toSet.func_190920_e(1);
            this.matrix.set(i, toSet.func_77946_l());
            handler.setStackInSlot(slotArray1[i], toSet.func_77946_l());
        }
        for (SimpleAltarRecipe recipe : MiscHelper.INSTANCE.getRecipeManager().func_241447_a_(RecipeTypesAS.TYPE_ALTAR.getType())) {
            if (recipe.getAltarType().ordinal() > 2 || recipe.getFocusConstellation() != null || !recipe.getRelayInputs().isEmpty() || !recipe.getInputs().containsInputs((IItemHandlerModifiable)handler, true)) continue;
            try {
                List outputs = recipe.getOutputs(fakeAltar);
                if (outputs.isEmpty()) continue;
                this.output = (ItemStack)outputs.get(0);
            }
            catch (Exception e) {
                continue;
            }
            this.recipe = recipe;
            this.input.addAll(MiscHelper.INSTANCE.condenseStacks(this.matrix));
            int j = 0;
            while (j * 9 < this.input.size()) {
                this.patterns.add((IPackagePattern)new PackagePattern((IPackageRecipeInfo)this, j));
                ++j;
            }
            return;
        }
        this.matrix.clear();
    }

    public Int2ObjectMap<ItemStack> getEncoderStacks() {
        Int2ObjectOpenHashMap map = new Int2ObjectOpenHashMap();
        int[] slotArray = ConstellationPackageRecipeType.SLOTS.toIntArray();
        for (int i = 0; i < 21; ++i) {
            map.put(slotArray[i], (Object)this.matrix.get(i));
        }
        return map;
    }

    public boolean equals(Object obj) {
        if (obj instanceof ConstellationPackageRecipeInfo) {
            ConstellationPackageRecipeInfo other = (ConstellationPackageRecipeInfo)obj;
            return MiscHelper.INSTANCE.recipeEquals((IPackageRecipeInfo)this, (Object)this.recipe, (IPackageRecipeInfo)other, (Object)other.recipe);
        }
        return false;
    }

    public int hashCode() {
        return MiscHelper.INSTANCE.recipeHashCode((IPackageRecipeInfo)this, (Object)this.recipe);
    }

    static {
        IntStream.range(0, 25).forEach(arg_0 -> ((IntSet)SLOTS_MATRIX).add(arg_0));
        SLOTS_MATRIX.remove(2);
        SLOTS_MATRIX.remove(10);
        SLOTS_MATRIX.remove(14);
        SLOTS_MATRIX.remove(22);
    }
}

