/*
 * Decompiled with CFR 0.152.
 */
package thelm.packagedastral.recipe;

import com.google.common.collect.Lists;
import hellfirepvp.astralsorcery.common.block.tile.altar.AltarType;
import hellfirepvp.astralsorcery.common.crafting.helper.WrappedIngredient;
import hellfirepvp.astralsorcery.common.crafting.recipe.SimpleAltarRecipe;
import hellfirepvp.astralsorcery.common.lib.RecipeTypesAS;
import hellfirepvp.astralsorcery.common.tile.altar.TileAltar;
import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectOpenHashMap;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.ListNBT;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;
import net.minecraftforge.common.util.RecipeMatcher;
import net.minecraftforge.items.IItemHandlerModifiable;
import net.minecraftforge.items.ItemStackHandler;
import thelm.packagedastral.recipe.IAltarPackageRecipeInfo;
import thelm.packagedastral.recipe.TraitPackageRecipeType;
import thelm.packagedauto.api.IPackagePattern;
import thelm.packagedauto.api.IPackageRecipeInfo;
import thelm.packagedauto.api.IPackageRecipeType;
import thelm.packagedauto.util.MiscHelper;
import thelm.packagedauto.util.PackagePattern;

public class TraitPackageRecipeInfo
implements IAltarPackageRecipeInfo {
    SimpleAltarRecipe recipe;
    List<ItemStack> input = new ArrayList<ItemStack>();
    List<ItemStack> matrix = NonNullList.func_191197_a((int)25, (Object)ItemStack.field_190927_a);
    List<ItemStack> inputRelay = new ArrayList<ItemStack>();
    ItemStack output = ItemStack.field_190927_a;
    List<IPackagePattern> patterns = new ArrayList<IPackagePattern>();

    public void read(CompoundNBT nbt) {
        this.input.clear();
        this.patterns.clear();
        IRecipe recipe = MiscHelper.INSTANCE.getRecipeManager().func_215367_a(new ResourceLocation(nbt.func_74779_i("Recipe"))).orElse(null);
        MiscHelper.INSTANCE.loadAllItems(nbt.func_150295_c("Matrix", 10), this.matrix);
        MiscHelper.INSTANCE.loadAllItems(nbt.func_150295_c("InputRelay", 10), this.inputRelay);
        this.output = ItemStack.func_199557_a((CompoundNBT)nbt.func_74775_l("Output"));
        ArrayList<ItemStack> toCondense = new ArrayList<ItemStack>(this.matrix);
        toCondense.addAll(this.inputRelay);
        if (recipe instanceof SimpleAltarRecipe) {
            this.recipe = (SimpleAltarRecipe)recipe;
        }
        this.input.addAll(MiscHelper.INSTANCE.condenseStacks(toCondense));
        int i = 0;
        while (i * 9 < this.input.size()) {
            this.patterns.add((IPackagePattern)new PackagePattern((IPackageRecipeInfo)this, i));
            ++i;
        }
    }

    public CompoundNBT write(CompoundNBT nbt) {
        if (this.recipe != null) {
            nbt.func_74778_a("Recipe", this.recipe.func_199560_c().toString());
        }
        ListNBT matrixTag = MiscHelper.INSTANCE.saveAllItems(new ListNBT(), this.matrix);
        ListNBT inputRelayTag = MiscHelper.INSTANCE.saveAllItems(new ListNBT(), this.inputRelay);
        nbt.func_218657_a("Matrix", (INBT)matrixTag);
        nbt.func_218657_a("InputRelay", (INBT)inputRelayTag);
        nbt.func_218657_a("Output", (INBT)this.output.func_77955_b(new CompoundNBT()));
        return nbt;
    }

    public IPackageRecipeType getRecipeType() {
        return TraitPackageRecipeType.INSTANCE;
    }

    @Override
    public int getLevel() {
        return 3;
    }

    public boolean isValid() {
        return this.recipe != null;
    }

    public List<IPackagePattern> getPatterns() {
        return Collections.unmodifiableList(this.patterns);
    }

    public List<ItemStack> getInputs() {
        return Collections.unmodifiableList(this.input);
    }

    @Override
    public ItemStack getOutput() {
        return this.output.func_77946_l();
    }

    @Override
    public SimpleAltarRecipe getRecipe() {
        return this.recipe;
    }

    @Override
    public List<ItemStack> getMatrix() {
        return Collections.unmodifiableList(this.matrix);
    }

    @Override
    public List<ItemStack> getRelayInputs() {
        return Collections.unmodifiableList(this.inputRelay);
    }

    @Override
    public List<ItemStack> getRemainingItems() {
        return MiscHelper.INSTANCE.getRemainingItems(this.matrix);
    }

    @Override
    public int getLevelRequired() {
        return this.recipe.getAltarType().ordinal();
    }

    @Override
    public int getTimeRequired() {
        return this.recipe.getDuration();
    }

    @Override
    public int getStarlightRequired() {
        return this.recipe.getStarlightRequirement();
    }

    public void generateFromStacks(List<ItemStack> input, List<ItemStack> output, World world) {
        ItemStack toSet;
        int i;
        this.recipe = null;
        this.inputRelay.clear();
        this.input.clear();
        this.patterns.clear();
        TileAltar fakeAltar = new TileAltar().updateType(AltarType.RADIANCE, true);
        ItemStackHandler handler = new ItemStackHandler(25);
        int[] slotArray = TraitPackageRecipeType.SLOTS.toIntArray();
        for (i = 0; i < 25; ++i) {
            toSet = input.get(slotArray[i]);
            toSet.func_190920_e(1);
            this.matrix.set(i, toSet.func_77946_l());
            handler.setStackInSlot(i, toSet.func_77946_l());
        }
        for (i = 25; i < 73; ++i) {
            toSet = input.get(slotArray[i]);
            if (toSet.func_190926_b()) continue;
            toSet.func_190920_e(1);
            this.inputRelay.add(toSet.func_77946_l());
        }
        for (SimpleAltarRecipe recipe : MiscHelper.INSTANCE.getRecipeManager().func_241447_a_(RecipeTypesAS.TYPE_ALTAR.getType())) {
            if (!recipe.getInputs().containsInputs((IItemHandlerModifiable)handler, true)) continue;
            List matchers = Lists.transform((List)recipe.getRelayInputs(), WrappedIngredient::getIngredient);
            if ((!this.inputRelay.isEmpty() || !matchers.isEmpty()) && RecipeMatcher.findMatches(this.inputRelay, (List)matchers) == null) continue;
            try {
                List outputs = recipe.getOutputs(fakeAltar);
                if (outputs.isEmpty()) continue;
                this.output = (ItemStack)outputs.get(0);
            }
            catch (Exception e) {
                continue;
            }
            this.recipe = recipe;
            this.input.addAll(MiscHelper.INSTANCE.condenseStacks(this.matrix));
            int j = 0;
            while (j * 9 < this.input.size()) {
                this.patterns.add((IPackagePattern)new PackagePattern((IPackageRecipeInfo)this, j));
                ++j;
            }
            return;
        }
        this.matrix.clear();
    }

    public Int2ObjectMap<ItemStack> getEncoderStacks() {
        int i;
        Int2ObjectOpenHashMap map = new Int2ObjectOpenHashMap();
        int[] slotArray = TraitPackageRecipeType.SLOTS.toIntArray();
        for (i = 0; i < 25; ++i) {
            map.put(slotArray[i], (Object)this.matrix.get(i));
        }
        for (i = 0; i < this.inputRelay.size(); ++i) {
            map.put(slotArray[i + 25], (Object)this.inputRelay.get(i));
        }
        return map;
    }

    public boolean equals(Object obj) {
        if (obj instanceof TraitPackageRecipeInfo) {
            TraitPackageRecipeInfo other = (TraitPackageRecipeInfo)obj;
            return MiscHelper.INSTANCE.recipeEquals((IPackageRecipeInfo)this, (Object)this.recipe, (IPackageRecipeInfo)other, (Object)other.recipe);
        }
        return false;
    }

    public int hashCode() {
        return MiscHelper.INSTANCE.recipeHashCode((IPackageRecipeInfo)this, (Object)this.recipe);
    }
}

