/*
 * Decompiled with CFR 0.152.
 */
package thelm.packagedastral.recipe;

import com.google.common.collect.ImmutableList;
import hellfirepvp.astralsorcery.common.lib.BlocksAS;
import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.ints.IntCollection;
import it.unimi.dsi.fastutil.ints.IntLinkedOpenHashSet;
import it.unimi.dsi.fastutil.ints.IntRBTreeSet;
import it.unimi.dsi.fastutil.ints.IntSet;
import java.util.List;
import java.util.Map;
import net.minecraft.item.ItemStack;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.vector.Vector3i;
import net.minecraft.util.text.IFormattableTextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import thelm.packagedastral.recipe.TraitPackageRecipeInfo;
import thelm.packagedauto.api.IGuiIngredientWrapper;
import thelm.packagedauto.api.IPackageRecipeInfo;
import thelm.packagedauto.api.IPackageRecipeType;
import thelm.packagedauto.api.IRecipeLayoutWrapper;

public class TraitPackageRecipeType
implements IPackageRecipeType {
    public static final TraitPackageRecipeType INSTANCE;
    public static final ResourceLocation NAME;
    public static final IntSet SLOTS;
    public static final IntSet SLOTS_ALTAR;
    public static final List<ResourceLocation> CATEGORIES;
    public static final Vector3i COLOR;
    public static final Vector3i COLOR_RELAY;
    public static final Vector3i COLOR_DISABLED;

    protected TraitPackageRecipeType() {
    }

    public ResourceLocation getName() {
        return NAME;
    }

    public IFormattableTextComponent getDisplayName() {
        return new TranslationTextComponent("recipe.packagedastral.trait");
    }

    public IFormattableTextComponent getShortDisplayName() {
        return new TranslationTextComponent("recipe.packagedastral.trait.short");
    }

    public IPackageRecipeInfo getNewRecipeInfo() {
        return new TraitPackageRecipeInfo();
    }

    public IntSet getEnabledSlots() {
        return SLOTS;
    }

    public List<ResourceLocation> getJEICategories() {
        return CATEGORIES;
    }

    public Int2ObjectMap<ItemStack> getRecipeTransferMap(IRecipeLayoutWrapper recipeLayoutWrapper) {
        Int2ObjectOpenHashMap map = new Int2ObjectOpenHashMap();
        Map ingredients = recipeLayoutWrapper.getItemStackIngredients();
        int index = 0;
        int[] slotArray = SLOTS.toIntArray();
        for (Map.Entry entry : ingredients.entrySet()) {
            IGuiIngredientWrapper ingredient = (IGuiIngredientWrapper)entry.getValue();
            if (ingredient.isInput()) {
                ItemStack displayed = (ItemStack)((IGuiIngredientWrapper)entry.getValue()).getDisplayedIngredient();
                if (displayed != null && !displayed.func_190926_b()) {
                    map.put(slotArray[index], (Object)displayed);
                }
                ++index;
            }
            if (index < 73) continue;
            break;
        }
        return map;
    }

    public Object getRepresentation() {
        return new ItemStack((IItemProvider)BlocksAS.ALTAR_RADIANCE);
    }

    public Vector3i getSlotColor(int slot) {
        if (!SLOTS.contains(slot) && slot != 85) {
            return COLOR_DISABLED;
        }
        if (!SLOTS_ALTAR.contains(slot) && slot != 85) {
            return COLOR_RELAY;
        }
        return COLOR;
    }

    static {
        int j;
        int i;
        INSTANCE = new TraitPackageRecipeType();
        NAME = new ResourceLocation("packagedastral:trait");
        CATEGORIES = ImmutableList.of((Object)new ResourceLocation("astralsorcery:altar_trait"), (Object)new ResourceLocation("astralsorcery:altar_constellation"), (Object)new ResourceLocation("astralsorcery:altar_attunement"), (Object)new ResourceLocation("astralsorcery:altar_discovery"));
        COLOR = new Vector3i(139, 139, 139);
        COLOR_RELAY = new Vector3i(179, 179, 139);
        COLOR_DISABLED = new Vector3i(64, 64, 64);
        SLOTS_ALTAR = new IntRBTreeSet();
        for (i = 2; i < 7; ++i) {
            for (j = 2; j < 7; ++j) {
                SLOTS_ALTAR.add(9 * i + j);
            }
        }
        SLOTS = new IntLinkedOpenHashSet((IntCollection)SLOTS_ALTAR);
        for (i = 0; i < 2; ++i) {
            for (j = 1; j < 8; ++j) {
                SLOTS.add(9 * i + j);
            }
        }
        for (i = 2; i < 7; ++i) {
            SLOTS.add(9 * i);
            SLOTS.add(9 * i + 1);
            SLOTS.add(9 * i + 7);
            SLOTS.add(9 * i + 8);
        }
        for (i = 7; i < 9; ++i) {
            for (j = 1; j < 8; ++j) {
                SLOTS.add(9 * i + j);
            }
        }
    }
}

