/*
 * Decompiled with CFR 0.152.
 */
package thelm.packagedastral.starlight;

import hellfirepvp.astralsorcery.common.constellation.IWeakConstellation;
import hellfirepvp.astralsorcery.common.starlight.transmission.IPrismTransmissionNode;
import hellfirepvp.astralsorcery.common.starlight.transmission.ITransmissionReceiver;
import hellfirepvp.astralsorcery.common.starlight.transmission.registry.TransmissionProvider;
import hellfirepvp.astralsorcery.common.util.nbt.NBTHelper;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.ListNBT;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import thelm.packagedastral.starlight.IStarlightReceiverLinkableTile;

public class TransmissionReceiverLinkableTile
implements ITransmissionReceiver {
    private BlockPos pos;
    private Set<BlockPos> sourcesToThis = new HashSet<BlockPos>();

    public TransmissionReceiverLinkableTile(BlockPos pos) {
        this.pos = pos;
    }

    public void onStarlightReceive(World world, IWeakConstellation type, double amount) {
        TileEntity tile = world.func_175625_s(this.pos);
        if (tile instanceof IStarlightReceiverLinkableTile) {
            ((IStarlightReceiverLinkableTile)tile).receiveStarlight(type, amount);
        }
    }

    public BlockPos getLocationPos() {
        return this.pos;
    }

    public void notifySourceLink(World world, BlockPos source) {
        this.sourcesToThis.add(source);
    }

    public void notifySourceUnlink(World world, BlockPos source) {
        this.sourcesToThis.remove(source);
    }

    public boolean notifyBlockChange(World world, BlockPos changed) {
        return false;
    }

    public List<BlockPos> getSources() {
        return new LinkedList<BlockPos>(this.sourcesToThis);
    }

    public TransmissionProvider getProvider() {
        return new Provider();
    }

    public void readFromNBT(CompoundNBT nbt) {
        this.sourcesToThis.clear();
        this.pos = NBTHelper.readBlockPosFromNBT((CompoundNBT)nbt);
        ListNBT list = nbt.func_150295_c("Sources", 10);
        for (int i = 0; i < list.size(); ++i) {
            this.sourcesToThis.add(NBTHelper.readBlockPosFromNBT((CompoundNBT)list.func_150305_b(i)));
        }
    }

    public void writeToNBT(CompoundNBT compound) {
        NBTHelper.writeBlockPosToNBT((BlockPos)this.pos, (CompoundNBT)compound);
        ListNBT sources = new ListNBT();
        for (BlockPos source : this.sourcesToThis) {
            CompoundNBT comp = new CompoundNBT();
            NBTHelper.writeBlockPosToNBT((BlockPos)source, (CompoundNBT)comp);
            sources.add((Object)comp);
        }
        compound.func_218657_a("Sources", (INBT)sources);
    }

    public static class Provider
    extends TransmissionProvider {
        public IPrismTransmissionNode get() {
            return new TransmissionReceiverLinkableTile(null);
        }

        public ResourceLocation getIdentifier() {
            return new ResourceLocation("packagedastral:transmission_receiver_linkable");
        }
    }
}

