/*
 * Decompiled with CFR 0.152.
 */
package thelm.packagedastral.tile;

import hellfirepvp.astralsorcery.client.util.sound.PositionedLoopSound;
import hellfirepvp.astralsorcery.common.block.tile.altar.AltarType;
import hellfirepvp.astralsorcery.common.constellation.IWeakConstellation;
import hellfirepvp.astralsorcery.common.constellation.SkyHandler;
import hellfirepvp.astralsorcery.common.constellation.world.DayTimeHelper;
import hellfirepvp.astralsorcery.common.crafting.recipe.SimpleAltarRecipe;
import hellfirepvp.astralsorcery.common.crafting.recipe.altar.ActiveSimpleAltarRecipe;
import hellfirepvp.astralsorcery.common.entity.EntityFlare;
import hellfirepvp.astralsorcery.common.lib.SoundsAS;
import hellfirepvp.astralsorcery.common.starlight.IStarlightTransmission;
import hellfirepvp.astralsorcery.common.starlight.WorldNetworkHandler;
import hellfirepvp.astralsorcery.common.starlight.network.StarlightUpdateHandler;
import hellfirepvp.astralsorcery.common.starlight.transmission.IPrismTransmissionNode;
import hellfirepvp.astralsorcery.common.tile.altar.AltarCollectionCategory;
import hellfirepvp.astralsorcery.common.tile.altar.TileAltar;
import hellfirepvp.astralsorcery.common.util.MiscUtils;
import hellfirepvp.astralsorcery.common.util.data.Vector3;
import hellfirepvp.astralsorcery.common.util.sound.SoundHelper;
import hellfirepvp.astralsorcery.common.util.world.SkyCollectionHelper;
import it.unimi.dsi.fastutil.objects.Object2FloatMap;
import it.unimi.dsi.fastutil.objects.Object2FloatOpenHashMap;
import java.lang.reflect.Field;
import java.util.List;
import java.util.Random;
import java.util.UUID;
import java.util.function.Supplier;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.inventory.container.Container;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.tileentity.ITickableTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.Direction;
import net.minecraft.util.RegistryKey;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.ISeedReader;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.energy.CapabilityEnergy;
import net.minecraftforge.energy.IEnergyStorage;
import net.minecraftforge.fml.ModList;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemHandlerHelper;
import thelm.packagedastral.block.DiscoveryCrafterBlock;
import thelm.packagedastral.container.DiscoveryCrafterContainer;
import thelm.packagedastral.integration.appeng.tile.AEDiscoveryCrafterTile;
import thelm.packagedastral.inventory.DiscoveryCrafterItemHandler;
import thelm.packagedastral.network.packet.FinishCraftEffectPacket;
import thelm.packagedastral.recipe.IAltarPackageRecipeInfo;
import thelm.packagedastral.tile.IAltarCrafter;
import thelm.packagedastral.tile.MarkedRelayTile;
import thelm.packagedauto.api.IPackageCraftingMachine;
import thelm.packagedauto.api.IPackageRecipeInfo;
import thelm.packagedauto.energy.EnergyStorage;
import thelm.packagedauto.tile.BaseTile;
import thelm.packagedauto.tile.UnpackagerTile;
import thelm.packagedauto.util.MiscHelper;

public class DiscoveryCrafterTile
extends BaseTile
implements ITickableTileEntity,
IPackageCraftingMachine,
IAltarCrafter {
    public static final TileEntityType<DiscoveryCrafterTile> TYPE_INSTANCE = (TileEntityType)TileEntityType.Builder.func_223042_a((Supplier)MiscHelper.INSTANCE.conditionalSupplier(() -> ModList.get().isLoaded("appliedenergistics2"), () -> AEDiscoveryCrafterTile::new, () -> DiscoveryCrafterTile::new), (Block[])new Block[]{DiscoveryCrafterBlock.INSTANCE}).func_206865_a(null).setRegistryName("packagedastral:discovery_crafter");
    public static final Random RANDOM = new Random();
    public static int energyCapacity = 5000;
    public static int energyReq = 500;
    public static int energyUsage = 100;
    public static int starlightCapacity = 1000;
    public static boolean craftingEffects = true;
    public static boolean drawMEEnergy = true;
    public boolean firstTick = true;
    public boolean doesSeeSky = false;
    public float posDistribution = -1.0f;
    public TileAltar fakeAltar = new TileAltar().updateType(AltarType.DISCOVERY, true);
    public SimpleAltarRecipe effectRecipe = null;
    public Object clientCraftSound = null;
    public int starlight = 0;
    public Object2FloatMap<AltarCollectionCategory> tickStarlightCollectionMap = new Object2FloatOpenHashMap();
    public boolean isWorking = false;
    public int progress = 0;
    public int progressReq = 0;
    public int remainingProgress = 0;
    public int starlightReq = 0;
    public IAltarPackageRecipeInfo currentRecipe;

    public DiscoveryCrafterTile() {
        super(TYPE_INSTANCE);
        this.setItemHandler(new DiscoveryCrafterItemHandler(this));
        this.setEnergyStorage(new EnergyStorage((BaseTile)this, energyCapacity));
    }

    protected ITextComponent getDefaultName() {
        return new TranslationTextComponent("block.packagedastral.discovery_crafter");
    }

    public void func_226984_a_(World world, BlockPos pos) {
        super.func_226984_a_(world, pos);
        this.fakeAltar.func_226984_a_(world, pos);
    }

    public void func_174878_a(BlockPos pos) {
        super.func_174878_a(pos);
        this.fakeAltar.func_174878_a(pos);
    }

    public void func_73660_a() {
        if (this.firstTick) {
            this.firstTick = false;
            if (!this.field_145850_b.field_72995_K) {
                WorldNetworkHandler handler = WorldNetworkHandler.getNetworkHandler((World)this.field_145850_b);
                handler.addTransmissionTile((IStarlightTransmission)this);
                IPrismTransmissionNode node = handler.getTransmissionNode(this.field_174879_c);
                if (node != null && node.needsUpdate()) {
                    StarlightUpdateHandler.getInstance().addNode(this.field_145850_b, node);
                }
                MarkedRelayTile.updateNearbyAltarPos(this.field_145850_b, this.field_174879_c);
            }
        }
        if (this.field_145850_b.func_82737_E() % 16L == 0L) {
            this.doesSeeSky = MiscUtils.canSeeSky((World)this.field_145850_b, (BlockPos)this.field_174879_c.func_177984_a(), (boolean)true, (boolean)this.doesSeeSky);
        }
        if (!this.field_145850_b.field_72995_K) {
            if (this.isWorking) {
                this.tickProcess();
                if (this.remainingProgress <= 0) {
                    this.energyStorage.receiveEnergy(Math.abs(this.remainingProgress), false);
                    this.finishProcess();
                    this.ejectItems();
                }
            }
            this.gatherStarlight();
            this.chargeEnergy();
            if (this.field_145850_b.func_82737_E() % 8L == 0L) {
                this.ejectItems();
            }
        } else {
            this.clientTick();
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    protected void clientTick() {
        if (this.isWorking) {
            if (craftingEffects && this.effectRecipe != null) {
                this.effectRecipe.getCraftingEffects().forEach(effect -> {
                    try {
                        effect.onTick(this.fakeAltar, ActiveSimpleAltarRecipe.CraftingState.ACTIVE);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                });
            }
            if (Minecraft.func_71410_x().field_71474_y.func_186711_a(SoundCategory.BLOCKS) > 0.0f) {
                if (this.clientCraftSound == null || ((PositionedLoopSound)this.clientCraftSound).hasStoppedPlaying()) {
                    this.clientCraftSound = SoundHelper.playSoundLoopFadeInClient((SoundEvent)SoundsAS.ALTAR_CRAFT_LOOP_T1, (Vector3)new Vector3((TileEntity)this).add(0.5, 0.5, 0.5), (float)0.6f, (float)1.0f, (boolean)false, s -> this.func_145837_r() || SoundHelper.getSoundVolume((SoundCategory)SoundCategory.BLOCKS) <= 0.0f || !this.isWorking).setFadeInTicks(40.0f).setFadeOutTicks(20.0f);
                }
            } else {
                this.clientCraftSound = null;
            }
        }
    }

    public void func_145843_s() {
        if (this.field_145850_b != null && !this.field_145850_b.field_72995_K) {
            WorldNetworkHandler handler = WorldNetworkHandler.getNetworkHandler((World)this.field_145850_b);
            IPrismTransmissionNode node = handler.getTransmissionNode(this.field_174879_c);
            if (node != null) {
                StarlightUpdateHandler.getInstance().removeNode(this.field_145850_b, node);
            }
            handler.removeTransmission((IStarlightTransmission)this);
        }
    }

    public boolean acceptPackage(IPackageRecipeInfo recipeInfo, List<ItemStack> stacks, Direction direction) {
        IAltarPackageRecipeInfo recipe;
        if (!this.isBusy() && recipeInfo.isValid() && recipeInfo instanceof IAltarPackageRecipeInfo && (recipe = (IAltarPackageRecipeInfo)recipeInfo).getLevel() == 0) {
            ItemStack slotStack = this.itemHandler.getStackInSlot(9);
            ItemStack outputStack = recipe.getOutput();
            if (slotStack.func_190926_b() || slotStack.func_77973_b() == outputStack.func_77973_b() && ItemStack.func_77970_a((ItemStack)slotStack, (ItemStack)outputStack) && slotStack.func_190916_E() + outputStack.func_190916_E() <= outputStack.func_77976_d()) {
                this.currentRecipe = recipe;
                this.effectRecipe = recipe.getRecipe();
                this.isWorking = true;
                this.progressReq = recipe.getTimeRequired() / (int)Math.round(2.0 * Math.pow(2.0, Math.max(0, 0 - recipe.getLevelRequired())));
                this.remainingProgress = energyReq;
                this.starlightReq = recipe.getStarlightRequired();
                for (int i = 0; i < 9; ++i) {
                    this.itemHandler.setStackInSlot(i, recipe.getMatrix().get(i).func_77946_l());
                }
                SoundHelper.playSoundAround((SoundEvent)SoundsAS.ALTAR_CRAFT_START, (SoundCategory)SoundCategory.BLOCKS, (World)this.field_145850_b, (Vector3)new Vector3((TileEntity)this).add(0.5, 0.5, 0.5), (float)0.6f, (float)1.0f);
                this.syncTile(false);
                this.func_70296_d();
                return true;
            }
        }
        return false;
    }

    public boolean isBusy() {
        return this.isWorking || !this.itemHandler.getStacks().subList(0, 9).stream().allMatch(ItemStack::func_190926_b);
    }

    protected void tickProcess() {
        if (this.starlight >= this.starlightReq) {
            ++this.progress;
            if (this.progress >= this.progressReq) {
                this.progress = this.progressReq;
                int energy = this.energyStorage.extractEnergy(energyUsage, false);
                this.remainingProgress -= energy;
            }
        }
    }

    protected void finishProcess() {
        if (this.currentRecipe == null) {
            this.endProcess();
            return;
        }
        if (this.itemHandler.getStackInSlot(9).func_190926_b()) {
            this.itemHandler.setStackInSlot(9, this.currentRecipe.getOutput());
        } else {
            this.itemHandler.getStackInSlot(9).func_190917_f(this.currentRecipe.getOutput().func_190916_E());
        }
        List<ItemStack> remainingItems = this.currentRecipe.getRemainingItems();
        for (int i = 0; i < 9; ++i) {
            this.itemHandler.setStackInSlot(i, remainingItems.get(i));
        }
        FinishCraftEffectPacket.finishCraft(this.field_174879_c, this.effectRecipe, craftingEffects, (RegistryKey<World>)this.field_145850_b.func_234923_W_(), 32.0);
        EntityFlare.spawnAmbientFlare((World)this.field_145850_b, (BlockPos)this.field_174879_c.func_177982_a(-3 + RANDOM.nextInt(7), 1 + RANDOM.nextInt(3), -3 + RANDOM.nextInt(7)));
        EntityFlare.spawnAmbientFlare((World)this.field_145850_b, (BlockPos)this.field_174879_c.func_177982_a(-3 + RANDOM.nextInt(7), 1 + RANDOM.nextInt(3), -3 + RANDOM.nextInt(7)));
        this.endProcess();
    }

    public void endProcess() {
        this.progressReq = 0;
        this.progress = 0;
        this.remainingProgress = 0;
        this.starlightReq = 0;
        this.isWorking = false;
        this.effectRecipe = null;
        this.currentRecipe = null;
        this.syncTile(false);
        this.func_70296_d();
    }

    protected void ejectItems() {
        int endIndex = this.isWorking ? 9 : 0;
        for (Direction direction : Direction.values()) {
            TileEntity tile = this.field_145850_b.func_175625_s(this.field_174879_c.func_177972_a(direction));
            if (tile == null || tile instanceof UnpackagerTile || !tile.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, direction.func_176734_d()).isPresent()) continue;
            IItemHandler itemHandler = (IItemHandler)tile.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, direction.func_176734_d()).resolve().get();
            for (int i = 9; i >= endIndex; --i) {
                ItemStack stack = this.itemHandler.getStackInSlot(i);
                if (stack.func_190926_b()) continue;
                ItemStack stackRem = ItemHandlerHelper.insertItem((IItemHandler)itemHandler, (ItemStack)stack, (boolean)false);
                this.itemHandler.setStackInSlot(i, stackRem);
            }
        }
    }

    protected void chargeEnergy() {
        ItemStack energyStack = this.itemHandler.getStackInSlot(10);
        if (energyStack.getCapability(CapabilityEnergy.ENERGY, null).isPresent()) {
            int energyRequest = Math.min(this.energyStorage.getMaxReceive(), this.energyStorage.getMaxEnergyStored() - this.energyStorage.getEnergyStored());
            this.energyStorage.receiveEnergy(((IEnergyStorage)energyStack.getCapability(CapabilityEnergy.ENERGY).resolve().get()).extractEnergy(energyRequest, false), false);
            if (energyStack.func_190916_E() <= 0) {
                this.itemHandler.setStackInSlot(10, ItemStack.field_190927_a);
            }
        }
    }

    @Override
    public void receiveStarlight(IWeakConstellation type, double amount) {
        this.collectStarlight((float)amount * 60.0f, AltarCollectionCategory.FOCUSED_NETWORK);
    }

    protected void gatherStarlight() {
        this.tickStarlightCollectionMap.clear();
        this.starlight = (int)((float)this.starlight * 0.9f);
        if (this.doesSeeSky && SkyHandler.getContext((World)this.field_145850_b) != null) {
            float heightAmount = MathHelper.func_76131_a((float)((float)Math.pow((float)this.field_174879_c.func_177956_o() / 7.0f, 1.5) / 65.0f), (float)0.0f, (float)1.0f);
            this.collectStarlight((heightAmount *= DayTimeHelper.getCurrentDaytimeDistribution((World)this.field_145850_b)) * 60.0f, AltarCollectionCategory.HEIGHT);
            if (this.posDistribution == -1.0f) {
                this.posDistribution = this.field_145850_b instanceof ISeedReader ? SkyCollectionHelper.getSkyNoiseDistribution((ISeedReader)((ISeedReader)this.field_145850_b), (BlockPos)this.field_174879_c) : 0.3f;
            }
            float fieldAmount = MathHelper.func_76129_c((float)this.posDistribution);
            this.collectStarlight((fieldAmount *= DayTimeHelper.getCurrentDaytimeDistribution((World)this.field_145850_b)) * 65.0f, AltarCollectionCategory.FOSIC_FIELD);
        }
    }

    @Override
    public void collectStarlight(float percent, AltarCollectionCategory category) {
        int collectable = MathHelper.func_76141_d((float)Math.min(percent, this.getRemainingCollectionCapacity(category)));
        this.starlight = MathHelper.func_76125_a((int)(this.starlight + collectable), (int)0, (int)starlightCapacity);
        this.tickStarlightCollectionMap.computeIfPresent((Object)category, (cat, remaining) -> Float.valueOf(Math.max(remaining.floatValue() - (float)collectable, 0.0f)));
        this.func_70296_d();
    }

    public float getRemainingCollectionCapacity(AltarCollectionCategory category) {
        return ((Float)this.tickStarlightCollectionMap.computeIfAbsent((Object)category, this::getCollectionCap)).floatValue();
    }

    public float getCollectionCap(AltarCollectionCategory category) {
        return (float)starlightCapacity / 8.5f;
    }

    @Override
    public TileAltar getFakeAltar() {
        return this.fakeAltar;
    }

    public int getComparatorSignal() {
        if (this.isWorking) {
            return 1;
        }
        if (!this.itemHandler.getStacks().subList(0, 10).stream().allMatch(ItemStack::func_190926_b)) {
            return 15;
        }
        return 0;
    }

    public void func_230337_a_(BlockState blockState, CompoundNBT nbt) {
        CompoundNBT tag;
        IPackageRecipeInfo recipe;
        super.func_230337_a_(blockState, nbt);
        this.starlight = nbt.func_74762_e("Starlight");
        this.progressReq = nbt.func_74762_e("ProgressReq");
        this.progress = nbt.func_74762_e("Progress");
        this.remainingProgress = nbt.func_74762_e("EnergyProgress");
        this.starlightReq = nbt.func_74762_e("StarlightReq");
        this.currentRecipe = null;
        if (nbt.func_74764_b("Recipe") && (recipe = MiscHelper.INSTANCE.readRecipe(tag = nbt.func_74775_l("Recipe"))) instanceof IAltarPackageRecipeInfo && ((IAltarPackageRecipeInfo)recipe).getLevel() == 0) {
            this.currentRecipe = (IAltarPackageRecipeInfo)recipe;
        }
    }

    public CompoundNBT func_189515_b(CompoundNBT nbt) {
        super.func_189515_b(nbt);
        nbt.func_74768_a("Starlight", this.starlight);
        nbt.func_74768_a("ProgressReq", this.progressReq);
        nbt.func_74768_a("Progress", this.progress);
        nbt.func_74768_a("EnergyProgress", this.remainingProgress);
        nbt.func_74768_a("StarlightReq", this.starlightReq);
        if (this.currentRecipe != null) {
            CompoundNBT tag = MiscHelper.INSTANCE.writeRecipe(new CompoundNBT(), (IPackageRecipeInfo)this.currentRecipe);
            nbt.func_218657_a("Recipe", (INBT)tag);
        }
        return nbt;
    }

    public void readSync(CompoundNBT nbt) {
        IRecipe recipe;
        super.readSync(nbt);
        this.isWorking = nbt.func_74767_n("Working");
        this.effectRecipe = null;
        if (nbt.func_74764_b("EffectRecipe") && (recipe = (IRecipe)MiscHelper.INSTANCE.getRecipeManager().func_215367_a(new ResourceLocation(nbt.func_74779_i("EffectRecipe"))).orElse(null)) instanceof SimpleAltarRecipe) {
            this.effectRecipe = (SimpleAltarRecipe)recipe;
        }
        ActiveSimpleAltarRecipe fakeActiveRecipe = this.effectRecipe == null ? null : new ActiveSimpleAltarRecipe(this.effectRecipe, 1, UUID.randomUUID());
        try {
            Field activeRecipeField = TileAltar.class.getDeclaredField("activeRecipe");
            activeRecipeField.setAccessible(true);
            activeRecipeField.set(this.fakeAltar, fakeActiveRecipe);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public CompoundNBT writeSync(CompoundNBT nbt) {
        super.writeSync(nbt);
        nbt.func_74757_a("Working", this.isWorking);
        if (this.effectRecipe != null) {
            nbt.func_74778_a("EffectRecipe", this.effectRecipe.func_199560_c().toString());
        }
        return nbt;
    }

    public int getScaledEnergy(int scale) {
        if (this.energyStorage.getMaxEnergyStored() <= 0) {
            return 0;
        }
        return scale * this.energyStorage.getEnergyStored() / this.energyStorage.getMaxEnergyStored();
    }

    public int getScaledStarlight(int scale) {
        if (starlightCapacity <= 0) {
            return 0;
        }
        return scale * this.starlight / starlightCapacity;
    }

    public int getScaledStarlightReq(int scale) {
        if (starlightCapacity <= 0 || this.starlight >= this.starlightReq) {
            return 0;
        }
        return scale * this.starlightReq / starlightCapacity - this.getScaledStarlight(scale);
    }

    public int getScaledProgress(int scale) {
        if (this.progress <= 0 || this.progressReq <= 0) {
            return 0;
        }
        return scale * this.progress / this.progressReq;
    }

    public Container createMenu(int windowId, PlayerInventory playerInventory, PlayerEntity player) {
        this.syncTile(false);
        return new DiscoveryCrafterContainer(windowId, playerInventory, this);
    }
}

