/*
 * Decompiled with CFR 0.152.
 */
package thelm.packagedastral.tile;

import hellfirepvp.astralsorcery.client.effect.EntityVisualFX;
import hellfirepvp.astralsorcery.client.effect.context.base.BatchRenderContext;
import hellfirepvp.astralsorcery.client.effect.function.VFXAlphaFunction;
import hellfirepvp.astralsorcery.client.effect.function.VFXColorFunction;
import hellfirepvp.astralsorcery.client.effect.function.VFXMotionController;
import hellfirepvp.astralsorcery.client.effect.handler.EffectHelper;
import hellfirepvp.astralsorcery.client.effect.vfx.FXFacingParticle;
import hellfirepvp.astralsorcery.client.lib.EffectTemplatesAS;
import hellfirepvp.astralsorcery.common.constellation.world.DayTimeHelper;
import hellfirepvp.astralsorcery.common.structure.types.StructureType;
import hellfirepvp.astralsorcery.common.tile.altar.AltarCollectionCategory;
import hellfirepvp.astralsorcery.common.tile.base.TileRequiresMultiblock;
import hellfirepvp.astralsorcery.common.util.MiscUtils;
import hellfirepvp.astralsorcery.common.util.data.Vector3;
import hellfirepvp.astralsorcery.common.util.log.LogCategory;
import hellfirepvp.observerlib.api.ChangeSubscriber;
import hellfirepvp.observerlib.common.change.ChangeObserverStructure;
import java.util.List;
import java.util.Objects;
import java.util.Random;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.ItemEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.inventory.container.Container;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.tileentity.ITickableTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.vector.Vector3i;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.fml.ModList;
import thelm.packagedastral.block.MarkedRelayBlock;
import thelm.packagedastral.integration.appeng.tile.AEMarkedRelayTile;
import thelm.packagedastral.inventory.MarkedRelayItemHandler;
import thelm.packagedastral.structure.MarkedRelayPatternStructure;
import thelm.packagedastral.tile.IAltarCrafter;
import thelm.packagedauto.tile.BaseTile;
import thelm.packagedauto.util.MiscHelper;

public class MarkedRelayTile
extends BaseTile
implements ITickableTileEntity,
TileRequiresMultiblock {
    public static final TileEntityType<MarkedRelayTile> TYPE_INSTANCE = (TileEntityType)TileEntityType.Builder.func_223042_a((Supplier)MiscHelper.INSTANCE.conditionalSupplier(() -> ModList.get().isLoaded("appliedenergistics2"), () -> AEMarkedRelayTile::new, () -> MarkedRelayTile::new), (Block[])new Block[]{MarkedRelayBlock.INSTANCE}).func_206865_a(null).setRegistryName("packagedastral:marked_relay");
    public static final Random RANDOM = new Random();
    public boolean firstTick = true;
    public boolean doesSeeSky = false;
    public ChangeSubscriber<ChangeObserverStructure> structureMatch = null;
    public boolean structureValid = false;
    public BlockPos altarPos = null;
    public double nearestRelayDist = Double.POSITIVE_INFINITY;
    public float proximityMultiplier = 1.0f;

    public MarkedRelayTile() {
        super(TYPE_INSTANCE);
        this.setItemHandler(new MarkedRelayItemHandler(this));
    }

    protected ITextComponent getDefaultName() {
        return new TranslationTextComponent("block.packagedastral.marked_relay");
    }

    public void func_73660_a() {
        if (this.firstTick) {
            this.firstTick = false;
            if (!this.field_145850_b.field_72995_K) {
                this.updateProximity();
            }
        }
        if (this.field_145850_b.func_82737_E() % 16L == 0L) {
            this.doesSeeSky = MiscUtils.canSeeSky((World)this.field_145850_b, (BlockPos)this.field_174879_c.func_177984_a(), (boolean)true, (boolean)this.doesSeeSky);
        }
        if (!this.field_145850_b.field_72995_K) {
            this.matchStructure();
            if (this.altarPos != null && this.field_145850_b.func_195588_v(this.altarPos)) {
                TileEntity tile = this.field_145850_b.func_175625_s(this.altarPos);
                if (tile instanceof IAltarCrafter) {
                    this.provideStarlight((IAltarCrafter)tile);
                } else {
                    this.updateAltarPos();
                }
            }
        } else {
            this.clientTick();
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    protected void clientTick() {
        if (this.structureValid) {
            Vector3 pos;
            if (RANDOM.nextBoolean()) {
                pos = new Vector3((Vector3i)this.field_174879_c).add(0.5, 0.0, 0.5);
                Vector3 offset = new Vector3(0, 0, 0);
                MiscUtils.applyRandomOffset((Vector3)offset, (Random)RANDOM, (float)1.25f);
                pos.add(offset.getX(), 0.0, offset.getZ());
                EntityVisualFX vfx = (EntityVisualFX)((FXFacingParticle)EffectHelper.of((BatchRenderContext)EffectTemplatesAS.GENERIC_PARTICLE).spawn(pos)).alpha(VFXAlphaFunction.FADE_OUT).setScaleMultiplier(0.15f + RANDOM.nextFloat() * 0.1f).setGravityStrength(-0.001f).setMaxAge(30 + RANDOM.nextInt(20));
                if (RANDOM.nextBoolean()) {
                    vfx.color(VFXColorFunction.WHITE);
                }
            }
            if (this.altarPos != null && this.doesSeeSky) {
                pos = new Vector3((Vector3i)this.field_174879_c).add(0.5, 0.35, 0.5);
                Vector3 target = new Vector3((Vector3i)this.altarPos).add(0.5, 0.5, 0.5);
                int maxAge = 30;
                maxAge = (int)((double)maxAge * Math.max(pos.distance(target) / 3.0, 1.0));
                EntityVisualFX vfx = (EntityVisualFX)((FXFacingParticle)EffectHelper.of((BatchRenderContext)EffectTemplatesAS.GENERIC_PARTICLE).spawn(pos)).alpha(VFXAlphaFunction.proximity(() -> ((Vector3)target).clone(), (float)2.0f).andThen(VFXAlphaFunction.FADE_OUT)).motion((VFXMotionController)VFXMotionController.target(() -> ((Vector3)target).clone(), (float)0.08f)).setMotion(Vector3.random().normalize().multiply(0.1f + RANDOM.nextFloat() * 0.05f)).setScaleMultiplier(0.15f + RANDOM.nextFloat() * 0.05f).setMaxAge(maxAge);
                if (RANDOM.nextBoolean()) {
                    vfx.color(VFXColorFunction.WHITE);
                }
            }
        }
    }

    public StructureType getRequiredStructureType() {
        return MarkedRelayPatternStructure.TYPE_INSTANCE;
    }

    protected void provideStarlight(IAltarCrafter altar) {
        if (this.doesSeeSky) {
            float heightAmount = MathHelper.func_76131_a((float)((float)Math.pow((float)this.field_174879_c.func_177956_o() / 7.0f, 1.5) / 60.0f), (float)0.0f, (float)1.0f);
            heightAmount = 0.7f + heightAmount * 0.3f;
            heightAmount *= DayTimeHelper.getCurrentDaytimeDistribution((World)this.field_145850_b);
            if ((heightAmount *= this.proximityMultiplier) > 1.0E-4f) {
                altar.collectStarlight(heightAmount * 45.0f, AltarCollectionCategory.RELAY);
            }
        }
    }

    protected void matchStructure() {
        boolean matches;
        if (this.structureMatch == null) {
            this.structureMatch = this.getRequiredStructureType().observe(this.field_145850_b, this.field_174879_c);
        }
        boolean bl = matches = this.getItemHandler().getStackInSlot(0).func_190926_b() && this.structureMatch.isValid(this.field_145850_b);
        if (matches != this.structureValid) {
            LogCategory.STRUCTURE_MATCH.info(() -> "Structure match updated: " + ((Object)((Object)this)).getClass().getName() + " at " + this.field_174879_c + " (" + this.structureValid + " -> " + matches + ")");
            this.structureValid = matches;
            this.updateAltarPos();
            if (this.structureValid) {
                this.updateProximity();
            } else {
                MarkedRelayTile.updateNearbyProximity(this.field_145850_b, this.field_174879_c);
            }
            this.syncTile(false);
            this.func_70296_d();
        }
    }

    protected void updateProximity() {
        if (this.field_145850_b.field_72995_K) {
            return;
        }
        this.setNearestRelayDist(Double.POSITIVE_INFINITY);
        MarkedRelayTile.getNearbyRelays(this.field_145850_b, this.field_174879_c, 8).forEach(relay -> {
            double dist = this.field_174879_c.func_177951_i((Vector3i)relay.func_174877_v());
            if (dist < relay.nearestRelayDist) {
                relay.setNearestRelayDist(dist);
            }
            if (dist < this.nearestRelayDist) {
                this.setNearestRelayDist(dist);
            }
        });
    }

    protected void updateAltarPos() {
        if (this.field_145850_b.field_72995_K) {
            return;
        }
        this.altarPos = null;
        if (this.structureValid) {
            List<BlockPos> altars = MarkedRelayTile.getNearbyAltars(this.field_145850_b, this.field_174879_c);
            BlockPos nearestAltar = null;
            double nearestDist = Double.POSITIVE_INFINITY;
            for (BlockPos altar : altars) {
                double dist = altar.func_177951_i((Vector3i)this.field_174879_c);
                if (nearestAltar != null && !(dist < nearestDist)) continue;
                nearestAltar = altar;
                nearestDist = dist;
            }
            this.altarPos = nearestAltar;
        }
        this.syncTile(false);
        this.func_70296_d();
    }

    protected void setNearestRelayDist(double dist) {
        this.nearestRelayDist = dist;
        this.proximityMultiplier = MathHelper.func_76131_a((float)((float)Math.sqrt(dist) / 8.0f), (float)0.0f, (float)1.0f);
        this.func_70296_d();
    }

    public static void updateNearbyProximity(World world, BlockPos pos) {
        MarkedRelayTile.getNearbyRelays(world, pos, 8).forEach(MarkedRelayTile::updateProximity);
    }

    public static void updateNearbyAltarPos(World world, BlockPos pos) {
        MarkedRelayTile.getNearbyRelays(world, pos, 16).forEach(MarkedRelayTile::updateAltarPos);
    }

    public static List<MarkedRelayTile> getNearbyRelays(World world, BlockPos pos, int range) {
        return BlockPos.func_218281_b((BlockPos)pos.func_177982_a(-range, -range, -range), (BlockPos)pos.func_177982_a(range, range, range)).map(checkPos -> {
            TileEntity tile;
            if (!checkPos.equals((Object)pos) && checkPos.func_218141_a((Vector3i)pos, (double)range) && world.func_195588_v(checkPos) && (tile = world.func_175625_s(checkPos)) instanceof MarkedRelayTile) {
                MarkedRelayTile relay = (MarkedRelayTile)tile;
                if (relay.structureValid) {
                    return relay;
                }
            }
            return null;
        }).filter(Objects::nonNull).collect(Collectors.toList());
    }

    public static List<BlockPos> getNearbyAltars(World world, BlockPos pos) {
        return BlockPos.func_218281_b((BlockPos)pos.func_177982_a(-16, -16, -16), (BlockPos)pos.func_177982_a(16, 16, 16)).map(checkPos -> {
            if (!checkPos.equals((Object)pos) && checkPos.func_218141_a((Vector3i)pos, 16.0) && world.func_195588_v(checkPos) && world.func_175625_s(checkPos) instanceof IAltarCrafter) {
                return checkPos.func_185334_h();
            }
            return null;
        }).filter(Objects::nonNull).collect(Collectors.toList());
    }

    public void ejectItem() {
        ItemStack stack = this.itemHandler.getStackInSlot(0);
        this.itemHandler.setStackInSlot(0, ItemStack.field_190927_a);
        if (!stack.func_190926_b()) {
            double dx = (double)(this.field_145850_b.field_73012_v.nextFloat() / 2.0f) + 0.25;
            double dy = (double)(this.field_145850_b.field_73012_v.nextFloat() / 2.0f) + 0.25;
            double dz = (double)(this.field_145850_b.field_73012_v.nextFloat() / 2.0f) + 0.25;
            ItemEntity itemEntity = new ItemEntity(this.field_145850_b, (double)this.field_174879_c.func_177958_n() + dx, (double)this.field_174879_c.func_177956_o() + dy, (double)this.field_174879_c.func_177952_p() + dz, stack);
            itemEntity.func_174869_p();
            this.field_145850_b.func_217376_c((Entity)itemEntity);
        }
    }

    public int getComparatorSignal() {
        return this.itemHandler.getStackInSlot(0).func_190926_b() ? 0 : 15;
    }

    public void func_230337_a_(BlockState blockState, CompoundNBT nbt) {
        super.func_230337_a_(blockState, nbt);
        this.setNearestRelayDist(nbt.func_74769_h("NearestRelayDist"));
    }

    public CompoundNBT func_189515_b(CompoundNBT nbt) {
        super.func_189515_b(nbt);
        nbt.func_74780_a("NearestRelayDist", this.nearestRelayDist);
        return nbt;
    }

    public void readSync(CompoundNBT nbt) {
        super.readSync(nbt);
        this.itemHandler.read(nbt);
        this.structureValid = nbt.func_74767_n("MultiblockValid");
        this.altarPos = null;
        if (nbt.func_74764_b("AltarPos")) {
            int[] posArray = nbt.func_74759_k("AltarPos");
            this.altarPos = new BlockPos(posArray[0], posArray[1], posArray[2]);
        }
    }

    public CompoundNBT writeSync(CompoundNBT nbt) {
        super.writeSync(nbt);
        this.itemHandler.write(nbt);
        nbt.func_74757_a("MultiblockValid", this.structureValid);
        if (this.altarPos != null) {
            nbt.func_74783_a("AltarPos", new int[]{this.altarPos.func_177958_n(), this.altarPos.func_177956_o(), this.altarPos.func_177952_p()});
        }
        return nbt;
    }

    public Container createMenu(int windowId, PlayerInventory playerInventory, PlayerEntity player) {
        return null;
    }
}

