/*
 * Decompiled with CFR 0.152.
 */
package com.lightre.kernel;

import com.lightre.kernel.commands.base.CommandManager;
import com.lightre.kernel.commands.impl.AdminChat;
import com.lightre.kernel.commands.impl.Broadcast;
import com.lightre.kernel.commands.impl.ClearChat;
import com.lightre.kernel.commands.impl.EnderChest;
import com.lightre.kernel.commands.impl.Equsee;
import com.lightre.kernel.commands.impl.Feed;
import com.lightre.kernel.commands.impl.Fly;
import com.lightre.kernel.commands.impl.Freeze;
import com.lightre.kernel.commands.impl.God;
import com.lightre.kernel.commands.impl.Hat;
import com.lightre.kernel.commands.impl.Heal;
import com.lightre.kernel.commands.impl.Invsee;
import com.lightre.kernel.commands.impl.KernelCommand;
import com.lightre.kernel.commands.impl.Repair;
import com.lightre.kernel.commands.impl.Speed;
import com.lightre.kernel.commands.impl.Vanish;
import com.lightre.kernel.commands.impl.Whois;
import com.lightre.kernel.listeners.GodModeListener;
import com.lightre.kernel.listeners.PlayerFreezeListener;
import com.lightre.kernel.listeners.PlayerVanishListener;
import com.lightre.kernel.managers.FreezeManager;
import com.lightre.kernel.managers.GodManager;
import com.lightre.kernel.managers.VanishManager;
import java.util.stream.Stream;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;

public final class Kernel
extends JavaPlugin {
    private CommandManager commandManager;
    private VanishManager vanishManager;
    private GodManager godManager;
    private FreezeManager freezeManager;

    public void onEnable() {
        this.loadManagers();
        this.loadCommands();
        this.loadListeners();
        this.getLogger().info("Kernel has been enabled successfully.");
    }

    public void onDisable() {
        this.getLogger().info("Kernel has been disabled.");
    }

    private void loadManagers() {
        this.commandManager = new CommandManager(this);
        this.vanishManager = new VanishManager(this);
        this.godManager = new GodManager();
        this.freezeManager = new FreezeManager();
    }

    private void loadCommands() {
        Stream.of(new KernelCommand(this), new Heal(), new Feed(), new Fly(), new Vanish(this), new God(this), new Hat(), new Whois(this), new Broadcast(), new AdminChat(), new Freeze(this), new ClearChat(), new Speed(), new Repair(), new EnderChest(), new Invsee(), new Equsee()).forEach(this.commandManager::registerCommand);
    }

    private void loadListeners() {
        Stream.of(new PlayerVanishListener(this), new PlayerFreezeListener(this), new GodModeListener(this)).forEach(listener -> this.getServer().getPluginManager().registerEvents(listener, (Plugin)this));
    }

    public VanishManager getVanishManager() {
        return this.vanishManager;
    }

    public FreezeManager getFreezeManager() {
        return this.freezeManager;
    }

    public GodManager getGodManager() {
        return this.godManager;
    }
}

