/*
 * Decompiled with CFR 0.152.
 */
package com.lightre.kernel.commands.base;

import com.lightre.kernel.Kernel;
import com.lightre.kernel.commands.base.ICommand;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.bukkit.command.Command;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;
import org.bukkit.command.PluginCommand;
import org.bukkit.command.TabCompleter;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CommandManager
implements CommandExecutor,
TabCompleter {
    private final Kernel plugin;
    private final Map<String, ICommand> commands = new HashMap<String, ICommand>();

    public CommandManager(Kernel plugin) {
        this.plugin = plugin;
    }

    public void registerCommand(ICommand command) {
        PluginCommand pluginCommand = this.plugin.getCommand(command.getName());
        if (pluginCommand == null) {
            this.plugin.getLogger().severe("Command '" + command.getName() + "' could not be found in plugin.yml!");
            return;
        }
        pluginCommand.setExecutor((CommandExecutor)this);
        pluginCommand.setTabCompleter((TabCompleter)this);
        this.commands.put(command.getName().toLowerCase(), command);
    }

    public boolean onCommand(@NotNull CommandSender sender, @NotNull Command command, @NotNull String label, @NotNull String[] args) {
        ICommand cmd = this.commands.get(command.getName().toLowerCase());
        if (cmd == null) {
            return false;
        }
        if (cmd.getPermission() != null && !sender.hasPermission(cmd.getPermission())) {
            sender.sendMessage("\u00a7cYou do not have permission to execute this command.");
            return true;
        }
        return cmd.execute(sender, args);
    }

    @Nullable
    public List<String> onTabComplete(@NotNull CommandSender sender, @NotNull Command command, @NotNull String alias, @NotNull String[] args) {
        ICommand cmd = this.commands.get(command.getName().toLowerCase());
        if (cmd != null) {
            return cmd.onTabComplete(sender, command, alias, args);
        }
        return Collections.emptyList();
    }
}

