/*
 * Decompiled with CFR 0.152.
 */
package com.lightre.kernel.managers;

import com.lightre.kernel.Kernel;
import com.lightre.kernel.utils.ChatUtils;
import java.util.HashSet;
import java.util.Set;
import java.util.UUID;
import org.bukkit.Bukkit;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;

public class VanishManager {
    private final Kernel plugin;
    private final Set<UUID> vanishedPlayers = new HashSet<UUID>();
    private final String bypassPermission = "kernel.admin.vanish.bypass";

    public VanishManager(Kernel plugin) {
        this.plugin = plugin;
    }

    public boolean isVanished(Player player) {
        return this.vanishedPlayers.contains(player.getUniqueId());
    }

    public void setVanished(Player player, boolean vanish) {
        if (vanish) {
            this.vanishedPlayers.add(player.getUniqueId());
            this.hidePlayer(player);
        } else {
            this.vanishedPlayers.remove(player.getUniqueId());
            this.showPlayer(player);
        }
        this.updatePlayerListName(player);
    }

    public void hidePlayer(Player playerToHide) {
        for (Player observer : Bukkit.getOnlinePlayers()) {
            if (observer.hasPermission("kernel.admin.vanish.bypass") || observer.equals((Object)playerToHide)) continue;
            observer.hidePlayer((Plugin)this.plugin, playerToHide);
        }
    }

    public void showPlayer(Player playerToShow) {
        for (Player observer : Bukkit.getOnlinePlayers()) {
            observer.showPlayer((Plugin)this.plugin, playerToShow);
        }
    }

    public void updateVanishedForPlayer(Player observer) {
        for (UUID vanishedUUID : this.vanishedPlayers) {
            Player vanishedPlayer = Bukkit.getPlayer((UUID)vanishedUUID);
            if (vanishedPlayer == null) continue;
            if (observer.hasPermission("kernel.admin.vanish.bypass") || observer.equals((Object)vanishedPlayer)) {
                observer.showPlayer((Plugin)this.plugin, vanishedPlayer);
                continue;
            }
            observer.hidePlayer((Plugin)this.plugin, vanishedPlayer);
        }
    }

    private void updatePlayerListName(Player player) {
        if (this.isVanished(player)) {
            String prefix = ChatUtils.colorize("&7[Vanish] &r");
            player.setPlayerListName(prefix + player.getName());
        } else {
            player.setPlayerListName(null);
        }
    }

    public Set<UUID> getVanishedPlayers() {
        return this.vanishedPlayers;
    }
}

