/*
 * Decompiled with CFR 0.152.
 */
package com.lightre.kernel.commands.impl;

import com.lightre.kernel.Kernel;
import com.lightre.kernel.commands.base.AbstractCommand;
import com.lightre.kernel.utils.ChatUtils;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.bukkit.command.Command;
import org.bukkit.command.CommandSender;
import org.bukkit.plugin.PluginDescriptionFile;
import org.jetbrains.annotations.NotNull;

public class KernelCommand
extends AbstractCommand {
    private final Kernel plugin;

    public KernelCommand(Kernel plugin) {
        this.plugin = plugin;
    }

    @Override
    public boolean execute(CommandSender sender, String[] args) {
        String subCommand;
        if (args.length == 0) {
            this.displayPluginInfo(sender);
            return true;
        }
        return switch (subCommand = args[0].toLowerCase()) {
            case "help" -> this.handleHelpCommand(sender);
            case "reload" -> this.handleReloadCommand(sender);
            default -> {
                ChatUtils.sendMessage(sender, "&cUnknown subcommand. Use &e/kernel help&c for a list of commands.");
                yield true;
            }
        };
    }

    private void displayPluginInfo(CommandSender sender) {
        PluginDescriptionFile desc = this.plugin.getDescription();
        sender.sendMessage(ChatUtils.colorize("&8&m-----------------------------------------------------"));
        sender.sendMessage(ChatUtils.colorize(" &b&l" + desc.getName() + " &e- Version " + desc.getVersion()));
        sender.sendMessage(ChatUtils.colorize(" &7" + desc.getDescription()));
        sender.sendMessage("");
        sender.sendMessage(ChatUtils.colorize(" &fAuthor: &b" + String.join((CharSequence)", ", desc.getAuthors())));
        sender.sendMessage(ChatUtils.colorize("&8&m-----------------------------------------------------"));
    }

    private boolean handleHelpCommand(CommandSender sender) {
        if (!sender.hasPermission(this.getPermission() + ".help")) {
            ChatUtils.sendMessage(sender, "&cYou do not have permission to use this command.");
            return true;
        }
        ChatUtils.sendMessage(sender, "&6&lKernel Commands:");
        this.plugin.getDescription().getCommands().forEach((cmd, data) -> {
            String description = data.getOrDefault("description", "No description available.");
            sender.sendMessage(ChatUtils.colorize(" &e/" + cmd + " &7- " + description));
        });
        return true;
    }

    private boolean handleReloadCommand(CommandSender sender) {
        if (!sender.hasPermission(this.getPermission() + ".reload")) {
            ChatUtils.sendMessage(sender, "&cYou do not have permission to use this command.");
            return true;
        }
        ChatUtils.sendMessage(sender, "&aKernel configuration reloaded (Placeholder).");
        return true;
    }

    @Override
    public String getName() {
        return "kernel";
    }

    @Override
    public String getPermission() {
        return "kernel.command.main";
    }

    @Override
    public List<String> onTabComplete(@NotNull CommandSender sender, @NotNull Command command, @NotNull String alias, @NotNull String[] args) {
        if (args.length == 1) {
            return Stream.of("help", "reload").filter(s -> s.startsWith(args[0].toLowerCase())).collect(Collectors.toList());
        }
        return List.of();
    }
}

