/*
 * Decompiled with CFR 0.152.
 */
package com.lightre.kernel.listeners;

import com.lightre.kernel.Kernel;
import com.lightre.kernel.utils.ChatUtils;
import java.util.HashSet;
import java.util.Set;
import java.util.UUID;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.entity.EntityDamageEvent;
import org.bukkit.event.player.AsyncPlayerChatEvent;
import org.bukkit.event.player.PlayerMoveEvent;
import org.bukkit.event.player.PlayerQuitEvent;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitRunnable;

public class PlayerFreezeListener
implements Listener {
    private final Kernel plugin;
    private final Set<UUID> messageCooldown = new HashSet<UUID>();

    public PlayerFreezeListener(Kernel plugin) {
        this.plugin = plugin;
    }

    @EventHandler
    public void onPlayerMove(PlayerMoveEvent event) {
        final Player player = event.getPlayer();
        if (this.plugin.getFreezeManager().isFrozen(player)) {
            event.setCancelled(true);
            if (this.messageCooldown.contains(player.getUniqueId())) {
                return;
            }
            ChatUtils.sendMessage((CommandSender)player, "&cYou are frozen and cannot move.");
            this.messageCooldown.add(player.getUniqueId());
            new BukkitRunnable(){

                public void run() {
                    PlayerFreezeListener.this.messageCooldown.remove(player.getUniqueId());
                }
            }.runTaskLater((Plugin)this.plugin, 40L);
        }
    }

    @EventHandler
    public void onPlayerChat(AsyncPlayerChatEvent event) {
        final Player player = event.getPlayer();
        if (this.plugin.getFreezeManager().isFrozen(player)) {
            event.setCancelled(true);
            if (this.messageCooldown.contains(player.getUniqueId())) {
                return;
            }
            ChatUtils.sendMessage((CommandSender)player, "&cYou are frozen and cannot chat.");
            this.messageCooldown.add(player.getUniqueId());
            new BukkitRunnable(){

                public void run() {
                    PlayerFreezeListener.this.messageCooldown.remove(player.getUniqueId());
                }
            }.runTaskLater((Plugin)this.plugin, 40L);
        }
    }

    @EventHandler
    public void onPlayerDamage(EntityDamageEvent event) {
        Entity entity = event.getEntity();
        if (entity instanceof Player) {
            Player player = (Player)entity;
            if (this.plugin.getFreezeManager().isFrozen(player)) {
                event.setCancelled(true);
            }
        }
    }

    @EventHandler
    public void onPlayerQuit(PlayerQuitEvent event) {
        Player player = event.getPlayer();
        if (this.plugin.getFreezeManager().isFrozen(player)) {
            this.plugin.getFreezeManager().toggleFreeze(player);
        }
        this.messageCooldown.remove(player.getUniqueId());
    }
}

