/*
 * Decompiled with CFR 0.152.
 */
package net.astralya.hexalia.block.custom;

import com.mojang.serialization.MapCodec;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.astralya.hexalia.block.entity.custom.ShelfBlockEntity;
import net.astralya.hexalia.util.ModTags;
import net.minecraft.class_124;
import net.minecraft.class_1264;
import net.minecraft.class_1268;
import net.minecraft.class_1297;
import net.minecraft.class_1657;
import net.minecraft.class_1750;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1836;
import net.minecraft.class_1922;
import net.minecraft.class_1936;
import net.minecraft.class_1937;
import net.minecraft.class_2237;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_243;
import net.minecraft.class_2464;
import net.minecraft.class_2561;
import net.minecraft.class_2586;
import net.minecraft.class_259;
import net.minecraft.class_265;
import net.minecraft.class_2680;
import net.minecraft.class_2689;
import net.minecraft.class_2741;
import net.minecraft.class_2753;
import net.minecraft.class_2769;
import net.minecraft.class_3417;
import net.minecraft.class_3419;
import net.minecraft.class_3726;
import net.minecraft.class_3965;
import net.minecraft.class_4538;
import net.minecraft.class_4970;
import net.minecraft.class_5712;
import net.minecraft.class_6880;
import net.minecraft.class_9062;
import org.jetbrains.annotations.Nullable;

public class ShelfBlock
extends class_2237 {
    public static final MapCodec<ShelfBlock> CODEC = ShelfBlock.method_54094(ShelfBlock::new);
    public static final class_2753 FACING = class_2741.field_12481;
    private static final Map<class_2350, class_265> SHAPES = ShelfBlock.createShapes();

    public ShelfBlock(class_4970.class_2251 settings) {
        super(settings);
        this.method_9590((class_2680)((class_2680)this.method_9595().method_11664()).method_11657((class_2769)FACING, (Comparable)class_2350.field_11043));
    }

    protected MapCodec<? extends class_2237> method_53969() {
        return CODEC;
    }

    protected void method_9515(class_2689.class_2690<class_2248, class_2680> builder) {
        builder.method_11667(new class_2769[]{FACING});
    }

    public class_265 method_9530(class_2680 state, class_1922 world, class_2338 pos, class_3726 context) {
        return SHAPES.get(state.method_11654((class_2769)FACING));
    }

    public class_2464 method_9604(class_2680 state) {
        return class_2464.field_11458;
    }

    @Nullable
    public class_2680 method_9605(class_1750 ctx) {
        class_2350 clickedFace = ctx.method_8038();
        if (clickedFace.method_10166() == class_2350.class_2351.field_11052) {
            return (class_2680)this.method_9564().method_11657((class_2769)FACING, (Comparable)ctx.method_8042().method_10153());
        }
        return (class_2680)this.method_9564().method_11657((class_2769)FACING, (Comparable)clickedFace);
    }

    public boolean method_9558(class_2680 state, class_4538 world, class_2338 pos) {
        class_2350 direction = ((class_2350)state.method_11654((class_2769)FACING)).method_10153();
        class_2338 supportPos = pos.method_10093(direction);
        class_2680 supportState = world.method_8320(supportPos);
        return supportState.method_26206((class_1922)world, supportPos, direction.method_10153());
    }

    public class_2680 method_9559(class_2680 state, class_2350 direction, class_2680 neighborState, class_1936 world, class_2338 pos, class_2338 neighborPos) {
        if (!state.method_26184((class_4538)world, pos)) {
            return class_2246.field_10124.method_9564();
        }
        return super.method_9559(state, direction, neighborState, world, pos, neighborPos);
    }

    protected class_9062 method_55765(class_1799 stack, class_2680 state, class_1937 world, class_2338 pos, class_1657 player, class_1268 hand, class_3965 hit) {
        int row;
        double relativeZ;
        double relativeX;
        class_2586 be = world.method_8321(pos);
        if (!(be instanceof ShelfBlockEntity)) {
            return class_9062.field_47731;
        }
        ShelfBlockEntity shelf = (ShelfBlockEntity)be;
        class_243 hitPos = hit.method_17784();
        class_2350 facing = (class_2350)state.method_11654((class_2769)FACING);
        double x = hitPos.field_1352 - (double)pos.method_10263();
        double y = hitPos.field_1351 - (double)pos.method_10264();
        double z = hitPos.field_1350 - (double)pos.method_10260();
        switch (facing) {
            case field_11043: {
                relativeX = 1.0 - x;
                relativeZ = z;
                break;
            }
            case field_11035: {
                relativeX = x;
                relativeZ = 1.0 - z;
                break;
            }
            case field_11034: {
                relativeX = 1.0 - z;
                relativeZ = 1.0 - x;
                break;
            }
            case field_11039: {
                relativeX = z;
                relativeZ = x;
                break;
            }
            default: {
                return class_9062.field_47731;
            }
        }
        if (relativeZ < 0.5 || relativeZ > 1.0 || y < 0.25 || y > 0.75) {
            return class_9062.field_47731;
        }
        int n = row = relativeZ < 0.75 ? 1 : 0;
        int column = relativeX < 0.33 ? 0 : (relativeX < 0.67 ? 1 : 2);
        int slot = column + row * 3;
        class_1799 heldItem = player.method_5998(hand);
        class_1799 shelfItem = shelf.getItem(slot);
        if (!shelfItem.method_7960()) {
            class_1799 removed = shelf.removeStack(slot);
            world.method_8396(null, pos, class_3417.field_14667, class_3419.field_15245, 1.0f, 1.0f);
            if (!player.method_31548().method_7394(removed)) {
                class_2248.method_9577((class_1937)world, (class_2338)pos, (class_1799)removed);
            }
            world.method_33596((class_1297)player, (class_6880)class_5712.field_28733, pos);
            return class_9062.method_55644((boolean)world.method_8608());
        }
        if (this.isValidItem(heldItem)) {
            class_1799 toPlace;
            class_1799 class_17992 = toPlace = player.method_31549().field_7477 ? heldItem.method_7972() : heldItem.method_7971(1);
            if (!player.method_31549().field_7477) {
                toPlace.method_7939(1);
            }
            shelf.setItem(slot, toPlace);
            world.method_8396(null, pos, class_3417.field_14667, class_3419.field_15245, 1.0f, 1.0f);
            world.method_33596((class_1297)player, (class_6880)class_5712.field_28733, pos);
            return class_9062.method_55644((boolean)world.method_8608());
        }
        return class_9062.field_47731;
    }

    public void method_9536(class_2680 state, class_1937 world, class_2338 pos, class_2680 newState, boolean moved) {
        if (!state.method_27852(newState.method_26204())) {
            class_2586 be = world.method_8321(pos);
            if (be instanceof ShelfBlockEntity) {
                ShelfBlockEntity shelf = (ShelfBlockEntity)be;
                if (!world.field_9236) {
                    for (class_1799 stack : shelf.getItems()) {
                        if (stack.method_7960()) continue;
                        class_1264.method_5449((class_1937)world, (double)pos.method_10263(), (double)pos.method_10264(), (double)pos.method_10260(), (class_1799)stack);
                    }
                    shelf.clearContents();
                }
                world.method_8544(pos);
                world.method_8455(pos, (class_2248)this);
            }
            super.method_9536(state, world, pos, newState, moved);
        }
    }

    public void method_9568(class_1799 stack, class_1792.class_9635 context, List<class_2561> tooltip, class_1836 options) {
        tooltip.add((class_2561)class_2561.method_43471((String)"tooltip.hexalia.shelf").method_27692(class_124.field_1080));
    }

    @Nullable
    public class_2586 method_10123(class_2338 pos, class_2680 state) {
        return new ShelfBlockEntity(pos, state);
    }

    private static class_265 createShape() {
        class_265 shape = class_259.method_1073();
        shape = class_259.method_1084((class_265)shape, (class_265)class_259.method_1081((double)0.0, (double)0.25, (double)0.5, (double)1.0, (double)0.3125, (double)1.0));
        shape = class_259.method_1084((class_265)shape, (class_265)class_259.method_1081((double)0.0, (double)0.125, (double)0.875, (double)1.0, (double)0.25, (double)1.0));
        return shape;
    }

    private static Map<class_2350, class_265> createShapes() {
        HashMap<class_2350, class_265> shapes = new HashMap<class_2350, class_265>();
        class_265 baseShape = ShelfBlock.createShape();
        for (class_2350 direction : class_2350.class_2353.field_11062) {
            shapes.put(direction, ShelfBlock.rotateShape(direction, baseShape));
        }
        return shapes;
    }

    private static class_265 rotateShape(class_2350 to, class_265 shape) {
        class_265[] buffer = new class_265[]{shape, class_259.method_1073()};
        int times = (to.method_10161() - class_2350.field_11043.method_10161() + 4) % 4;
        for (int i = 0; i < times; ++i) {
            buffer[0].method_1089((minX, minY, minZ, maxX, maxY, maxZ) -> {
                buffer[1] = class_259.method_1084((class_265)buffer[1], (class_265)class_259.method_1081((double)(1.0 - maxZ), (double)minY, (double)minX, (double)(1.0 - minZ), (double)maxY, (double)maxX));
            });
            buffer[0] = buffer[1];
            buffer[1] = class_259.method_1073();
        }
        return buffer[0];
    }

    private boolean isValidItem(class_1799 stack) {
        return !stack.method_7960() && (stack.method_31573(ModTags.Items.BREWS) || stack.method_31574(class_1802.field_8574) || stack.method_31574(class_1802.field_8150) || stack.method_31574(class_1802.field_8436));
    }
}

