/*
 * Decompiled with CFR 0.152.
 */
package net.astralya.hexalia.block.entity.custom;

import net.astralya.hexalia.block.custom.CenserBlock;
import net.astralya.hexalia.block.custom.censer.CenserEffectHandler;
import net.astralya.hexalia.block.custom.censer.HerbCombination;
import net.astralya.hexalia.block.entity.ModBlockEntityTypes;
import net.astralya.hexalia.block.entity.custom.SyncBlockEntity;
import net.minecraft.class_1262;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2371;
import net.minecraft.class_2487;
import net.minecraft.class_2520;
import net.minecraft.class_2586;
import net.minecraft.class_2596;
import net.minecraft.class_2602;
import net.minecraft.class_2622;
import net.minecraft.class_2680;
import net.minecraft.class_2769;
import net.minecraft.class_2960;
import net.minecraft.class_3218;
import net.minecraft.class_3417;
import net.minecraft.class_3419;
import net.minecraft.class_7225;
import net.minecraft.class_7923;

public class CenserBlockEntity
extends SyncBlockEntity {
    private static final int SIZE = 2;
    private static final int EFFECT_INTERVAL = 40;
    private final class_2371<class_1799> items = class_2371.method_10213((int)2, (Object)class_1799.field_8037);
    private HerbCombination activeCombination = null;
    private int burnTime = 0;
    private boolean effectActive = false;

    public CenserBlockEntity(class_2338 pos, class_2680 state) {
        super(ModBlockEntityTypes.CENSER, pos, state);
    }

    public void tick(class_1937 world, class_2338 pos, class_2680 state) {
        if (!world.field_9236 && this.activeCombination != null && this.burnTime > 0 && !this.effectActive) {
            CenserEffectHandler.registerActiveEffect(world, pos, this.activeCombination, this.burnTime);
            this.effectActive = true;
        }
        if (!((Boolean)state.method_11654((class_2769)CenserBlock.LIT)).booleanValue()) {
            return;
        }
        if (this.burnTime > 0) {
            --this.burnTime;
            if (this.burnTime % 40 == 0 && this.activeCombination != null) {
                CenserEffectHandler.applyEffects(world, pos, this.activeCombination);
                if (!this.effectActive) {
                    CenserEffectHandler.registerActiveEffect(world, pos, this.activeCombination, this.burnTime);
                    this.effectActive = true;
                }
            }
            if (this.burnTime <= 0) {
                this.extinguish(world, pos, state);
            }
            this.method_5431();
        }
    }

    protected void method_11014(class_2487 nbt, class_7225.class_7874 lookup) {
        class_2487 comboTag;
        super.method_11014(nbt, lookup);
        class_1262.method_5429((class_2487)nbt, this.items, (class_7225.class_7874)lookup);
        for (class_1799 stack : this.items) {
            if (stack.method_7960() || stack.method_7947() > 0 && stack.method_7947() <= stack.method_7914()) continue;
            stack.method_7939(1);
        }
        if (nbt.method_10573("ActiveCombination", 10) && (comboTag = nbt.method_10562("ActiveCombination")).method_10573("Item1", 8) && comboTag.method_10573("Item2", 8)) {
            class_2960 id1 = class_2960.method_60654((String)comboTag.method_10558("Item1"));
            class_2960 id2 = class_2960.method_60654((String)comboTag.method_10558("Item2"));
            class_1792 item1 = (class_1792)class_7923.field_41178.method_10223(id1);
            class_1792 item2 = (class_1792)class_7923.field_41178.method_10223(id2);
            this.activeCombination = new HerbCombination(item1, item2);
        }
        this.burnTime = nbt.method_10550("BurnTime");
        this.effectActive = nbt.method_10577("EffectActive");
    }

    protected void method_11007(class_2487 nbt, class_7225.class_7874 lookup) {
        super.method_11007(nbt, lookup);
        class_1262.method_5426((class_2487)nbt, this.items, (class_7225.class_7874)lookup);
        nbt.method_10569("BurnTime", this.burnTime);
        nbt.method_10556("EffectActive", this.effectActive);
        if (this.activeCombination != null) {
            class_2487 comboTag = new class_2487();
            comboTag.method_10582("Item1", class_7923.field_41178.method_10221((Object)this.activeCombination.item1()).toString());
            comboTag.method_10582("Item2", class_7923.field_41178.method_10221((Object)this.activeCombination.item2()).toString());
            nbt.method_10566("ActiveCombination", (class_2520)comboTag);
        }
    }

    @Override
    public class_2596<class_2602> method_38235() {
        return class_2622.method_38585((class_2586)this);
    }

    @Override
    public void inventoryChanged() {
        if (this.field_11863 == null) {
            return;
        }
        this.method_5431();
        if (!this.field_11863.field_9236) {
            this.field_11863.method_8413(this.field_11867, this.method_11010(), this.method_11010(), 3);
            ((class_3218)this.field_11863).method_14178().method_14128(this.field_11867);
        }
    }

    public int getBurnTime() {
        return this.burnTime;
    }

    public void setBurnTime(int time) {
        this.burnTime = time;
        this.inventoryChanged();
    }

    public class_1799 getItem(int slot) {
        if (slot < 0 || slot >= 2) {
            return class_1799.field_8037;
        }
        return (class_1799)this.items.get(slot);
    }

    public void setItem(int slot, class_1799 stack) {
        if (slot < 0 || slot >= 2) {
            return;
        }
        this.items.set(slot, (Object)stack);
        this.inventoryChanged();
    }

    public void clearItems() {
        for (int i = 0; i < 2; ++i) {
            this.items.set(i, (Object)class_1799.field_8037);
        }
        this.inventoryChanged();
    }

    public class_2371<class_1799> getItems() {
        return this.items;
    }

    public HerbCombination getActiveCombination() {
        return this.activeCombination;
    }

    public void setActiveCombination(HerbCombination combo) {
        this.activeCombination = combo;
        this.inventoryChanged();
    }

    public void reactivateEffect() {
        if (this.activeCombination != null && this.burnTime > 0 && !this.effectActive && this.field_11863 != null) {
            CenserEffectHandler.registerActiveEffect(this.field_11863, this.field_11867, this.activeCombination, this.burnTime);
            this.effectActive = true;
        }
    }

    public boolean isEmpty() {
        for (class_1799 item : this.items) {
            if (item.method_7960()) continue;
            return false;
        }
        return true;
    }

    public class_1799 removeStack(int slot) {
        if (slot < 0 || slot >= 2) {
            return class_1799.field_8037;
        }
        class_1799 stack = ((class_1799)this.items.get(slot)).method_7972();
        this.items.set(slot, (Object)class_1799.field_8037);
        this.inventoryChanged();
        return stack;
    }

    private void extinguish(class_1937 world, class_2338 pos, class_2680 state) {
        if (this.activeCombination != null) {
            CenserEffectHandler.clearPlayerEffectsInRange(world, pos);
            CenserEffectHandler.removeActiveEffect(pos);
            this.activeCombination = null;
            this.effectActive = false;
        }
        world.method_8652(pos, (class_2680)state.method_11657((class_2769)CenserBlock.LIT, (Comparable)Boolean.valueOf(false)), 3);
        world.method_8396(null, pos, class_3417.field_15102, class_3419.field_15245, 0.5f, 1.0f);
        this.inventoryChanged();
    }
}

