/*
 * Decompiled with CFR 0.152.
 */
package net.astralya.hexalia.recipe;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.List;
import java.util.Objects;
import net.astralya.hexalia.item.ModItems;
import net.astralya.hexalia.recipe.ModRecipes;
import net.astralya.hexalia.recipe.SmallCauldronRecipeInput;
import net.minecraft.class_1799;
import net.minecraft.class_1856;
import net.minecraft.class_1860;
import net.minecraft.class_1865;
import net.minecraft.class_1935;
import net.minecraft.class_1937;
import net.minecraft.class_2371;
import net.minecraft.class_3956;
import net.minecraft.class_7225;
import net.minecraft.class_9129;
import net.minecraft.class_9139;

public class SmallCauldronRecipe
implements class_1860<SmallCauldronRecipeInput> {
    public static final int INPUT_SLOTS = 3;
    private final class_2371<class_1856> ingredients;
    private final class_1799 output;
    private final class_1856 bottleSlot;
    private final float experience;
    private final int brewTime;

    public SmallCauldronRecipe(class_2371<class_1856> ingredients, class_1856 bottleSlot, class_1799 output, float experience, int brewTime) {
        this.ingredients = ingredients;
        this.bottleSlot = bottleSlot;
        this.output = output;
        this.experience = experience;
        this.brewTime = brewTime;
    }

    public class_2371<class_1856> getIngredientList() {
        return this.ingredients;
    }

    public class_1856 getBottleSlot() {
        return this.bottleSlot;
    }

    public class_1799 getOutputStack() {
        return this.output;
    }

    public float getExperience() {
        return this.experience;
    }

    public int getBrewTime() {
        return this.brewTime;
    }

    public boolean matches(SmallCauldronRecipeInput input, class_1937 world) {
        int inputsCount = 0;
        for (int j = 0; j < 3; ++j) {
            if (input.method_59984(j).method_7960()) continue;
            ++inputsCount;
        }
        if (inputsCount != this.ingredients.size()) {
            return false;
        }
        boolean[] used = new boolean[3];
        for (class_1856 ing : this.ingredients) {
            boolean found = false;
            for (int j = 0; j < 3; ++j) {
                if (used[j] || !ing.method_8093(input.method_59984(j))) continue;
                used[j] = true;
                found = true;
                break;
            }
            if (found) continue;
            return false;
        }
        class_1799 bottle = input.method_59984(3);
        return this.bottleSlot.method_8093(bottle);
    }

    public class_1799 craft(SmallCauldronRecipeInput input, class_7225.class_7874 registries) {
        return this.output.method_7972();
    }

    public class_1799 method_8110(class_7225.class_7874 registries) {
        return this.output;
    }

    public boolean method_8113(int width, int height) {
        return width * height >= this.ingredients.size();
    }

    public class_1865<?> method_8119() {
        return ModRecipes.SMALL_CAULDRON_SERIALIZER;
    }

    public class_3956<?> method_17716() {
        return ModRecipes.SMALL_CAULDRON_TYPE;
    }

    public class_1799 method_17447() {
        return new class_1799((class_1935)ModItems.SMALL_CAULDRON);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof SmallCauldronRecipe)) {
            return false;
        }
        SmallCauldronRecipe that = (SmallCauldronRecipe)o;
        return Float.compare(that.getExperience(), this.getExperience()) == 0 && this.getBrewTime() == that.getBrewTime() && Objects.equals(this.method_8112(), that.method_8112()) && this.ingredients.equals(that.ingredients) && this.output.equals(that.output) && this.bottleSlot.equals((Object)that.bottleSlot);
    }

    public int hashCode() {
        int result = this.method_8112().hashCode();
        result = 31 * result + this.ingredients.hashCode();
        result = 31 * result + this.output.hashCode();
        result = 31 * result + this.bottleSlot.hashCode();
        result = 31 * result + (this.getExperience() != 0.0f ? Float.floatToIntBits(this.getExperience()) : 0);
        result = 31 * result + this.getBrewTime();
        return result;
    }

    public static class Serializer
    implements class_1865<SmallCauldronRecipe> {
        private static final MapCodec<SmallCauldronRecipe> JSON_CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)class_1856.field_46096.listOf().fieldOf("ingredients").xmap(Serializer::toDefaulted, list -> list).forGetter(SmallCauldronRecipe::getIngredientList), (App)class_1799.field_24671.fieldOf("result").forGetter(SmallCauldronRecipe::getOutputStack), (App)class_1856.field_46096.fieldOf("bottle_slot").forGetter(SmallCauldronRecipe::getBottleSlot), (App)Codec.FLOAT.optionalFieldOf("experience", (Object)Float.valueOf(0.0f)).forGetter(SmallCauldronRecipe::getExperience), (App)Codec.INT.optionalFieldOf("brewtime", (Object)200).forGetter(SmallCauldronRecipe::getBrewTime)).apply((Applicative)instance, (ings, result, bottle, xp, time) -> new SmallCauldronRecipe((class_2371<class_1856>)ings, (class_1856)bottle, (class_1799)result, xp.floatValue(), (int)time)));
        private static final class_9139<class_9129, SmallCauldronRecipe> NET_CODEC = new class_9139<class_9129, SmallCauldronRecipe>(){

            public void encode(class_9129 buf, SmallCauldronRecipe value) {
                buf.method_10804(value.ingredients.size());
                for (class_1856 ing : value.ingredients) {
                    class_1856.field_48355.encode((Object)buf, (Object)ing);
                }
                class_1799.field_48349.encode((Object)buf, (Object)value.output);
                class_1856.field_48355.encode((Object)buf, (Object)value.bottleSlot);
                buf.method_52941(value.experience);
                buf.method_10804(value.brewTime);
            }

            public SmallCauldronRecipe decode(class_9129 buf) {
                int count = buf.method_10816();
                class_2371 ingreds = class_2371.method_10213((int)count, (Object)class_1856.field_9017);
                for (int i = 0; i < count; ++i) {
                    ingreds.set(i, (Object)((class_1856)class_1856.field_48355.decode((Object)buf)));
                }
                class_1799 out = (class_1799)class_1799.field_48349.decode((Object)buf);
                class_1856 bottle = (class_1856)class_1856.field_48355.decode((Object)buf);
                float xp = buf.readFloat();
                int time = buf.method_10816();
                return new SmallCauldronRecipe((class_2371<class_1856>)ingreds, bottle, out, xp, time);
            }
        };

        private static class_2371<class_1856> toDefaulted(List<class_1856> list) {
            class_2371 dl = class_2371.method_10213((int)list.size(), (Object)class_1856.field_9017);
            for (int i = 0; i < list.size(); ++i) {
                dl.set(i, (Object)list.get(i));
            }
            return dl;
        }

        public MapCodec<SmallCauldronRecipe> method_53736() {
            return JSON_CODEC;
        }

        public class_9139<class_9129, SmallCauldronRecipe> method_56104() {
            return NET_CODEC;
        }
    }
}

