/*
 * Decompiled with CFR 0.152.
 */
package net.grapes.hexalia.block.custom;

import com.google.common.collect.ImmutableList;
import net.grapes.hexalia.block.ModBlocks;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.FlintAndSteelItem;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.AbstractCandleBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.HorizontalDirectionalBlock;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.Nullable;

public class CandleSkullBlock
extends Block {
    public static final VoxelShape SHAPE = Shapes.m_83110_((VoxelShape)Shapes.m_83048_((double)0.25, (double)0.0, (double)0.25, (double)0.75, (double)0.5, (double)0.75), (VoxelShape)Shapes.m_83048_((double)0.4375, (double)0.453125, (double)0.4375, (double)0.5625, (double)0.640625, (double)0.5625));
    public static final DirectionProperty FACING = HorizontalDirectionalBlock.f_54117_;
    public static final BooleanProperty LIT = AbstractCandleBlock.f_151895_;
    public static final BooleanProperty WATERLOGGED = BlockStateProperties.f_61362_;
    private static final Iterable<Vec3> PARTICLE_OFFSETS = ImmutableList.of((Object)new Vec3(0.5, 0.75, 0.5));

    public CandleSkullBlock(BlockBehaviour.Properties pProperties) {
        super(pProperties);
        this.m_49959_((BlockState)((BlockState)((BlockState)this.m_49966_().m_61124_((Property)FACING, (Comparable)Direction.NORTH)).m_61124_((Property)LIT, (Comparable)Boolean.valueOf(false))).m_61124_((Property)WATERLOGGED, (Comparable)Boolean.valueOf(false)));
    }

    public VoxelShape m_5940_(BlockState pState, BlockGetter pLevel, BlockPos pPos, CollisionContext pContext) {
        return SHAPE;
    }

    @Nullable
    public BlockState m_5573_(BlockPlaceContext pContext) {
        BlockPos blockPos = pContext.m_8083_();
        Level level = pContext.m_43725_();
        FluidState fluidState = level.m_6425_(blockPos);
        return (BlockState)((BlockState)((BlockState)this.m_49966_().m_61124_((Property)FACING, (Comparable)pContext.m_8125_().m_122424_())).m_61124_((Property)WATERLOGGED, (Comparable)Boolean.valueOf(fluidState.m_76152_() == Fluids.f_76193_))).m_61124_((Property)LIT, (Comparable)Boolean.valueOf(false));
    }

    public FluidState m_5888_(BlockState pState) {
        return (Boolean)pState.m_61143_((Property)WATERLOGGED) != false ? Fluids.f_76193_.m_76068_(false) : super.m_5888_(pState);
    }

    public BlockState m_7417_(BlockState pState, Direction pDirection, BlockState pNeighborState, LevelAccessor pLevel, BlockPos pPos, BlockPos pNeighborPos) {
        if (pDirection == Direction.DOWN && !pState.m_60710_((LevelReader)pLevel, pPos)) {
            return Blocks.f_50016_.m_49966_();
        }
        return super.m_7417_(pState, pDirection, pNeighborState, pLevel, pPos, pNeighborPos);
    }

    public boolean m_7898_(BlockState pState, LevelReader pLevel, BlockPos pPos) {
        return pLevel.m_8055_(pPos.m_7495_()).m_280296_();
    }

    public RenderShape m_7514_(BlockState pState) {
        return RenderShape.MODEL;
    }

    public BlockState m_6843_(BlockState state, Rotation rotation) {
        return (BlockState)state.m_61124_((Property)FACING, (Comparable)rotation.m_55954_((Direction)state.m_61143_((Property)FACING)));
    }

    public BlockState m_6943_(BlockState state, Mirror mirror) {
        return state.m_60717_(mirror.m_54846_((Direction)state.m_61143_((Property)FACING)));
    }

    public InteractionResult m_6227_(BlockState pState, Level pLevel, BlockPos pPos, Player pPlayer, InteractionHand pHand, BlockHitResult pHit) {
        ItemStack itemStack = pPlayer.m_21120_(pHand);
        if (itemStack.m_41720_() instanceof FlintAndSteelItem) {
            if (!((Boolean)pState.m_61143_((Property)LIT)).booleanValue() && !((Boolean)pState.m_61143_((Property)WATERLOGGED)).booleanValue()) {
                pLevel.m_46597_(pPos, (BlockState)pState.m_61124_((Property)LIT, (Comparable)Boolean.valueOf(true)));
                itemStack.m_41622_(1, (LivingEntity)pPlayer, p -> p.m_21190_(pHand));
                pLevel.m_5594_(null, pPos, SoundEvents.f_11942_, SoundSource.BLOCKS, 1.0f, pLevel.f_46441_.m_188501_() * 0.4f + 0.8f);
                return InteractionResult.SUCCESS;
            }
        } else if (itemStack.m_41619_() && ((Boolean)pState.m_61143_((Property)LIT)).booleanValue()) {
            pLevel.m_46597_(pPos, (BlockState)pState.m_61124_((Property)LIT, (Comparable)Boolean.valueOf(false)));
            pLevel.m_5594_(null, pPos, SoundEvents.f_144098_, SoundSource.BLOCKS, 1.0f, pLevel.f_46441_.m_188501_() * 0.4f + 0.8f);
            return InteractionResult.SUCCESS;
        }
        return InteractionResult.PASS;
    }

    public void m_214162_(BlockState pState, Level pLevel, BlockPos pPos, RandomSource pRandom) {
        if (!((Boolean)pState.m_61143_((Property)LIT)).booleanValue()) {
            return;
        }
        CandleSkullBlock.getParticleOffsets().forEach(offset -> CandleSkullBlock.spawnCandleParticles(pLevel, offset.m_82520_((double)pPos.m_123341_(), (double)pPos.m_123342_(), (double)pPos.m_123343_()), pRandom));
    }

    private static void spawnCandleParticles(Level pLevel, Vec3 vec3, RandomSource pRandom) {
        BlockPos pos;
        BlockState state;
        Block block;
        float chance = pRandom.m_188501_();
        if (chance < 0.3f) {
            pLevel.m_7106_((ParticleOptions)ParticleTypes.f_123762_, vec3.f_82479_, vec3.f_82480_, vec3.f_82481_, 0.0, 0.0, 0.0);
            if (chance < 0.17f) {
                pLevel.m_7785_(vec3.f_82479_ + 0.5, vec3.f_82480_ + 0.5, vec3.f_82481_ + 0.5, SoundEvents.f_144096_, SoundSource.BLOCKS, 1.0f + pRandom.m_188501_(), pRandom.m_188501_() * 0.7f + 0.3f, false);
            }
        }
        if ((block = (state = pLevel.m_8055_(pos = new BlockPos((int)Math.floor(vec3.f_82479_), (int)Math.floor(vec3.f_82480_), (int)Math.floor(vec3.f_82481_)))).m_60734_()) == ModBlocks.WITHER_CANDLE_SKULL.get()) {
            pLevel.m_7106_((ParticleOptions)ParticleTypes.f_123745_, vec3.f_82479_, vec3.f_82480_, vec3.f_82481_, 0.0, 0.0, 0.0);
        } else {
            pLevel.m_7106_((ParticleOptions)ParticleTypes.f_123744_, vec3.f_82479_, vec3.f_82480_, vec3.f_82481_, 0.0, 0.0, 0.0);
        }
    }

    public static Iterable<Vec3> getParticleOffsets() {
        return PARTICLE_OFFSETS;
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> pBuilder) {
        pBuilder.m_61104_(new Property[]{FACING, WATERLOGGED, LIT});
    }
}

