/*
 * Decompiled with CFR 0.152.
 */
package net.grapes.hexalia.block.custom;

import net.grapes.hexalia.block.custom.EnchantedPlantBlock;
import net.grapes.hexalia.item.ModItems;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.RandomSource;
import net.minecraft.world.Difficulty;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.monster.Skeleton;
import net.minecraft.world.entity.monster.WitherSkeleton;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.SkullBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraftforge.common.IPlantable;

public class GrimshadeBlock
extends EnchantedPlantBlock {
    public GrimshadeBlock(BlockBehaviour.Properties pProperties) {
        super(pProperties);
    }

    public InteractionResult m_6227_(BlockState pState, Level pLevel, BlockPos pPos, Player pPlayer, InteractionHand pHand, BlockHitResult pHit) {
        if (pPlayer.m_21120_(pHand).m_41720_() == ModItems.HEX_FOCUS.get()) {
            if (!pLevel.f_46443_) {
                this.spawnActivationEffects(pLevel, pPos);
                this.transformSkulls((ServerLevel)pLevel, pPos);
                this.transformSkeletons((ServerLevel)pLevel, pPos);
            }
            return InteractionResult.SUCCESS;
        }
        return InteractionResult.PASS;
    }

    public void m_214162_(BlockState pState, Level pLevel, BlockPos pPos, RandomSource pRandom) {
        if (pLevel.f_46443_) {
            for (int i = 0; i < 3; ++i) {
                double x = (double)pPos.m_123341_() + 0.5 + (pRandom.m_188500_() - 0.5) * 0.5;
                double y = (double)pPos.m_123342_() + 0.5 + (pRandom.m_188500_() - 0.5) * 0.5;
                double z = (double)pPos.m_123343_() + 0.5 + (pRandom.m_188500_() - 0.5) * 0.5;
                pLevel.m_7106_((ParticleOptions)ParticleTypes.f_123762_, x, y, z, 0.0, 0.0, 0.0);
            }
        }
    }

    protected boolean m_6266_(BlockState pState, BlockGetter pLevel, BlockPos pPos) {
        return super.m_6266_(pState, pLevel, pPos) || pState.m_60713_(Blocks.f_50134_) || pState.m_60713_(Blocks.f_50135_) || pState.m_60713_(Blocks.f_50136_);
    }

    public void m_7892_(BlockState pState, Level pLevel, BlockPos pPos, Entity pEntity) {
        LivingEntity livingentity;
        if (!pLevel.f_46443_ && pLevel.m_46791_() != Difficulty.PEACEFUL && pEntity instanceof LivingEntity && !(livingentity = (LivingEntity)pEntity).m_6673_(pLevel.m_269111_().m_269251_())) {
            livingentity.m_7292_(new MobEffectInstance(MobEffects.f_19615_, 40));
        }
    }

    private void spawnActivationEffects(Level pLevel, BlockPos pPos) {
        this.spawnParticles((ServerLevel)pLevel, pPos);
        this.playDecayingSounds(pLevel, pPos);
    }

    private void spawnParticles(ServerLevel level, BlockPos pos) {
        AABB area = new AABB(pos).m_82400_(2.5);
        for (int i = 0; i < 50; ++i) {
            double x = area.f_82288_ + level.f_46441_.m_188500_() * (area.f_82291_ - area.f_82288_);
            double y = area.f_82289_ + level.f_46441_.m_188500_() * (area.f_82292_ - area.f_82289_);
            double z = area.f_82290_ + level.f_46441_.m_188500_() * (area.f_82293_ - area.f_82290_);
            level.m_8767_((ParticleOptions)ParticleTypes.f_123762_, x, y, z, 2, 0.0, 0.0, 0.0, 0.0);
        }
    }

    private void playDecayingSounds(Level pLevel, BlockPos pos) {
        pLevel.m_5594_(null, pos, SoundEvents.f_12559_, SoundSource.BLOCKS, 1.0f, 1.0f);
        pLevel.m_5594_(null, pos, SoundEvents.f_12404_, SoundSource.BLOCKS, 1.0f, 1.0f);
    }

    private void transformSkeletons(ServerLevel pLevel, BlockPos pPos) {
        AABB area = new AABB(pPos).m_82400_(2.5);
        boolean skeletonTransformed = false;
        for (Entity entity : pLevel.m_45933_(null, area)) {
            if (!(entity instanceof Skeleton)) continue;
            Skeleton skeleton = (Skeleton)entity;
            WitherSkeleton witherSkeleton = (WitherSkeleton)EntityType.f_20497_.m_20615_((Level)pLevel);
            if (witherSkeleton == null) continue;
            witherSkeleton.m_7678_(skeleton.m_20185_(), skeleton.m_20186_(), skeleton.m_20189_(), skeleton.m_146908_(), skeleton.m_146909_());
            skeleton.m_146870_();
            pLevel.m_7967_((Entity)witherSkeleton);
            skeletonTransformed = true;
        }
        if (skeletonTransformed) {
            RandomSource random = pLevel.m_213780_();
            double chance = random.m_188500_();
            if (chance < 0.75) {
                this.spawnWitherRose(pLevel, pPos, random);
                if (chance < 0.5) {
                    this.spawnWitherRose(pLevel, pPos, random);
                }
            }
            pLevel.m_46961_(pPos, false);
        }
    }

    private void transformSkulls(ServerLevel pLevel, BlockPos pPos) {
        AABB area = new AABB(pPos).m_82400_(2.5);
        int skullsTransformed = 0;
        for (Entity entity : pLevel.m_45933_(null, area)) {
            ItemEntity itemEntity;
            if (!(entity instanceof ItemEntity) || (itemEntity = (ItemEntity)entity).m_32055_().m_41720_() != Items.f_42678_ || skullsTransformed >= 3) continue;
            itemEntity.m_32045_(new ItemStack((ItemLike)Items.f_42679_, itemEntity.m_32055_().m_41613_()));
            ++skullsTransformed;
        }
        for (BlockPos blockPos : BlockPos.m_121976_((int)((int)area.f_82288_), (int)((int)area.f_82289_), (int)((int)area.f_82290_), (int)((int)area.f_82291_), (int)((int)area.f_82292_), (int)((int)area.f_82293_))) {
            BlockState blockState = pLevel.m_8055_(blockPos);
            if (blockState.m_60713_(Blocks.f_50310_) && skullsTransformed < 3) {
                pLevel.m_7731_(blockPos, Blocks.f_50312_.m_49966_(), 3);
                ++skullsTransformed;
                continue;
            }
            if (!blockState.m_60713_(Blocks.f_50311_) || skullsTransformed >= 3) continue;
            pLevel.m_7731_(blockPos, (BlockState)Blocks.f_50313_.m_49966_().m_61124_((Property)SkullBlock.f_56314_, (Comparable)((Integer)blockState.m_61143_((Property)SkullBlock.f_56314_))), 3);
            ++skullsTransformed;
        }
        if (skullsTransformed > 0) {
            pLevel.m_46961_(pPos, false);
        }
    }

    private void spawnWitherRose(ServerLevel pLevel, BlockPos pPos, RandomSource random) {
        int x = pPos.m_123341_() + random.m_188503_(5) - 2;
        int z = pPos.m_123343_() + random.m_188503_(5) - 2;
        BlockPos rosePos = new BlockPos(x, pPos.m_123342_(), z);
        if (pLevel.m_46859_(rosePos) && pLevel.m_8055_(rosePos.m_7495_()).canSustainPlant((BlockGetter)pLevel, rosePos.m_7495_(), Direction.UP, (IPlantable)Blocks.f_50070_)) {
            pLevel.m_7731_(rosePos, Blocks.f_50070_.m_49966_(), 3);
        }
    }
}

