/*
 * Decompiled with CFR 0.152.
 */
package net.grapes.hexalia.block.custom;

import java.util.concurrent.ThreadLocalRandom;
import net.grapes.hexalia.block.ModBlocks;
import net.grapes.hexalia.particle.ModParticles;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.SimpleParticleType;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.ShovelItem;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.BonemealableBlock;
import net.minecraft.world.level.block.FarmBlock;
import net.minecraft.world.level.block.StemGrownBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraftforge.common.ForgeHooks;
import net.minecraftforge.common.IPlantable;
import net.minecraftforge.common.PlantType;

public class InfusedFarmlandBlock
extends FarmBlock {
    public static final VoxelShape SHAPE = Block.m_49796_((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)15.0, (double)16.0);

    public InfusedFarmlandBlock(BlockBehaviour.Properties pProperties) {
        super(pProperties);
    }

    public VoxelShape m_5940_(BlockState pState, BlockGetter pLevel, BlockPos pPos, CollisionContext pContext) {
        return SHAPE;
    }

    public InteractionResult m_6227_(BlockState pState, Level pLevel, BlockPos pPos, Player pPlayer, InteractionHand pHand, BlockHitResult pHit) {
        ItemStack itemStack = pPlayer.m_21120_(pHand);
        if (itemStack.m_41720_() instanceof ShovelItem && pState.m_60734_() == ModBlocks.INFUSED_FARMLAND.get() && pHit.m_82434_() != Direction.DOWN && pLevel.m_8055_(pPos.m_7494_()).m_60795_()) {
            pLevel.m_5594_(pPlayer, pPos, SoundEvents.f_12406_, SoundSource.BLOCKS, 1.0f, 1.0f);
            if (!pLevel.f_46443_) {
                this.setToInfusedDirt(pLevel, pPos);
                itemStack.m_41622_(1, (LivingEntity)pPlayer, p -> p.m_21190_(pHand));
            }
            return InteractionResult.SUCCESS;
        }
        return InteractionResult.PASS;
    }

    public boolean m_7898_(BlockState state, LevelReader level, BlockPos pos) {
        BlockState aboveState = level.m_8055_(pos.m_7494_());
        return super.m_7898_(state, level, pos) || aboveState.m_60734_() instanceof StemGrownBlock;
    }

    public void m_213897_(BlockState pState, ServerLevel pLevel, BlockPos pPos, RandomSource pRandom) {
        if (!pState.m_60710_((LevelReader)pLevel, pPos)) {
            this.setToInfusedDirt((Level)pLevel, pPos);
        }
    }

    public void m_213898_(BlockState state, ServerLevel level, BlockPos pos, RandomSource random) {
        BonemealableBlock growable;
        if (!level.m_46758_(pos.m_7494_())) {
            return;
        }
        BlockState aboveState = level.m_8055_(pos.m_7494_());
        Block aboveBlock = aboveState.m_60734_();
        if (aboveBlock instanceof BonemealableBlock && (growable = (BonemealableBlock)aboveBlock).m_7370_((LevelReader)level, pos.m_7494_(), aboveState, false) && ForgeHooks.onCropsGrowPre((Level)level, (BlockPos)pos.m_7494_(), (BlockState)aboveState, (boolean)true)) {
            growable.m_214148_(level, level.f_46441_, pos.m_7494_(), aboveState);
            level.m_8767_((ParticleOptions)((SimpleParticleType)ModParticles.INFUSED_BUBBLE_PARTICLE.get()), (double)pos.m_123341_() + 0.5, (double)pos.m_123342_() + 1.0, (double)pos.m_123343_() + 0.5, 8, 0.5, 0.0, 0.5, 0.05);
            level.m_46796_(2005, pos.m_7494_(), 0);
            ForgeHooks.onCropsGrowPost((Level)level, (BlockPos)pos.m_7494_(), (BlockState)aboveState);
        }
    }

    public BlockState m_5573_(BlockPlaceContext context) {
        return !this.m_49966_().m_60710_((LevelReader)context.m_43725_(), context.m_8083_()) ? ((Block)ModBlocks.INFUSED_DIRT.get()).m_49966_() : super.m_5573_(context);
    }

    public boolean canSustainPlant(BlockState state, BlockGetter world, BlockPos pos, Direction facing, IPlantable plantable) {
        PlantType plantType = plantable.getPlantType(world, pos.m_121945_(facing));
        return plantType == PlantType.CROP || plantType == PlantType.PLAINS;
    }

    private void setToInfusedDirt(Level pLevel, BlockPos pPos) {
        pLevel.m_46597_(pPos, InfusedFarmlandBlock.m_49897_((BlockState)pLevel.m_8055_(pPos), (BlockState)((Block)ModBlocks.INFUSED_DIRT.get()).m_49966_(), (LevelAccessor)pLevel, (BlockPos)pPos));
    }

    public void m_142072_(Level pLevel, BlockState pState, BlockPos pPos, Entity pEntity, float pFallDistance) {
        this.spawnBubbleParticles(pLevel, pPos);
    }

    private void spawnBubbleParticles(Level pLevel, BlockPos pPos) {
        ThreadLocalRandom random = ThreadLocalRandom.current();
        for (int i = 0; i < 8; ++i) {
            double x = (double)pPos.m_123341_() + 0.5 + random.nextDouble(-0.5, 0.5);
            double y = (double)pPos.m_123342_() + 1.0;
            double z = (double)pPos.m_123343_() + 0.5 + random.nextDouble(-0.5, 0.5);
            pLevel.m_7106_((ParticleOptions)ModParticles.INFUSED_BUBBLE_PARTICLE.get(), x, y, z, 0.0, 0.05, 0.0);
        }
    }
}

