/*
 * Decompiled with CFR 0.152.
 */
package net.grapes.hexalia.block.custom;

import net.grapes.hexalia.block.entity.ModBlockEntities;
import net.grapes.hexalia.block.entity.RitualBrazierBlockEntity;
import net.grapes.hexalia.item.ModItems;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.RandomSource;
import net.minecraft.world.Container;
import net.minecraft.world.Containers;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.BaseEntityBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.EntityBlock;
import net.minecraft.world.level.block.HorizontalDirectionalBlock;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraftforge.registries.ForgeRegistries;
import org.jetbrains.annotations.Nullable;

public class RitualBrazierBlock
extends BaseEntityBlock
implements EntityBlock {
    public static final DirectionProperty FACING = HorizontalDirectionalBlock.f_54117_;
    public static final BooleanProperty SALTED = BooleanProperty.m_61465_((String)"salted");
    protected static final VoxelShape SHAPE = Shapes.m_83124_((VoxelShape)Block.m_49796_((double)3.0, (double)0.0, (double)3.0, (double)13.0, (double)1.0, (double)13.0), (VoxelShape[])new VoxelShape[0]);

    public RitualBrazierBlock(BlockBehaviour.Properties pProperties) {
        super(pProperties);
        this.m_49959_((BlockState)((BlockState)((BlockState)this.f_49792_.m_61090_()).m_61124_((Property)FACING, (Comparable)Direction.NORTH)).m_61124_((Property)SALTED, (Comparable)Boolean.valueOf(false)));
    }

    public VoxelShape m_5940_(BlockState pState, BlockGetter pLevel, BlockPos pPos, CollisionContext pContext) {
        return SHAPE;
    }

    public void m_214162_(BlockState state, Level level, BlockPos pos, RandomSource random) {
        RitualBrazierBlockEntity brazier;
        BlockEntity be;
        super.m_214162_(state, level, pos, random);
        if (level.f_46443_ && (be = level.m_7702_(pos)) instanceof RitualBrazierBlockEntity && (brazier = (RitualBrazierBlockEntity)be).isActive()) {
            double x = (double)pos.m_123341_() + 0.5;
            double y = (double)pos.m_123342_() + 0.7;
            double z = (double)pos.m_123343_() + 0.5;
            level.m_7106_((ParticleOptions)ParticleTypes.f_175830_, x + (random.m_188500_() - 0.5) * 0.3, y + random.m_188500_() * 0.3, z + (random.m_188500_() - 0.5) * 0.3, 0.0, 0.02, 0.0);
        }
    }

    public RenderShape m_7514_(BlockState pState) {
        return RenderShape.MODEL;
    }

    public InteractionResult m_6227_(BlockState pState, Level pLevel, BlockPos pPos, Player pPlayer, InteractionHand pHand, BlockHitResult pHit) {
        BlockEntity blockEntity = pLevel.m_7702_(pPos);
        ItemStack heldItem = pPlayer.m_21120_(pHand);
        if (!(blockEntity instanceof RitualBrazierBlockEntity)) {
            return InteractionResult.PASS;
        }
        RitualBrazierBlockEntity ritualBrazierBlockEntity = (RitualBrazierBlockEntity)blockEntity;
        if (pHand == InteractionHand.MAIN_HAND) {
            ResourceLocation itemId = ForgeRegistries.ITEMS.getKey((Object)heldItem.m_41720_());
            if (itemId != null && itemId.m_135815_().contains("salt") && !((Boolean)pState.m_61143_((Property)SALTED)).booleanValue()) {
                pLevel.m_7731_(pPos, (BlockState)pState.m_61124_((Property)SALTED, (Comparable)Boolean.valueOf(true)), 3);
                if (!pPlayer.m_7500_()) {
                    heldItem.m_41774_(1);
                }
                pLevel.m_5594_(null, pPos, SoundEvents.f_144074_, SoundSource.BLOCKS, 1.0f, 1.0f);
                return InteractionResult.m_19078_((boolean)pLevel.f_46443_);
            }
            if (heldItem.m_150930_((Item)ModItems.HEX_FOCUS.get()) && !((Boolean)pState.m_61143_((Property)SALTED)).booleanValue()) {
                if (ritualBrazierBlockEntity.startMoonRitual(pPlayer)) {
                    return InteractionResult.m_19078_((boolean)pLevel.f_46443_);
                }
                return InteractionResult.PASS;
            }
            if (!heldItem.m_41619_() && ritualBrazierBlockEntity.m_7983_() && !heldItem.m_150930_((Item)ModItems.HEX_FOCUS.get()) && !heldItem.m_150930_((Item)ModItems.SALT.get()) && ritualBrazierBlockEntity.addStack(heldItem.m_41620_(1))) {
                this.playItemSound(pLevel, pPos);
                return InteractionResult.m_19078_((boolean)pLevel.f_46443_);
            }
            if (!ritualBrazierBlockEntity.m_7983_() && heldItem.m_41619_()) {
                this.removeItemFromBlock(pLevel, ritualBrazierBlockEntity, pPlayer);
                return InteractionResult.m_19078_((boolean)pLevel.f_46443_);
            }
        }
        return InteractionResult.PASS;
    }

    public void m_6810_(BlockState pState, Level pLevel, BlockPos pPos, BlockState pNewState, boolean pIsMoving) {
        BlockEntity blockEntity;
        if (pState.m_60734_() != pNewState.m_60734_() && (blockEntity = pLevel.m_7702_(pPos)) instanceof RitualBrazierBlockEntity) {
            RitualBrazierBlockEntity ritualBrazierBlockEntity = (RitualBrazierBlockEntity)blockEntity;
            Containers.m_19002_((Level)pLevel, (BlockPos)pPos, (Container)ritualBrazierBlockEntity);
            if (((Boolean)pState.m_61143_((Property)SALTED)).booleanValue()) {
                Containers.m_18992_((Level)pLevel, (double)pPos.m_123341_(), (double)pPos.m_123342_(), (double)pPos.m_123343_(), (ItemStack)new ItemStack((ItemLike)ModItems.SALT.get()));
            }
        }
        super.m_6810_(pState, pLevel, pPos, pNewState, pIsMoving);
    }

    @Nullable
    public BlockState m_5573_(BlockPlaceContext pContext) {
        return (BlockState)((BlockState)this.m_49966_().m_61124_((Property)FACING, (Comparable)pContext.m_8125_().m_122424_())).m_61124_((Property)SALTED, (Comparable)Boolean.valueOf(false));
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> pBuilder) {
        pBuilder.m_61104_(new Property[]{FACING, SALTED});
    }

    public BlockState m_6843_(BlockState pState, Rotation pRotation) {
        return (BlockState)pState.m_61124_((Property)FACING, (Comparable)pRotation.m_55954_((Direction)pState.m_61143_((Property)FACING)));
    }

    public BlockState m_6943_(BlockState pState, Mirror pMirror) {
        return pState.m_60717_(pMirror.m_54846_((Direction)pState.m_61143_((Property)FACING)));
    }

    private void removeItemFromBlock(Level pLevel, RitualBrazierBlockEntity ritualBrazierBlockEntity, Player player) {
        ItemStack stack = ritualBrazierBlockEntity.removeStack();
        if (!player.m_150109_().m_36054_(stack)) {
            Containers.m_18992_((Level)pLevel, (double)player.m_20185_(), (double)player.m_20186_(), (double)player.m_20189_(), (ItemStack)stack);
        }
        this.playItemSound(pLevel, ritualBrazierBlockEntity.m_58899_());
    }

    private void playItemSound(Level pLevel, BlockPos pos) {
        pLevel.m_5594_(null, pos, SoundEvents.f_12019_, SoundSource.BLOCKS, 0.5f, 0.5f);
    }

    @Nullable
    public BlockEntity m_142194_(BlockPos pos, BlockState state) {
        return new RitualBrazierBlockEntity(pos, state);
    }

    @Nullable
    public <T extends BlockEntity> BlockEntityTicker<T> m_142354_(Level pLevel, BlockState pState, BlockEntityType<T> pBlockEntityType) {
        if (pLevel.m_5776_()) {
            return null;
        }
        return RitualBrazierBlock.m_152132_(pBlockEntityType, (BlockEntityType)((BlockEntityType)ModBlockEntities.RITUAL_BRAZIER_BE.get()), (pLevel1, pPos, pState1, pBlockEntity) -> RitualBrazierBlockEntity.tick(pLevel1, pPos, pState1, pBlockEntity));
    }
}

