/*
 * Decompiled with CFR 0.152.
 */
package net.grapes.hexalia.block.custom;

import java.util.concurrent.ThreadLocalRandom;
import net.grapes.hexalia.block.entity.RitualTableBlockEntity;
import net.grapes.hexalia.item.ModItems;
import net.grapes.hexalia.particle.ModParticles;
import net.grapes.hexalia.sound.ModSounds;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.core.particles.SimpleParticleType;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.Container;
import net.minecraft.world.Containers;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.BaseEntityBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.HorizontalDirectionalBlock;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.Nullable;

public class RitualTableBlock
extends BaseEntityBlock {
    public static final DirectionProperty FACING = HorizontalDirectionalBlock.f_54117_;
    public static final VoxelShape SHAPE = RitualTableBlock.createShape();

    public RitualTableBlock(BlockBehaviour.Properties pProperties) {
        super(pProperties);
        this.m_49959_((BlockState)((BlockState)this.f_49792_.m_61090_()).m_61124_((Property)FACING, (Comparable)Direction.NORTH));
    }

    private static VoxelShape createShape() {
        return Shapes.m_83124_((VoxelShape)Shapes.m_83048_((double)0.1875, (double)0.0, (double)0.1875, (double)0.8125, (double)0.125, (double)0.8125), (VoxelShape[])new VoxelShape[]{Shapes.m_83048_((double)0.25, (double)0.125, (double)0.25, (double)0.75, (double)0.625, (double)0.75), Shapes.m_83048_((double)0.1875, (double)0.625, (double)0.1875, (double)0.8125, (double)0.6875, (double)0.8125), Shapes.m_83048_((double)0.125, (double)0.6875, (double)0.125, (double)0.875, (double)0.8125, (double)0.875)});
    }

    @Nullable
    public BlockState m_5573_(BlockPlaceContext pContext) {
        return (BlockState)this.m_49966_().m_61124_((Property)FACING, (Comparable)pContext.m_8125_().m_122424_());
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> pBuilder) {
        pBuilder.m_61104_(new Property[]{FACING});
    }

    public VoxelShape m_5940_(BlockState pState, BlockGetter pLevel, BlockPos pPos, CollisionContext pContext) {
        return SHAPE;
    }

    public RenderShape m_7514_(BlockState pState) {
        return RenderShape.MODEL;
    }

    @Nullable
    public BlockEntity m_142194_(BlockPos pPos, BlockState pState) {
        return new RitualTableBlockEntity(pPos, pState);
    }

    public void m_6810_(BlockState pState, Level pLevel, BlockPos pPos, BlockState pNewState, boolean pIsMoving) {
        BlockEntity blockEntity;
        if (pState.m_60734_() != pNewState.m_60734_() && (blockEntity = pLevel.m_7702_(pPos)) instanceof RitualTableBlockEntity) {
            RitualTableBlockEntity ritualTable = (RitualTableBlockEntity)blockEntity;
            Containers.m_19002_((Level)pLevel, (BlockPos)pPos, (Container)ritualTable);
        }
        super.m_6810_(pState, pLevel, pPos, pNewState, pIsMoving);
    }

    public InteractionResult m_6227_(BlockState pState, Level pLevel, BlockPos pPos, Player pPlayer, InteractionHand pHand, BlockHitResult pHit) {
        BlockEntity blockEntity = pLevel.m_7702_(pPos);
        if (!(blockEntity instanceof RitualTableBlockEntity)) {
            return InteractionResult.PASS;
        }
        RitualTableBlockEntity ritualTableBlockEntity = (RitualTableBlockEntity)blockEntity;
        ItemStack heldItem = pPlayer.m_21120_(pHand);
        if (pHand == InteractionHand.MAIN_HAND) {
            if (!ritualTableBlockEntity.m_7983_() && heldItem.m_41619_()) {
                this.removeItemFromBlock(pLevel, ritualTableBlockEntity, pPlayer);
                return InteractionResult.m_19078_((boolean)pLevel.f_46443_);
            }
            if (!heldItem.m_41619_() && ritualTableBlockEntity.m_7983_() && !heldItem.m_150930_((Item)ModItems.HEX_FOCUS.get()) && ritualTableBlockEntity.addStack(heldItem.m_41620_(1))) {
                this.playItemSound(pLevel, pPos);
                this.spawnParticleEffect(pLevel, pPos, ParticleTypes.f_123759_, 5, 10);
                return InteractionResult.m_19078_((boolean)pLevel.f_46443_);
            }
            if (heldItem.m_150930_((Item)ModItems.HEX_FOCUS.get())) {
                boolean success;
                if (ritualTableBlockEntity.canStartRitual(pLevel, pPos) && (success = ritualTableBlockEntity.startRitual())) {
                    this.spawnSuccessEffects(pLevel, pPos);
                }
                return InteractionResult.m_19078_((boolean)pLevel.f_46443_);
            }
        }
        return InteractionResult.PASS;
    }

    private void removeItemFromBlock(Level pLevel, RitualTableBlockEntity ritualTableBlockEntity, Player player) {
        ItemStack stack = ritualTableBlockEntity.removeStack();
        if (!player.m_150109_().m_36054_(stack)) {
            Containers.m_18992_((Level)pLevel, (double)player.m_20185_(), (double)player.m_20186_(), (double)player.m_20189_(), (ItemStack)stack);
        }
        this.playItemSound(pLevel, ritualTableBlockEntity.m_58899_());
    }

    private void spawnSuccessEffects(Level pLevel, BlockPos pPos) {
        this.spawnParticleEffect(pLevel, pPos, ParticleTypes.f_123809_, 10, 20);
        this.spawnParticleEffect(pLevel, pPos, (SimpleParticleType)ModParticles.LEAVES_PARTICLE.get(), 10, 20);
        this.playRitualSound(pLevel, pPos);
    }

    private void spawnParticleEffect(Level pLevel, BlockPos pPos, SimpleParticleType particleType, int minParticles, int maxParticles) {
        int particleCount = ThreadLocalRandom.current().nextInt(minParticles, maxParticles);
        for (int i = 0; i < particleCount; ++i) {
            double offsetX = ThreadLocalRandom.current().nextDouble(-0.5, 0.5);
            double offsetY = ThreadLocalRandom.current().nextDouble(0.0, 0.5);
            double offsetZ = ThreadLocalRandom.current().nextDouble(-0.5, 0.5);
            pLevel.m_7106_((ParticleOptions)particleType, (double)pPos.m_123341_() + 0.5 + offsetX, (double)pPos.m_123342_() + 1.0 + offsetY, (double)pPos.m_123343_() + 0.5 + offsetZ, 0.0, 0.0, 0.0);
        }
    }

    private void playItemSound(Level pLevel, BlockPos pos) {
        pLevel.m_5594_(null, pos, SoundEvents.f_257000_, SoundSource.BLOCKS, 0.8f, 0.5f);
        pLevel.m_5594_(null, pos, SoundEvents.f_12019_, SoundSource.BLOCKS, 0.8f, 0.5f);
    }

    private void playRitualSound(Level pLevel, BlockPos pos) {
        pLevel.m_5594_(null, pos, (SoundEvent)ModSounds.RITUAL_SUCCESS.get(), SoundSource.BLOCKS, 1.0f, 1.0f);
    }
}

