/*
 * Decompiled with CFR 0.152.
 */
package net.grapes.hexalia.block.entity;

import net.grapes.hexalia.block.entity.ModBlockEntities;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.tags.BlockTags;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.BonemealableBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;

public class LunarLilyBlockEntity
extends BlockEntity {
    private static final int DURATION = 1200;
    private static final int BONEMEAL_INTERVAL = 240;
    private long activationTime = -1L;

    public LunarLilyBlockEntity(BlockPos pPos, BlockState pBlockState) {
        super((BlockEntityType)ModBlockEntities.LUNAR_LILY_BE.get(), pPos, pBlockState);
    }

    public static void tick(Level level, BlockPos pos, BlockState state, LunarLilyBlockEntity entity) {
        if (level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            if (entity.isActive()) {
                long elapsedTime = level.m_46467_() - entity.activationTime;
                if (!LunarLilyBlockEntity.isNight(level)) {
                    entity.deactivate();
                    return;
                }
                if (elapsedTime >= 1200L) {
                    entity.deactivate();
                    return;
                }
                if (elapsedTime % 240L == 0L) {
                    LunarLilyBlockEntity.applyBonemealToCropsAndSaplings(serverLevel, pos);
                }
                entity.m_6596_();
            }
        }
    }

    private static void applyBonemealToCropsAndSaplings(ServerLevel level, BlockPos centerPos) {
        BlockPos.m_121990_((BlockPos)centerPos.m_7918_(-4, -2, -4), (BlockPos)centerPos.m_7918_(4, 2, 4)).forEach(pos -> {
            BlockState state = level.m_8055_(pos);
            Block patt1841$temp = state.m_60734_();
            if (patt1841$temp instanceof BonemealableBlock) {
                BonemealableBlock bonemealableBlock = (BonemealableBlock)patt1841$temp;
                if ((state.m_204336_(BlockTags.f_13073_) || state.m_204336_(BlockTags.f_13104_)) && bonemealableBlock.m_7370_((LevelReader)level, pos, state, false)) {
                    bonemealableBlock.m_214148_(level, level.f_46441_, pos, state);
                    level.m_8767_((ParticleOptions)ParticleTypes.f_123748_, (double)pos.m_123341_() + 0.5, (double)pos.m_123342_() + 0.5, (double)pos.m_123343_() + 0.5, 1, 0.2, 0.2, 0.2, 0.0);
                }
            }
        });
    }

    public boolean isActive() {
        return this.activationTime > 0L && this.f_58857_ != null && this.f_58857_.m_46467_() >= this.activationTime;
    }

    public void activate(long gameTime) {
        this.activationTime = gameTime;
        this.m_6596_();
    }

    public void deactivate() {
        this.activationTime = -1L;
        this.m_6596_();
    }

    private static boolean isNight(Level level) {
        long time = level.m_46468_() % 24000L;
        return time >= 13000L && time <= 23000L;
    }

    protected void m_183515_(CompoundTag pTag) {
        super.m_183515_(pTag);
        pTag.m_128356_("activationTime", this.activationTime);
    }

    public void m_142466_(CompoundTag pTag) {
        super.m_142466_(pTag);
        this.activationTime = pTag.m_128454_("activationTime");
    }
}

