/*
 * Decompiled with CFR 0.152.
 */
package net.grapes.hexalia.block.entity;

import java.util.List;
import net.grapes.hexalia.block.entity.ModBlockEntities;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.RandomSource;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.monster.Drowned;
import net.minecraft.world.entity.monster.Guardian;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;

public class NautiliteBlockEntity
extends BlockEntity {
    private int activeTicks = 0;
    private static final int DURATION = 2400;
    private static final int EFFECT_RADIUS = 16;

    public NautiliteBlockEntity(BlockPos pPos, BlockState pBlockState) {
        super((BlockEntityType)ModBlockEntities.NAUTILITE_BE.get(), pPos, pBlockState);
    }

    public void activate() {
        this.activeTicks = 2400;
    }

    public boolean isActive() {
        return this.activeTicks > 0;
    }

    public static void tick(Level pLevel, BlockPos pPos, BlockState pState, NautiliteBlockEntity pBlockEntity) {
        if (pBlockEntity.isActive()) {
            --pBlockEntity.activeTicks;
            if (pLevel instanceof ServerLevel) {
                ServerLevel serverLevel = (ServerLevel)pLevel;
                AABB area = new AABB(pPos).m_82400_(16.0);
                List players = serverLevel.m_45976_(Player.class, area);
                List mobs = serverLevel.m_45976_(LivingEntity.class, area);
                for (Player player : players) {
                    if (player.m_20070_()) {
                        player.m_7292_(new MobEffectInstance(MobEffects.f_19592_, 40, 0, true, false));
                    }
                    if (!player.m_21023_(MobEffects.f_19599_)) continue;
                    player.m_21195_(MobEffects.f_19599_);
                }
                for (LivingEntity mob : mobs) {
                    if (!(mob instanceof Drowned) && !(mob instanceof Guardian) || !mob.m_20070_() || !pPos.m_123314_((Vec3i)mob.m_20183_(), 16.0)) continue;
                    mob.m_6469_(pLevel.m_269111_().m_269425_(), 2.0f);
                    serverLevel.m_8767_((ParticleOptions)ParticleTypes.f_123795_, mob.m_20185_(), mob.m_20186_(), mob.m_20189_(), 10, 0.5, 0.5, 0.5, 0.1);
                }
                NautiliteBlockEntity.emitParticles(serverLevel, pPos);
            }
            if (pBlockEntity.activeTicks <= 0) {
                pLevel.m_5594_(null, pPos, SoundEvents.f_11824_, SoundSource.BLOCKS, 1.0f, 1.0f);
                pLevel.m_46961_(pPos, false);
            }
        }
    }

    private static void emitParticles(ServerLevel pLevel, BlockPos pPos) {
        Vec3 center = new Vec3((double)pPos.m_123341_() + 0.5, (double)pPos.m_123342_() + 0.5, (double)pPos.m_123343_() + 0.5);
        RandomSource random = pLevel.f_46441_;
        for (int i = 0; i < 5; ++i) {
            double x = center.f_82479_ + (random.m_188500_() - 0.5) * 2.0;
            double y = center.f_82480_ + (random.m_188500_() - 0.5) * 2.0;
            double z = center.f_82481_ + (random.m_188500_() - 0.5) * 2.0;
            pLevel.m_8767_((ParticleOptions)ParticleTypes.f_123795_, x, y, z, 1, 0.0, 0.0, 0.0, 0.0);
        }
    }
}

