/*
 * Decompiled with CFR 0.152.
 */
package net.grapes.hexalia.block.entity;

import java.util.Optional;
import net.grapes.hexalia.block.entity.ModBlockEntities;
import net.grapes.hexalia.recipe.RitualBrazierRecipe;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.NonNullList;
import net.minecraft.core.Vec3i;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.Connection;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.Container;
import net.minecraft.world.ContainerHelper;
import net.minecraft.world.Containers;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.WorldlyContainer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class RitualBrazierBlockEntity
extends BlockEntity
implements WorldlyContainer {
    private static final int MOONLIGHT_DURATION = 400;
    private static final BlockPos.MutableBlockPos mutableWorldPosition = new BlockPos.MutableBlockPos();
    private int timer = 0;
    private boolean active = false;
    private NonNullList<ItemStack> inventory = NonNullList.m_122780_((int)1, (Object)ItemStack.f_41583_);

    public RitualBrazierBlockEntity(BlockPos pos, BlockState state) {
        super((BlockEntityType)ModBlockEntities.RITUAL_BRAZIER_BE.get(), pos, state);
    }

    public static void tick(Level pLevel, BlockPos pPos, BlockState pState, RitualBrazierBlockEntity pBlockEntity) {
        if (pLevel.f_46443_) {
            return;
        }
        if (pBlockEntity.active && !pBlockEntity.m_7983_()) {
            ItemStack itemStack = pBlockEntity.m_8020_(0);
            Optional recipe = pLevel.m_7465_().m_44015_((RecipeType)RitualBrazierRecipe.Type.INSTANCE, (Container)new SimpleContainer(new ItemStack[]{itemStack}), pLevel);
            if (recipe.isPresent()) {
                if (RitualBrazierBlockEntity.isNight(pLevel, pPos)) {
                    ++pBlockEntity.timer;
                    if (pBlockEntity.timer >= 400) {
                        pBlockEntity.m_6836_(0, ItemStack.f_41583_);
                        pBlockEntity.timer = 0;
                        pBlockEntity.setActive(false);
                        pBlockEntity.m_6596_();
                        ItemStack resultStack = ((RitualBrazierRecipe)recipe.get()).m_8043_(pLevel.m_9598_()).m_41777_();
                        Containers.m_18992_((Level)pLevel, (double)((double)pPos.m_123341_() + 0.5), (double)((double)pPos.m_123342_() + 1.0), (double)((double)pPos.m_123343_() + 0.5), (ItemStack)resultStack);
                        RitualBrazierBlockEntity.spawnPoofParticles(pLevel, pPos);
                        pLevel.m_5594_(null, pPos, SoundEvents.f_144242_, SoundSource.BLOCKS, 1.0f, 1.0f);
                    }
                } else {
                    pBlockEntity.cancelRitual();
                }
            } else {
                pBlockEntity.cancelRitual();
            }
        }
    }

    public boolean startMoonRitual(Player player) {
        if (this.m_7983_()) {
            player.m_5661_((Component)Component.m_237115_((String)"message.hexalia.moonlight_ritual.invalid_item"), true);
            return false;
        }
        ItemStack itemStack = this.m_8020_(0);
        Optional recipe = this.f_58857_.m_7465_().m_44015_((RecipeType)RitualBrazierRecipe.Type.INSTANCE, (Container)new SimpleContainer(new ItemStack[]{itemStack}), this.f_58857_);
        if (recipe.isEmpty()) {
            player.m_5661_((Component)Component.m_237115_((String)"message.hexalia.moonlight_ritual.invalid_item"), true);
            return false;
        }
        if (!RitualBrazierBlockEntity.isNight(this.f_58857_, this.f_58858_)) {
            player.m_5661_((Component)Component.m_237115_((String)"message.hexalia.moonlight_ritual.not_night"), true);
            return false;
        }
        this.timer = 1;
        this.setActive(true);
        player.m_5661_((Component)Component.m_237115_((String)"message.hexalia.moonlight_ritual.started"), true);
        return true;
    }

    public void cancelRitual() {
        this.timer = 0;
        this.setActive(false);
        this.m_6596_();
    }

    private static void spawnPoofParticles(Level level, BlockPos pos) {
        if (level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            double x = (double)pos.m_123341_() + 0.5;
            double y = (double)pos.m_123342_() + 1.0;
            double z = (double)pos.m_123343_() + 0.5;
            serverLevel.m_8767_((ParticleOptions)ParticleTypes.f_123759_, x, y, z, 10, 0.2, 0.2, 0.2, 0.02);
        }
    }

    public void setActive(boolean active) {
        if (this.active != active) {
            this.active = active;
            this.m_6596_();
            if (this.f_58857_ != null && !this.f_58857_.f_46443_) {
                this.f_58857_.m_7260_(this.f_58858_, this.m_58900_(), this.m_58900_(), 3);
            }
        }
    }

    public boolean isActive() {
        return this.active;
    }

    private static boolean isNight(Level level, BlockPos pos) {
        boolean isTimeNight;
        mutableWorldPosition.m_122178_(pos.m_123341_(), pos.m_123342_(), pos.m_123343_());
        long time = level.m_46468_() % 24000L;
        boolean bl = isTimeNight = time > 12500L && time < 23000L;
        if (level.m_45527_(mutableWorldPosition.m_7494_())) {
            return isTimeNight && level.m_7445_() > 4;
        }
        return isTimeNight;
    }

    public int[] m_7071_(@NotNull Direction direction) {
        return new int[]{0};
    }

    public boolean m_7155_(int pIndex, ItemStack pItemStack, @Nullable Direction pDirection) {
        return true;
    }

    public boolean m_7157_(int pIndex, ItemStack pStack, Direction pDirection) {
        return true;
    }

    public int m_6643_() {
        return 1;
    }

    public boolean m_7983_() {
        return ((ItemStack)this.inventory.get(0)).m_41619_();
    }

    public void handleUpdateTag(CompoundTag tag) {
        super.handleUpdateTag(tag);
        this.active = tag.m_128471_("Active");
        ContainerHelper.m_18980_((CompoundTag)tag, this.inventory);
    }

    public ItemStack m_8020_(int slot) {
        if (slot < 0 || slot >= this.inventory.size()) {
            return ItemStack.f_41583_;
        }
        return (ItemStack)this.inventory.get(slot);
    }

    public ItemStack getRenderStack() {
        return this.m_8020_(0);
    }

    public ItemStack m_7407_(int pSlot, int pAmount) {
        return ContainerHelper.m_18969_(this.inventory, (int)pSlot, (int)pAmount);
    }

    public ItemStack m_8016_(int pSlot) {
        return ContainerHelper.m_18966_(this.inventory, (int)pSlot);
    }

    public void m_6836_(int pSlot, ItemStack pStack) {
        this.inventory.set(pSlot, (Object)pStack);
        this.m_6596_();
        if (this.f_58857_ != null && !this.f_58857_.f_46443_) {
            this.f_58857_.m_7260_(this.f_58858_, this.m_58900_(), this.m_58900_(), 3);
        }
    }

    public boolean m_6542_(Player pPlayer) {
        return this.f_58858_.m_123331_((Vec3i)pPlayer.m_20183_()) <= 16.0;
    }

    public void m_6211_() {
        this.inventory.clear();
    }

    public int m_6893_() {
        return 1;
    }

    public void m_142466_(CompoundTag pTag) {
        super.m_142466_(pTag);
        this.inventory = NonNullList.m_122780_((int)1, (Object)ItemStack.f_41583_);
        ContainerHelper.m_18980_((CompoundTag)pTag, this.inventory);
        this.timer = pTag.m_128451_("Timer");
        this.active = pTag.m_128471_("Active");
    }

    protected void m_183515_(CompoundTag pTag) {
        super.m_183515_(pTag);
        ContainerHelper.m_18973_((CompoundTag)pTag, this.inventory);
        pTag.m_128405_("Timer", this.timer);
        pTag.m_128379_("Active", this.active);
    }

    public CompoundTag m_5995_() {
        CompoundTag tag = super.m_5995_();
        tag.m_128379_("Active", this.active);
        ContainerHelper.m_18973_((CompoundTag)tag, this.inventory);
        return tag;
    }

    public boolean addStack(ItemStack itemStack) {
        if (this.m_7983_() && !itemStack.m_41619_()) {
            this.m_6836_(0, itemStack.m_41620_(1));
            this.m_6596_();
            return true;
        }
        return false;
    }

    public ItemStack removeStack() {
        if (!this.m_7983_()) {
            if (this.active) {
                this.cancelRitual();
            }
            ItemStack itemStack = this.m_8020_(0).m_41777_();
            this.m_6836_(0, ItemStack.f_41583_);
            this.m_6596_();
            return itemStack;
        }
        return ItemStack.f_41583_;
    }

    public void onDataPacket(Connection net, ClientboundBlockEntityDataPacket pkt) {
        super.onDataPacket(net, pkt);
        if (this.f_58857_ != null && this.f_58857_.f_46443_) {
            this.f_58857_.m_7260_(this.f_58858_, this.m_58900_(), this.m_58900_(), 3);
        }
    }

    @Nullable
    public ClientboundBlockEntityDataPacket getUpdatePacket() {
        return ClientboundBlockEntityDataPacket.m_195640_((BlockEntity)this);
    }
}

