/*
 * Decompiled with CFR 0.152.
 */
package net.grapes.hexalia.block.entity;

import java.util.Iterator;
import java.util.Optional;
import java.util.concurrent.ThreadLocalRandom;
import net.grapes.hexalia.block.custom.RitualBrazierBlock;
import net.grapes.hexalia.block.entity.ModBlockEntities;
import net.grapes.hexalia.block.entity.RitualBrazierBlockEntity;
import net.grapes.hexalia.recipe.TransmutationRecipe;
import net.grapes.hexalia.sound.ModSounds;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.NonNullList;
import net.minecraft.core.Vec3i;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.core.particles.SimpleParticleType;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.Container;
import net.minecraft.world.ContainerHelper;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.WorldlyContainer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.CropBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import org.jetbrains.annotations.Nullable;

public class RitualTableBlockEntity
extends BlockEntity
implements WorldlyContainer {
    private int progress = 0;
    private static final int MAX_PROGRESS = 120;
    private boolean ritualInProgress = false;
    NonNullList<ItemStack> inventory = NonNullList.m_122780_((int)1, (Object)ItemStack.f_41583_);

    public RitualTableBlockEntity(BlockPos pPos, BlockState pBlockState) {
        super((BlockEntityType)ModBlockEntities.RITUAL_TABLE_BE.get(), pPos, pBlockState);
    }

    public boolean startRitual() {
        return this.performTransmutation(this.f_58857_, this.f_58858_);
    }

    public void cancelRitual() {
        this.ritualInProgress = false;
        this.progress = 0;
        this.m_6596_();
    }

    public static void tick(ServerLevel pLevel, BlockPos pPos, BlockState pState, RitualTableBlockEntity ritualTableBlockEntity) {
        if (ritualTableBlockEntity.ritualInProgress) {
            ++ritualTableBlockEntity.progress;
            if (ritualTableBlockEntity.progress >= 120) {
                ritualTableBlockEntity.completeRitual(pLevel, pPos);
            }
            ritualTableBlockEntity.m_6596_();
        }
    }

    private void completeRitual(ServerLevel level, BlockPos pos) {
        this.performRitualEffect(level, pos);
        this.cancelRitual();
    }

    private void performRitualEffect(ServerLevel level, BlockPos pos) {
        level.m_8767_((ParticleOptions)ParticleTypes.f_123809_, (double)pos.m_123341_() + 0.5, (double)(pos.m_123342_() + 1), (double)pos.m_123343_() + 0.5, 20, 0.5, 0.5, 0.5, 0.1);
        level.m_5594_(null, pos, (SoundEvent)ModSounds.RITUAL_SUCCESS.get(), SoundSource.BLOCKS, 1.0f, 1.0f);
    }

    private void spawnParticleEffect(Level pLevel, BlockPos pPos, SimpleParticleType particleType, int minParticles, int maxParticles) {
        int particleCount = ThreadLocalRandom.current().nextInt(minParticles, maxParticles);
        for (int i = 0; i < particleCount; ++i) {
            double offsetX = ThreadLocalRandom.current().nextDouble(-0.5, 0.5);
            double offsetY = ThreadLocalRandom.current().nextDouble(0.0, 0.5);
            double offsetZ = ThreadLocalRandom.current().nextDouble(-0.5, 0.5);
            pLevel.m_7106_((ParticleOptions)particleType, (double)pPos.m_123341_() + 0.5 + offsetX, (double)pPos.m_123342_() + 1.0 + offsetY, (double)pPos.m_123343_() + 0.5 + offsetZ, 0.0, 0.0, 0.0);
        }
    }

    public boolean canStartRitual(Level world, BlockPos tablePos) {
        if (!this.isRitualReady(world, tablePos)) {
            return false;
        }
        ItemStack inputStack = this.m_8020_(0);
        if (inputStack.m_41619_()) {
            this.sendMessageToPlayer(world, tablePos, "message.hexalia.ritual.missing_ingredients");
            this.spawnParticleEffect(world, tablePos, ParticleTypes.f_123762_, 10, 20);
            return false;
        }
        Optional recipeOptional = world.m_7465_().m_44015_((RecipeType)TransmutationRecipe.Type.INSTANCE, (Container)this, world);
        if (recipeOptional.isEmpty()) {
            this.sendMessageToPlayer(world, tablePos, "message.hexalia.ritual.missing_ingredients");
            this.spawnParticleEffect(world, tablePos, ParticleTypes.f_123762_, 10, 20);
            return false;
        }
        TransmutationRecipe recipe = (TransmutationRecipe)recipeOptional.get();
        boolean hasRequiredSalt = this.processSaltBlocks(world, tablePos, recipe, false);
        if (!hasRequiredSalt) {
            this.sendMessageToPlayer(world, tablePos, "message.hexalia.ritual.missing_ingredients");
            this.spawnParticleEffect(world, tablePos, ParticleTypes.f_123762_, 10, 20);
            return false;
        }
        return true;
    }

    private boolean isRitualReady(Level world, BlockPos tablePos) {
        BlockPos[] brazierPositions;
        for (BlockPos pos : brazierPositions = new BlockPos[]{tablePos.m_7918_(-2, 0, 0), tablePos.m_7918_(2, 0, 0), tablePos.m_7918_(0, 0, -2), tablePos.m_7918_(0, 0, 2)}) {
            BlockState blockState = world.m_8055_(pos);
            if (!(blockState.m_60734_() instanceof RitualBrazierBlock)) {
                this.sendMessageToPlayer(world, tablePos, "message.hexalia.ritual.missing_brazier");
                return false;
            }
            if (((Boolean)blockState.m_61143_((Property)RitualBrazierBlock.SALTED)).booleanValue()) continue;
            this.sendMessageToPlayer(world, tablePos, "message.hexalia.ritual.missing_salt");
            return false;
        }
        boolean cropsValid = this.validateAndResetCrops(world, tablePos, false);
        if (!cropsValid) {
            this.sendMessageToPlayer(world, tablePos, "message.hexalia.ritual.invalid_crops");
        }
        return cropsValid;
    }

    private boolean validateAndResetCrops(Level world, BlockPos tablePos, boolean resetCrops) {
        BlockPos[] cropPositions = new BlockPos[]{tablePos.m_7918_(-2, 0, -2), tablePos.m_7918_(-1, 0, -2), tablePos.m_7918_(1, 0, -2), tablePos.m_7918_(2, 0, -2), tablePos.m_7918_(-2, 0, -1), tablePos.m_7918_(-1, 0, -1), tablePos.m_7918_(1, 0, -1), tablePos.m_7918_(2, 0, -1), tablePos.m_7918_(-2, 0, 1), tablePos.m_7918_(-1, 0, 1), tablePos.m_7918_(1, 0, 1), tablePos.m_7918_(2, 0, 1), tablePos.m_7918_(-2, 0, 2), tablePos.m_7918_(-1, 0, 2), tablePos.m_7918_(1, 0, 2), tablePos.m_7918_(2, 0, 2)};
        boolean allCropsValid = true;
        for (BlockPos pos : cropPositions) {
            BlockState state = world.m_8055_(pos);
            Block block = state.m_60734_();
            if (block instanceof CropBlock) {
                CropBlock crop = (CropBlock)block;
                if (crop.m_52305_(state) < crop.m_7419_()) {
                    allCropsValid = false;
                    continue;
                }
                if (!resetCrops) continue;
                BlockState resetState = crop.m_52289_(0);
                world.m_46597_(pos, resetState);
                continue;
            }
            allCropsValid = false;
        }
        return allCropsValid;
    }

    public boolean processSaltBlocks(Level pLevel, BlockPos tablePos, TransmutationRecipe pRecipe, boolean consume) {
        BlockPos[] brazierPositions;
        NonNullList requiredSaltItems = NonNullList.m_122779_();
        requiredSaltItems.addAll(pRecipe.getSaltItems());
        block0: for (BlockPos pos : brazierPositions = new BlockPos[]{tablePos.m_7918_(-2, 0, 0), tablePos.m_7918_(2, 0, 0), tablePos.m_7918_(0, 0, -2), tablePos.m_7918_(0, 0, 2)}) {
            BlockEntity blockEntity = pLevel.m_7702_(pos);
            if (!(blockEntity instanceof RitualBrazierBlockEntity)) continue;
            RitualBrazierBlockEntity brazier = (RitualBrazierBlockEntity)blockEntity;
            Iterator iterator = requiredSaltItems.iterator();
            while (iterator.hasNext()) {
                ItemStack item = (ItemStack)iterator.next();
                if (!ItemStack.m_150942_((ItemStack)brazier.m_8020_(0), (ItemStack)item)) continue;
                iterator.remove();
                if (!consume) continue block0;
                brazier.removeStack();
                brazier.m_6596_();
                BlockState brazierState = pLevel.m_8055_(pos);
                if (((Boolean)brazierState.m_61143_((Property)RitualBrazierBlock.SALTED)).booleanValue()) {
                    pLevel.m_7731_(pos, (BlockState)brazierState.m_61124_((Property)RitualBrazierBlock.SALTED, (Comparable)Boolean.valueOf(false)), 3);
                }
                pLevel.m_7260_(pos, pLevel.m_8055_(pos), pLevel.m_8055_(pos), 3);
                continue block0;
            }
        }
        return requiredSaltItems.isEmpty();
    }

    private void sendMessageToPlayer(Level world, BlockPos pos, String messageKey) {
        Player nearestPlayer;
        if (!world.f_46443_ && (nearestPlayer = world.m_45924_((double)pos.m_123341_(), (double)pos.m_123342_(), (double)pos.m_123343_(), 5.0, false)) != null) {
            nearestPlayer.m_5661_((Component)Component.m_237115_((String)messageKey), true);
        }
    }

    public boolean performTransmutation(Level world, BlockPos pos) {
        SimpleContainer inventory = new SimpleContainer(this.m_6643_());
        ItemStack inputStack = this.m_8020_(0);
        if (!this.isRitualReady(world, pos)) {
            return false;
        }
        if (inputStack.m_41619_()) {
            this.sendMessageToPlayer(world, pos, "message.hexalia.ritual.missing_ingredients");
            return false;
        }
        inventory.m_6836_(0, inputStack);
        Optional recipeOptional = world.m_7465_().m_44015_((RecipeType)TransmutationRecipe.Type.INSTANCE, (Container)this, world);
        if (recipeOptional.isEmpty()) {
            this.sendMessageToPlayer(world, pos, "message.hexalia.ritual.missing_ingredients");
            return false;
        }
        TransmutationRecipe recipe = (TransmutationRecipe)recipeOptional.get();
        boolean hasRequiredSalt = this.processSaltBlocks(world, pos, recipe, false);
        if (!hasRequiredSalt) {
            this.sendMessageToPlayer(world, pos, "message.hexalia.ritual.missing_ingredients");
            return false;
        }
        this.processSaltBlocks(world, pos, recipe, true);
        this.m_7407_(0, 1);
        this.m_6836_(0, recipe.m_8043_(world.m_9598_()).m_41777_());
        this.m_6596_();
        world.m_7260_(pos, world.m_8055_(pos), world.m_8055_(pos), 3);
        this.validateAndResetCrops(world, pos, true);
        return true;
    }

    public int[] m_7071_(Direction pSide) {
        return new int[0];
    }

    public boolean m_7155_(int pIndex, ItemStack pItemStack, @Nullable Direction pDirection) {
        return true;
    }

    public boolean m_7157_(int pIndex, ItemStack pStack, Direction pDirection) {
        return true;
    }

    public int m_6643_() {
        return 1;
    }

    public boolean m_7983_() {
        return ((ItemStack)this.inventory.get(0)).m_41619_();
    }

    public ItemStack m_8020_(int slot) {
        if (slot < 0 || slot >= this.inventory.size()) {
            return ItemStack.f_41583_;
        }
        return (ItemStack)this.inventory.get(slot);
    }

    public ItemStack m_7407_(int pSlot, int pAmount) {
        return ContainerHelper.m_18969_(this.inventory, (int)pSlot, (int)pAmount);
    }

    public ItemStack m_8016_(int pSlot) {
        return ContainerHelper.m_18966_(this.inventory, (int)pSlot);
    }

    public void m_6836_(int pSlot, ItemStack pStack) {
        this.inventory.set(pSlot, (Object)pStack);
    }

    public boolean m_6542_(Player pPlayer) {
        return this.f_58858_.m_123331_((Vec3i)pPlayer.m_20183_()) <= 16.0;
    }

    public void m_6211_() {
        this.inventory.clear();
    }

    public int m_6893_() {
        return 1;
    }

    public void m_142466_(CompoundTag pTag) {
        super.m_142466_(pTag);
        this.inventory = NonNullList.m_122780_((int)1, (Object)ItemStack.f_41583_);
        ContainerHelper.m_18980_((CompoundTag)pTag, this.inventory);
        this.progress = pTag.m_128451_("Progress");
        this.ritualInProgress = pTag.m_128471_("RitualInProgress");
    }

    protected void m_183515_(CompoundTag pTag) {
        super.m_183515_(pTag);
        ContainerHelper.m_18973_((CompoundTag)pTag, this.inventory);
        pTag.m_128405_("Progress", this.progress);
        pTag.m_128379_("RitualInProgress", this.ritualInProgress);
    }

    public CompoundTag m_5995_() {
        return this.m_187482_();
    }

    public boolean addStack(ItemStack itemStack) {
        if (this.m_7983_() && !itemStack.m_41619_()) {
            this.m_6836_(0, itemStack.m_41620_(1));
            this.m_6596_();
            return true;
        }
        return false;
    }

    public ItemStack removeStack() {
        if (!this.m_7983_()) {
            ItemStack itemStack = this.m_8020_(0).m_41620_(1);
            this.m_6596_();
            return itemStack;
        }
        return ItemStack.f_41583_;
    }

    public ItemStack getRenderStack() {
        ItemStack stack = (ItemStack)this.inventory.get(0);
        if (stack.m_41619_()) {
            stack = (ItemStack)this.inventory.get(0);
        }
        return stack;
    }

    @Nullable
    public ClientboundBlockEntityDataPacket getUpdatePacket() {
        return ClientboundBlockEntityDataPacket.m_195640_((BlockEntity)this);
    }
}

