/*
 * Decompiled with CFR 0.152.
 */
package net.grapes.hexalia.block.entity;

import java.util.Optional;
import net.grapes.hexalia.block.entity.HeatingBlockEntity;
import net.grapes.hexalia.block.entity.ModBlockEntities;
import net.grapes.hexalia.item.ModItems;
import net.grapes.hexalia.recipe.SmallCauldronRecipe;
import net.grapes.hexalia.screen.SmallCauldronMenu;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.world.Container;
import net.minecraft.world.Containers;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ContainerData;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemStackHandler;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SmallCauldronBlockEntity
extends BlockEntity
implements MenuProvider,
HeatingBlockEntity {
    private final ItemStackHandler itemHandler = new ItemStackHandler(5){

        protected void onContentsChanged(int slot) {
            SmallCauldronBlockEntity.this.m_6596_();
        }

        public boolean isItemValid(int slot, @NotNull ItemStack stack) {
            return switch (slot) {
                case 4 -> {
                    if (stack.m_41720_() == ModItems.RUSTIC_BOTTLE.get()) {
                        yield true;
                    }
                    yield false;
                }
                case 0, 1, 2 -> {
                    if (stack.m_41720_() != ModItems.RUSTIC_BOTTLE.get()) {
                        yield true;
                    }
                    yield false;
                }
                case 3 -> false;
                default -> super.isItemValid(slot, stack);
            };
        }
    };
    private static final int INPUT_SLOT_1 = 0;
    private static final int INPUT_SLOT_2 = 1;
    private static final int INPUT_SLOT_3 = 2;
    private static final int OUTPUT_SLOT = 3;
    private static final int BOTTLE_SLOT = 4;
    protected final ContainerData data;
    private int progress = 0;
    private int maxProgress = 175;
    private LazyOptional<IItemHandler> lazyItemHandler = LazyOptional.empty();

    public SmallCauldronBlockEntity(BlockPos pPos, BlockState pBlockState) {
        super((BlockEntityType)ModBlockEntities.SMALL_CAULDRON_BE.get(), pPos, pBlockState);
        this.data = new ContainerData(){

            public int m_6413_(int pIndex) {
                return switch (pIndex) {
                    case 0 -> SmallCauldronBlockEntity.this.progress;
                    case 1 -> SmallCauldronBlockEntity.this.maxProgress;
                    default -> 0;
                };
            }

            public void m_8050_(int pIndex, int pValue) {
                switch (pIndex) {
                    case 0: {
                        SmallCauldronBlockEntity.this.progress = pValue;
                        break;
                    }
                    case 1: {
                        SmallCauldronBlockEntity.this.maxProgress = pValue;
                    }
                }
            }

            public int m_6499_() {
                return 2;
            }
        };
    }

    public Component m_5446_() {
        return Component.m_237115_((String)"block.hexalia.small_cauldron");
    }

    @NotNull
    public <T> LazyOptional<T> getCapability(@NotNull Capability<T> cap, @Nullable Direction side) {
        if (cap == ForgeCapabilities.ITEM_HANDLER) {
            return this.lazyItemHandler.cast();
        }
        return super.getCapability(cap, side);
    }

    public void drops() {
        SimpleContainer inventory = new SimpleContainer(this.itemHandler.getSlots());
        for (int i = 0; i < this.itemHandler.getSlots(); ++i) {
            inventory.m_6836_(i, this.itemHandler.getStackInSlot(i));
        }
        Containers.m_19002_((Level)this.f_58857_, (BlockPos)this.f_58858_, (Container)inventory);
    }

    @Nullable
    public AbstractContainerMenu m_7208_(int pContainerId, Inventory pPlayerInventory, Player pPlayer) {
        return new SmallCauldronMenu(pContainerId, pPlayerInventory, this, this.data);
    }

    public void onLoad() {
        super.onLoad();
        this.lazyItemHandler = LazyOptional.of(() -> this.itemHandler);
    }

    public void invalidateCaps() {
        super.invalidateCaps();
        this.lazyItemHandler.invalidate();
    }

    protected void m_183515_(CompoundTag pTag) {
        pTag.m_128365_("inventory", (Tag)this.itemHandler.serializeNBT());
        super.m_183515_(pTag);
    }

    public void m_142466_(CompoundTag pTag) {
        super.m_142466_(pTag);
        this.itemHandler.deserializeNBT(pTag.m_128469_("inventory"));
    }

    public void tick(Level pLevel, BlockPos pPos, BlockState pState) {
        if (this.isOutputSlotEmptyOrReceivable() && this.hasRecipe() && this.isHeated()) {
            this.increaseCraftingProcess();
            SmallCauldronBlockEntity.m_155232_((Level)pLevel, (BlockPos)pPos, (BlockState)pState);
            if (this.hasProgressFinished()) {
                this.craftItem();
                this.resetProgress();
            }
        } else {
            this.resetProgress();
        }
    }

    private void resetProgress() {
        this.progress = 0;
    }

    private void craftItem() {
        Optional<SmallCauldronRecipe> recipe = this.getCurrentRecipe();
        ItemStack resultItem = recipe.get().m_8043_(this.m_58904_().m_9598_());
        this.getCurrentRecipe().ifPresent(recipes -> {
            this.itemHandler.extractItem(0, 1, false);
            this.itemHandler.extractItem(1, 1, false);
            this.itemHandler.extractItem(2, 1, false);
            this.itemHandler.extractItem(4, 1, false);
        });
        this.itemHandler.setStackInSlot(3, new ItemStack((ItemLike)resultItem.m_41720_(), this.itemHandler.getStackInSlot(3).m_41613_() + resultItem.m_41613_()));
    }

    private boolean hasProgressFinished() {
        return this.progress >= this.maxProgress;
    }

    private void increaseCraftingProcess() {
        ++this.progress;
    }

    private boolean hasRecipe() {
        Optional<SmallCauldronRecipe> recipe = this.getCurrentRecipe();
        if (recipe.isEmpty()) {
            return false;
        }
        ItemStack resultItem = recipe.get().m_8043_(this.m_58904_().m_9598_());
        return this.canInsertAmountIntoOutputSlot(resultItem.m_41613_()) && this.canInsertItemIntoOutputSlot(resultItem.m_41720_()) && this.hasRequiredIngredients(recipe.get());
    }

    private boolean hasRequiredIngredients(SmallCauldronRecipe recipe) {
        boolean hasRusticBottle = recipe.getBottleSlot().test(this.itemHandler.getStackInSlot(4));
        if (!hasRusticBottle) {
            return false;
        }
        for (Ingredient ingredient : recipe.m_7527_()) {
            boolean foundIngredient = false;
            for (int i = 0; i <= 2; ++i) {
                if (!ingredient.test(this.itemHandler.getStackInSlot(i))) continue;
                foundIngredient = true;
                break;
            }
            if (foundIngredient) continue;
            return false;
        }
        return true;
    }

    public boolean isHeated() {
        return this.f_58857_ != null && this.isHeated(this.f_58857_, this.f_58858_);
    }

    private Optional<SmallCauldronRecipe> getCurrentRecipe() {
        SimpleContainer inventory = new SimpleContainer(this.itemHandler.getSlots());
        for (int i = 0; i < this.itemHandler.getSlots(); ++i) {
            inventory.m_6836_(i, this.itemHandler.getStackInSlot(i));
        }
        return this.f_58857_.m_7465_().m_44015_((RecipeType)SmallCauldronRecipe.Type.INSTANCE, (Container)inventory, this.f_58857_);
    }

    private boolean canInsertItemIntoOutputSlot(Item item) {
        return this.itemHandler.getStackInSlot(3).m_41619_() || this.itemHandler.getStackInSlot(3).m_150930_(item);
    }

    private boolean canInsertAmountIntoOutputSlot(int count) {
        return this.itemHandler.getStackInSlot(3).m_41741_() >= this.itemHandler.getStackInSlot(3).m_41613_() + count;
    }

    private boolean isOutputSlotEmptyOrReceivable() {
        return this.itemHandler.getStackInSlot(3).m_41619_() || this.itemHandler.getStackInSlot(3).m_41613_() < this.itemHandler.getStackInSlot(3).m_41741_();
    }
}

