/*
 * Decompiled with CFR 0.152.
 */
package net.grapes.hexalia.block.entity;

import java.util.List;
import net.grapes.hexalia.block.entity.ModBlockEntities;
import net.grapes.hexalia.sound.ModSounds;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.projectile.Projectile;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;

public class WindsongBlockEntity
extends BlockEntity {
    private int activeTicks = 0;
    private static final int DURATION = 600;
    private static final int AREA_RADIUS = 6;
    private int particleCooldown = 0;

    public WindsongBlockEntity(BlockPos pPos, BlockState pBlockState) {
        super((BlockEntityType)ModBlockEntities.WINDSONG_BE.get(), pPos, pBlockState);
    }

    public void activate() {
        this.activeTicks = 600;
    }

    public boolean isActive() {
        return this.activeTicks > 0;
    }

    public void tick(Level pLevel, BlockPos pPos, BlockState pState) {
        if (this.isActive()) {
            --this.activeTicks;
            if (pLevel instanceof ServerLevel) {
                ServerLevel serverLevel = (ServerLevel)pLevel;
                AABB area = new AABB(pPos).m_82400_(6.0);
                List projectiles = serverLevel.m_6443_(Entity.class, area, entity -> entity instanceof Projectile);
                for (Entity projectile : projectiles) {
                    if (projectile.m_213877_()) continue;
                    this.discardProjectile(serverLevel, projectile);
                }
                this.emitParticles(serverLevel, pPos);
            }
            if (this.activeTicks <= 0) {
                pLevel.m_5594_(null, pPos, (SoundEvent)ModSounds.WIND_BURST.get(), SoundSource.BLOCKS, 1.0f, 1.0f);
                pLevel.m_46961_(pPos, false);
            }
        }
    }

    private void discardProjectile(ServerLevel pLevel, Entity projectile) {
        pLevel.m_6263_(null, projectile.m_20185_(), projectile.m_20186_(), projectile.m_20189_(), (SoundEvent)ModSounds.WIND_DEFLECT.get(), SoundSource.BLOCKS, 1.0f, 1.0f);
        Vec3 pos = projectile.m_20182_();
        for (int i = 0; i < 5; ++i) {
            double angle = Math.random() * 2.0 * Math.PI;
            double radius = Math.random() * 0.5;
            double x = pos.f_82479_ + radius * Math.cos(angle);
            double z = pos.f_82481_ + radius * Math.sin(angle);
            double y = pos.f_82480_ + Math.random() * 0.5;
            pLevel.m_8767_((ParticleOptions)ParticleTypes.f_123806_, x, y, z, 1, 0.0, 0.0, 0.0, 0.1);
        }
        projectile.m_146870_();
    }

    private void emitParticles(ServerLevel pLevel, BlockPos pPos) {
        if (this.particleCooldown <= 0) {
            Vec3 center = new Vec3((double)pPos.m_123341_() + 0.5, (double)pPos.m_123342_() + 0.5, (double)pPos.m_123343_() + 0.5);
            for (int i = 0; i < 3; ++i) {
                double angle = Math.random() * 2.0 * Math.PI;
                double radius = Math.random() * 6.0;
                double x = center.f_82479_ + radius * Math.cos(angle);
                double z = center.f_82481_ + radius * Math.sin(angle);
                double y = center.f_82480_ + Math.random() * 2.0;
                pLevel.m_8767_((ParticleOptions)ParticleTypes.f_123796_, x, y, z, 1, 0.0, 0.0, 0.0, 0.1);
            }
            this.particleCooldown = 5;
        } else {
            --this.particleCooldown;
        }
    }
}

