/*
 * Decompiled with CFR 0.152.
 */
package net.grapes.hexalia.censer;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.function.BiConsumer;
import net.grapes.hexalia.block.ModBlocks;
import net.grapes.hexalia.block.custom.CenserBlock;
import net.grapes.hexalia.block.entity.CenserBlockEntity;
import net.grapes.hexalia.censer.HerbCombination;
import net.grapes.hexalia.item.ModItems;
import net.grapes.hexalia.sound.ModSounds;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.Container;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobCategory;
import net.minecraft.world.entity.NeutralMob;
import net.minecraft.world.entity.animal.Animal;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.HopperBlockEntity;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;

public class CenserEffectHandler {
    public static final int AREA_RADIUS = 16;
    public static final int EFFECT_DURATION = 7200;
    public static final Map<HerbCombination, BiConsumer<Level, BlockPos>> EFFECTS = Map.of(new HerbCombination((Item)ModItems.SIREN_KELP.get(), ((Block)ModBlocks.SPIRIT_BLOOM.get()).m_5456_()), CenserEffectHandler::applyFireproofPresence, new HerbCombination(((Block)ModBlocks.GHOST_FERN.get()).m_5456_(), ((Block)ModBlocks.SPIRIT_BLOOM.get()).m_5456_()), CenserEffectHandler::applyUndeadVeil, new HerbCombination(((Block)ModBlocks.GHOST_FERN.get()).m_5456_(), (Item)ModItems.SIREN_KELP.get()), CenserEffectHandler::applyLivestockComfort, new HerbCombination(((Block)ModBlocks.DREAMSHROOM.get()).m_5456_(), ((Block)ModBlocks.SPIRIT_BLOOM.get()).m_5456_()), CenserEffectHandler::applyAnvilHarmony, new HerbCombination(((Block)ModBlocks.DREAMSHROOM.get()).m_5456_(), (Item)ModItems.SIREN_KELP.get()), CenserEffectHandler::applyFishersBoon, new HerbCombination(((Block)ModBlocks.DREAMSHROOM.get()).m_5456_(), ((Block)ModBlocks.GHOST_FERN.get()).m_5456_()), CenserEffectHandler::applySuctionZone);
    private static final Map<BlockPos, ActiveCenserEffect> ACTIVE_EFFECTS = new HashMap<BlockPos, ActiveCenserEffect>();

    public static void registerActiveEffect(Level level, BlockPos pos, HerbCombination combo, int remainingTime) {
        if (level.m_5776_()) {
            return;
        }
        ACTIVE_EFFECTS.put(pos, new ActiveCenserEffect(null, remainingTime, combo));
        CenserEffectHandler.applyEffects(level, pos, combo);
    }

    public static void removeActiveEffect(BlockPos pos) {
        ACTIVE_EFFECTS.remove(pos);
    }

    public static void startEffect(Level level, BlockPos pos, HerbCombination combo) {
        if (level.m_5776_()) {
            return;
        }
        ACTIVE_EFFECTS.put(pos, new ActiveCenserEffect(null, 7200, combo));
        CenserEffectHandler.applyEffects(level, pos, combo);
        BlockEntity blockEntity = level.m_7702_(pos);
        if (blockEntity instanceof CenserBlockEntity) {
            CenserBlockEntity censer = (CenserBlockEntity)blockEntity;
            censer.setActiveCombination(combo);
            censer.setBurnTime(7200);
        }
    }

    public static void updateEffects(Level level) {
        Iterator<Map.Entry<BlockPos, ActiveCenserEffect>> it = ACTIVE_EFFECTS.entrySet().iterator();
        while (it.hasNext()) {
            Map.Entry<BlockPos, ActiveCenserEffect> entry = it.next();
            BlockPos pos = entry.getKey();
            ActiveCenserEffect effect = entry.getValue();
            effect.decrementDuration();
            if (effect.isExpired()) {
                CenserEffectHandler.clearEffect(level, pos, effect.combo());
                it.remove();
                continue;
            }
            CenserEffectHandler.applyEffects(level, pos, effect.combo());
        }
    }

    private static void clearEffect(Level level, BlockPos pos, HerbCombination combo) {
        AABB area = new AABB(pos).m_82400_(16.0);
        level.m_45976_(Player.class, area).forEach(player -> {
            player.getPersistentData().m_128473_("HexaliaAnvilHarmony");
            player.getPersistentData().m_128473_("HexaliaFishersBoon");
        });
    }

    public static void applyEffects(Level level, BlockPos pos, HerbCombination combo) {
        if (level.m_5776_()) {
            return;
        }
        EFFECTS.getOrDefault(combo, (l, p) -> {}).accept(level, pos);
    }

    private static void applyFireproofPresence(Level level, BlockPos pos) {
        AABB area = new AABB(pos).m_82400_(16.0);
        level.m_45976_(LivingEntity.class, area).forEach(entity -> {
            entity.m_7311_(0);
            entity.m_7292_(new MobEffectInstance(MobEffects.f_19607_, 100, 0, false, false, true));
        });
    }

    private static void applyUndeadVeil(Level level, BlockPos pos) {
        AABB area = new AABB(pos).m_82400_(16.0);
        level.m_6443_(Mob.class, area, e -> e instanceof Monster && e.getClassification(false) == MobCategory.MONSTER).forEach(mob -> {
            mob.m_6710_(null);
            mob.m_6703_(null);
            mob.m_6598_(null);
            if (mob instanceof NeutralMob) {
                NeutralMob neutralMob = (NeutralMob)mob;
                neutralMob.m_6925_(null);
                neutralMob.m_21662_();
            }
            if (!mob.m_21023_(MobEffects.f_19619_)) {
                mob.m_7292_(new MobEffectInstance(MobEffects.f_19619_, 140, 0, false, false));
            }
            mob.m_21310_(40);
        });
    }

    private static void applyLivestockComfort(Level level, BlockPos pos) {
        AABB area = new AABB(pos).m_82400_(16.0);
        level.m_45976_(Animal.class, area).forEach(animal -> {
            if (animal.m_146764_() < 0) {
                animal.m_146740_((int)((double)animal.m_146764_() * 0.5), true);
            }
        });
    }

    private static void applyAnvilHarmony(Level level, BlockPos pos) {
        level.m_45976_(Player.class, new AABB(pos).m_82400_(16.0)).forEach(player -> player.getPersistentData().m_128379_("HexaliaAnvilHarmony", true));
    }

    private static void applyFishersBoon(Level level, BlockPos pos) {
        level.m_45976_(Player.class, new AABB(pos).m_82400_(16.0)).forEach(player -> player.getPersistentData().m_128379_("HexaliaFishersBoon", true));
    }

    private static void applySuctionZone(Level level, BlockPos pos) {
        if (!(level instanceof ServerLevel)) {
            return;
        }
        ServerLevel serverLevel = (ServerLevel)level;
        AABB area = new AABB(pos).m_82400_(16.0);
        List items = serverLevel.m_45976_(ItemEntity.class, area);
        if (items.isEmpty()) {
            return;
        }
        List<HopperBlockEntity> hoppers = BlockPos.m_121990_((BlockPos)BlockPos.m_274561_((double)area.f_82288_, (double)area.f_82289_, (double)area.f_82290_), (BlockPos)BlockPos.m_274561_((double)area.f_82291_, (double)area.f_82292_, (double)area.f_82293_)).map(arg_0 -> ((ServerLevel)serverLevel).m_7702_(arg_0)).filter(be -> be instanceof HopperBlockEntity).map(be -> (HopperBlockEntity)be).toList();
        for (ItemEntity item : items) {
            if (item.m_213877_()) continue;
            Vec3 itemPos = item.m_20182_();
            boolean itemAbsorbed = false;
            if (!hoppers.isEmpty()) {
                for (HopperBlockEntity hopper : hoppers) {
                    ItemStack remaining = HopperBlockEntity.m_59326_(null, (Container)hopper, (ItemStack)item.m_32055_().m_41777_(), null);
                    if (remaining.m_41619_()) {
                        itemAbsorbed = true;
                        break;
                    }
                    if (remaining.m_41613_() >= item.m_32055_().m_41613_()) continue;
                    item.m_32045_(remaining);
                    CenserEffectHandler.playSuctionEffects(serverLevel, itemPos);
                }
            } else {
                Player nearestPlayer = (Player)CenserEffectHandler.findNearestEntity(itemPos, serverLevel.m_45976_(Player.class, area));
                if (nearestPlayer != null) {
                    item.m_6123_(nearestPlayer);
                }
            }
            if (!itemAbsorbed) continue;
            CenserEffectHandler.playSuctionEffects(serverLevel, itemPos);
            item.m_146870_();
        }
    }

    private static void playSuctionEffects(ServerLevel level, Vec3 pos) {
        level.m_6263_(null, pos.f_82479_, pos.f_82480_, pos.f_82481_, (SoundEvent)ModSounds.WIND_BURST.get(), SoundSource.BLOCKS, 0.7f, 0.9f + level.f_46441_.m_188501_() * 0.2f);
        for (int i = 0; i < 8; ++i) {
            double angle = level.f_46441_.m_188500_() * 2.0 * Math.PI;
            double radius = level.f_46441_.m_188500_() * 0.5;
            double x = pos.f_82479_ + radius * Math.cos(angle);
            double z = pos.f_82481_ + radius * Math.sin(angle);
            double y = pos.f_82480_ + level.f_46441_.m_188500_() * 0.5;
            level.m_8767_((ParticleOptions)ParticleTypes.f_123806_, x, y, z, 1, 0.0, 0.0, 0.0, 0.1);
        }
    }

    private static <T extends Entity> T findNearestEntity(Vec3 position, List<T> entities) {
        Entity nearest = null;
        double closestDistance = Double.MAX_VALUE;
        for (Entity entity : entities) {
            double distance = position.m_82557_(entity.m_20182_());
            if (!(distance < closestDistance)) continue;
            closestDistance = distance;
            nearest = entity;
        }
        return (T)nearest;
    }

    public static boolean isValidCombination(Item item1, Item item2) {
        HerbCombination combo = new HerbCombination(item1, item2);
        return EFFECTS.containsKey(combo);
    }

    public static void clearPlayerEffectsInRange(Level level, BlockPos pos) {
        AABB area = new AABB(pos).m_82400_(16.0);
        level.m_45976_(Player.class, area).forEach(player -> {
            player.getPersistentData().m_128473_("HexaliaAnvilHarmony");
            player.getPersistentData().m_128473_("HexaliaFishersBoon");
        });
    }

    public static boolean isEffectActiveInArea(Level level, BlockPos pos, EffectType effectType) {
        AABB area = new AABB(pos).m_82400_(16.0);
        ArrayList blockEntities = new ArrayList();
        BlockPos.m_121990_((BlockPos)BlockPos.m_274561_((double)area.f_82288_, (double)area.f_82289_, (double)area.f_82290_), (BlockPos)BlockPos.m_274561_((double)area.f_82291_, (double)area.f_82292_, (double)area.f_82293_)).forEach(blockPos -> {
            BlockEntity be = level.m_7702_(blockPos);
            if (be != null) {
                blockEntities.add(be);
            }
        });
        return blockEntities.stream().anyMatch(be -> {
            if (be instanceof CenserBlockEntity) {
                CenserBlockEntity censer = (CenserBlockEntity)((Object)be);
                if (!((Boolean)censer.m_58900_().m_61143_((Property)CenserBlock.LIT)).booleanValue()) {
                    return false;
                }
                ItemStack herb1 = censer.getItem(0);
                ItemStack herb2 = censer.getItem(1);
                if (herb1.m_41619_() || herb2.m_41619_()) {
                    return false;
                }
                HerbCombination combo = new HerbCombination(herb1.m_41720_(), herb2.m_41720_());
                return CenserEffectHandler.getEffectTypeForCombination(combo) == effectType;
            }
            return false;
        });
    }

    private static EffectType getEffectTypeForCombination(HerbCombination combo) {
        Map<HerbCombination, EffectType> combinationToEffect = Map.of(new HerbCombination((Item)ModItems.SIREN_KELP.get(), ((Block)ModBlocks.SPIRIT_BLOOM.get()).m_5456_()), EffectType.FIREPROOF_PRESENCE, new HerbCombination(((Block)ModBlocks.GHOST_FERN.get()).m_5456_(), ((Block)ModBlocks.SPIRIT_BLOOM.get()).m_5456_()), EffectType.UNDEAD_VEIL, new HerbCombination(((Block)ModBlocks.GHOST_FERN.get()).m_5456_(), (Item)ModItems.SIREN_KELP.get()), EffectType.LIVESTOCK_COMFORT, new HerbCombination(((Block)ModBlocks.DREAMSHROOM.get()).m_5456_(), ((Block)ModBlocks.SPIRIT_BLOOM.get()).m_5456_()), EffectType.ANVIL_HARMONY, new HerbCombination(((Block)ModBlocks.DREAMSHROOM.get()).m_5456_(), (Item)ModItems.SIREN_KELP.get()), EffectType.FISHERS_BOON, new HerbCombination(((Block)ModBlocks.DREAMSHROOM.get()).m_5456_(), ((Block)ModBlocks.GHOST_FERN.get()).m_5456_()), EffectType.SUCTION_ZONE);
        return combinationToEffect.getOrDefault(combo, null);
    }

    public static String getMessageKeyForCombination(HerbCombination combo) {
        if (combo.equals(new HerbCombination((Item)ModItems.SIREN_KELP.get(), ((Block)ModBlocks.SPIRIT_BLOOM.get()).m_5456_()))) {
            return "message.hexalia.censer.fireproof_presence";
        }
        if (combo.equals(new HerbCombination(((Block)ModBlocks.GHOST_FERN.get()).m_5456_(), ((Block)ModBlocks.SPIRIT_BLOOM.get()).m_5456_()))) {
            return "message.hexalia.censer.undead_veil";
        }
        if (combo.equals(new HerbCombination(((Block)ModBlocks.GHOST_FERN.get()).m_5456_(), (Item)ModItems.SIREN_KELP.get()))) {
            return "message.hexalia.censer.livestock_comfort";
        }
        if (combo.equals(new HerbCombination(((Block)ModBlocks.DREAMSHROOM.get()).m_5456_(), ((Block)ModBlocks.SPIRIT_BLOOM.get()).m_5456_()))) {
            return "message.hexalia.censer.anvil_harmony";
        }
        if (combo.equals(new HerbCombination(((Block)ModBlocks.DREAMSHROOM.get()).m_5456_(), (Item)ModItems.SIREN_KELP.get()))) {
            return "message.hexalia.censer.fishers_boon";
        }
        if (combo.equals(new HerbCombination(((Block)ModBlocks.DREAMSHROOM.get()).m_5456_(), ((Block)ModBlocks.GHOST_FERN.get()).m_5456_()))) {
            return "message.hexalia.censer.suction_zone";
        }
        return "message.hexalia.censer.generic_effect";
    }

    private static class ActiveCenserEffect {
        private final EffectType type;
        private int duration;
        private final HerbCombination combo;

        public ActiveCenserEffect(EffectType type, int duration, HerbCombination combo) {
            this.type = type;
            this.duration = duration;
            this.combo = combo;
        }

        public void decrementDuration() {
            --this.duration;
        }

        public boolean isExpired() {
            return this.duration <= 0;
        }

        public HerbCombination combo() {
            return this.combo;
        }
    }

    public static enum EffectType {
        FIREPROOF_PRESENCE,
        UNDEAD_VEIL,
        LIVESTOCK_COMFORT,
        ANVIL_HARMONY,
        FISHERS_BOON,
        SUCTION_ZONE;

    }
}

