/*
 * Decompiled with CFR 0.152.
 */
package net.grapes.hexalia.compat.jei.category;

import java.util.List;
import mezz.jei.api.constants.VanillaTypes;
import mezz.jei.api.gui.builder.IRecipeLayoutBuilder;
import mezz.jei.api.gui.drawable.IDrawable;
import mezz.jei.api.gui.ingredient.IRecipeSlotsView;
import mezz.jei.api.helpers.IGuiHelper;
import mezz.jei.api.ingredients.IIngredientType;
import mezz.jei.api.recipe.IFocusGroup;
import mezz.jei.api.recipe.RecipeIngredientRole;
import mezz.jei.api.recipe.RecipeType;
import mezz.jei.api.recipe.category.IRecipeCategory;
import net.grapes.hexalia.block.ModBlocks;
import net.grapes.hexalia.recipe.RitualBrazierRecipe;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import org.jetbrains.annotations.Nullable;

public class RitualBrazierRecipeCategory
implements IRecipeCategory<RitualBrazierRecipe> {
    public static final ResourceLocation UID = new ResourceLocation("hexalia", "ritual_brazier");
    public static final ResourceLocation TEXTURE = new ResourceLocation("hexalia", "textures/gui/ritual_brazier_gui.png");
    public static final RecipeType<RitualBrazierRecipe> RITUAL_BRAZIER_TYPE = new RecipeType(UID, RitualBrazierRecipe.class);
    private final IDrawable background;
    private final IDrawable icon;
    private final IDrawable hexIcon;
    private final IDrawable moonlightIcon;

    public RitualBrazierRecipeCategory(IGuiHelper helper) {
        this.background = helper.createDrawable(TEXTURE, 0, 0, 118, 80);
        this.icon = helper.createDrawableIngredient((IIngredientType)VanillaTypes.ITEM_STACK, (Object)new ItemStack((ItemLike)ModBlocks.RITUAL_BRAZIER.get()));
        this.hexIcon = helper.createDrawable(TEXTURE, 0, 0, 16, 16);
        this.moonlightIcon = helper.createDrawable(TEXTURE, 0, 0, 16, 16);
    }

    public RecipeType<RitualBrazierRecipe> getRecipeType() {
        return RITUAL_BRAZIER_TYPE;
    }

    public Component getTitle() {
        return Component.m_237115_((String)"block.hexalia.ritual_brazier");
    }

    public IDrawable getBackground() {
        return this.background;
    }

    @Nullable
    public IDrawable getIcon() {
        return this.icon;
    }

    public void setRecipe(IRecipeLayoutBuilder builder, RitualBrazierRecipe recipe, IFocusGroup focuses) {
        builder.addSlot(RecipeIngredientRole.INPUT, 28, 31).addIngredients(recipe.getInput());
        builder.addSlot(RecipeIngredientRole.OUTPUT, 89, 31).addItemStack(recipe.m_8043_(null));
    }

    public void draw(RitualBrazierRecipe recipe, IRecipeSlotsView recipeSlotsView, GuiGraphics guiGraphics, double mouseX, double mouseY) {
        this.hexIcon.draw(guiGraphics, 4, 55);
        this.moonlightIcon.draw(guiGraphics, 51, 31);
    }

    public List<Component> getTooltipStrings(RitualBrazierRecipe recipe, IRecipeSlotsView recipeSlotsView, double mouseX, double mouseY) {
        if (mouseX >= 4.0 && mouseX < 20.0 && mouseY >= 55.0 && mouseY < 71.0) {
            return List.of(Component.m_237115_((String)"tooltip.hexalia.hex_focus_gui"));
        }
        if (mouseX >= 51.0 && mouseX < 67.0 && mouseY >= 31.0 && mouseY < 47.0) {
            return List.of(Component.m_237115_((String)"message.hexalia.moonlight_ritual.not_night"));
        }
        return super.getTooltipStrings((Object)recipe, recipeSlotsView, mouseX, mouseY);
    }
}

