/*
 * Decompiled with CFR 0.152.
 */
package net.grapes.hexalia.compat.patchouli;

import net.grapes.hexalia.recipe.TransmutationRecipe;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import vazkii.patchouli.api.IComponentProcessor;
import vazkii.patchouli.api.IVariable;
import vazkii.patchouli.api.IVariableProvider;

public class TransmutationProcessor
implements IComponentProcessor {
    protected TransmutationRecipe recipe;

    public void setup(Level level, IVariableProvider variables) {
        ResourceLocation recipeId = new ResourceLocation(variables.get("recipe").asString());
        this.recipe = level.m_7465_().m_44043_(recipeId).filter(recipe -> recipe.m_6671_().equals(TransmutationRecipe.Type.INSTANCE)).map(recipe -> (TransmutationRecipe)recipe).orElseThrow(() -> new IllegalArgumentException("Recipe not found: " + recipeId));
    }

    public IVariable process(Level level, String key) {
        ItemStack saltItem;
        int index;
        if (key.equals("output")) {
            ItemStack output = this.recipe.m_8043_(level.m_9598_());
            if (!output.m_41619_()) {
                return IVariable.wrap((String)BuiltInRegistries.f_257033_.m_7981_((Object)output.m_41720_()).toString());
            }
        } else if (key.equals("header")) {
            ItemStack output = this.recipe.m_8043_(level.m_9598_());
            if (!output.m_41619_()) {
                return IVariable.wrap((String)output.m_41786_().getString());
            }
        } else if (key.equals("input")) {
            ItemStack inputItem = this.recipe.getInput();
            if (!inputItem.m_41619_()) {
                return IVariable.wrap((String)BuiltInRegistries.f_257033_.m_7981_((Object)inputItem.m_41720_()).toString());
            }
        } else if (key.startsWith("salt_items") && (index = Integer.parseInt(key.substring(10))) < this.recipe.getSaltItems().size() && !(saltItem = this.recipe.getSaltItems().get(index)).m_41619_()) {
            return IVariable.wrap((String)BuiltInRegistries.f_257033_.m_7981_((Object)saltItem.m_41720_()).toString());
        }
        return null;
    }
}

