/*
 * Decompiled with CFR 0.152.
 */
package net.grapes.hexalia.datagen;

import java.util.List;
import java.util.concurrent.CompletableFuture;
import net.grapes.hexalia.datagen.ModAdvancementsProvider;
import net.grapes.hexalia.datagen.ModBiomeTagProvider;
import net.grapes.hexalia.datagen.ModBlockTagProvider;
import net.grapes.hexalia.datagen.ModGlobalLootModifierProvider;
import net.grapes.hexalia.datagen.ModItemTagProvider;
import net.grapes.hexalia.datagen.ModLootTableProvider;
import net.grapes.hexalia.datagen.ModRecipeProvider;
import net.grapes.hexalia.datagen.ModWorldGenProvider;
import net.minecraft.data.DataGenerator;
import net.minecraft.data.DataProvider;
import net.minecraft.data.PackOutput;
import net.minecraftforge.common.data.ExistingFileHelper;
import net.minecraftforge.common.data.ForgeAdvancementProvider;
import net.minecraftforge.data.event.GatherDataEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(modid="hexalia", bus=Mod.EventBusSubscriber.Bus.MOD)
public class DataGenerators {
    @SubscribeEvent
    public static void gatherData(GatherDataEvent event) {
        DataGenerator generator = event.getGenerator();
        PackOutput packOutput = generator.getPackOutput();
        ExistingFileHelper existingFileHelper = event.getExistingFileHelper();
        CompletableFuture lookupProvider = event.getLookupProvider();
        generator.addProvider(event.includeServer(), (DataProvider)new ModRecipeProvider(packOutput));
        generator.addProvider(event.includeServer(), (DataProvider)ModLootTableProvider.create(packOutput));
        ModBlockTagProvider blockTagsProvider = new ModBlockTagProvider(packOutput, lookupProvider, existingFileHelper);
        ModBiomeTagProvider biomeTagsProvider = new ModBiomeTagProvider(packOutput, lookupProvider, existingFileHelper);
        generator.addProvider(event.includeServer(), (DataProvider)blockTagsProvider);
        generator.addProvider(event.includeServer(), (DataProvider)biomeTagsProvider);
        generator.addProvider(event.includeServer(), (DataProvider)new ModItemTagProvider(packOutput, lookupProvider, blockTagsProvider.m_274426_(), existingFileHelper));
        generator.addProvider(event.includeClient(), (DataProvider)new ForgeAdvancementProvider(packOutput, lookupProvider, existingFileHelper, List.of(new ModAdvancementsProvider())));
        generator.addProvider(event.includeServer(), (DataProvider)new ModWorldGenProvider(packOutput, lookupProvider));
        generator.addProvider(event.includeClient(), (DataProvider)new ModGlobalLootModifierProvider(packOutput));
    }
}

