/*
 * Decompiled with CFR 0.152.
 */
package net.grapes.hexalia.datagen.custom;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Consumer;
import net.grapes.hexalia.recipe.TransmutationRecipe;
import net.minecraft.advancements.Advancement;
import net.minecraft.advancements.AdvancementRewards;
import net.minecraft.advancements.CriterionTriggerInstance;
import net.minecraft.advancements.RequirementsStrategy;
import net.minecraft.advancements.critereon.RecipeUnlockedTrigger;
import net.minecraft.data.recipes.FinishedRecipe;
import net.minecraft.data.recipes.RecipeBuilder;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.level.ItemLike;
import net.minecraftforge.registries.ForgeRegistries;
import org.jetbrains.annotations.Nullable;

public class TransmutationRecipeBuilder
implements RecipeBuilder {
    private final List<Ingredient> ingredients = new ArrayList<Ingredient>();
    private final Item output;
    private final Item input;
    private final Advancement.Builder advancement = Advancement.Builder.m_138353_();

    public TransmutationRecipeBuilder(List<ItemLike> ingredients, ItemLike input, ItemLike output) {
        for (ItemLike ingredient : ingredients) {
            this.ingredients.add(Ingredient.m_43929_((ItemLike[])new ItemLike[]{ingredient}));
        }
        this.input = input.m_5456_();
        this.output = output.m_5456_();
    }

    public RecipeBuilder m_126132_(String pCriterionName, CriterionTriggerInstance pCriterionTrigger) {
        this.advancement.m_138386_(pCriterionName, pCriterionTrigger);
        return this;
    }

    public RecipeBuilder m_126145_(@Nullable String pGroupName) {
        return this;
    }

    public Item m_142372_() {
        return this.output;
    }

    public void m_126140_(Consumer<FinishedRecipe> pFinishedRecipeConsumer, ResourceLocation pRecipeId) {
        this.advancement.m_138396_(new ResourceLocation("recipes/root")).m_138386_("has_the_recipe", (CriterionTriggerInstance)RecipeUnlockedTrigger.m_63728_((ResourceLocation)pRecipeId)).m_138354_(AdvancementRewards.Builder.m_10009_((ResourceLocation)pRecipeId)).m_138360_(RequirementsStrategy.f_15979_);
        pFinishedRecipeConsumer.accept(new Result(pRecipeId, this.output, this.ingredients, this.input, this.advancement, new ResourceLocation(pRecipeId.m_135827_(), "recipes/" + pRecipeId.m_135815_())));
    }

    public static class Result
    implements FinishedRecipe {
        private final ResourceLocation id;
        private final Item output;
        private final List<Ingredient> saltItems;
        private final Item input;
        private final Advancement.Builder advancement;
        private final ResourceLocation advancementId;

        public Result(ResourceLocation id, Item output, List<Ingredient> saltItems, Item input, Advancement.Builder advancement, ResourceLocation advancementId) {
            this.id = id;
            this.output = output;
            this.saltItems = saltItems;
            this.input = input;
            this.advancement = advancement;
            this.advancementId = advancementId;
        }

        public void m_7917_(JsonObject pJson) {
            pJson.addProperty("type", "hexalia:transmutation");
            JsonObject jsonInput = new JsonObject();
            jsonInput.addProperty("item", ForgeRegistries.ITEMS.getKey((Object)this.input).toString());
            pJson.add("input", (JsonElement)jsonInput);
            JsonArray jsonSaltItems = new JsonArray();
            for (Ingredient saltItems : this.saltItems) {
                jsonSaltItems.add(saltItems.m_43942_());
            }
            pJson.add("salt_items", (JsonElement)jsonSaltItems);
            JsonObject jsonOutput = new JsonObject();
            jsonOutput.addProperty("item", ForgeRegistries.ITEMS.getKey((Object)this.output).toString());
            pJson.add("output", (JsonElement)jsonOutput);
        }

        public ResourceLocation m_6445_() {
            return new ResourceLocation("hexalia", ForgeRegistries.ITEMS.getKey((Object)this.output).m_135815_() + "_transmutation");
        }

        public RecipeSerializer<?> m_6637_() {
            return TransmutationRecipe.Serializer.INSTANCE;
        }

        @Nullable
        public JsonObject m_5860_() {
            return this.advancement.m_138400_();
        }

        @Nullable
        public ResourceLocation m_6448_() {
            return this.advancementId;
        }
    }
}

