/*
 * Decompiled with CFR 0.152.
 */
package net.grapes.hexalia.effect.custom;

import java.util.UUID;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectCategory;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.AttributeInstance;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;

public class DaybloomEffect
extends MobEffect {
    private static final int COOLDOWN = 100;
    private static final UUID SPEED_MODIFIER_UUID = UUID.fromString("e1234567-89ab-cdef-0123-456789abcdef");

    public DaybloomEffect(MobEffectCategory pCategory, int pColor) {
        super(pCategory, pColor);
    }

    public void m_6742_(LivingEntity entity, int amplifier) {
        if (entity instanceof Player) {
            Player player = (Player)entity;
            Level level = player.m_9236_();
            if (this.isNight(level)) {
                player.m_6469_(player.m_269291_().m_269425_(), 1.5f);
                this.removeSpeedModifier(player);
            } else if (this.isDay(level)) {
                player.m_5634_(2.0f);
                this.applySpeedModifier(player, amplifier);
            } else {
                this.removeSpeedModifier(player);
            }
        }
    }

    private boolean isDay(Level level) {
        long time = level.m_46468_() % 24000L;
        return time >= 0L && time < 13000L;
    }

    private boolean isNight(Level level) {
        long time = level.m_46468_() % 24000L;
        return time >= 13000L && time <= 23000L;
    }

    private void applySpeedModifier(Player player, int amplifier) {
        AttributeInstance movementSpeedAttribute = player.m_21051_(Attributes.f_22279_);
        if (movementSpeedAttribute != null) {
            this.removeSpeedModifier(player);
            double speedBoost = 0.05 * (double)(amplifier + 1);
            movementSpeedAttribute.m_22118_(new AttributeModifier(SPEED_MODIFIER_UUID, "Daybloom Speed Boost", speedBoost, AttributeModifier.Operation.ADDITION));
        }
    }

    private void removeSpeedModifier(Player player) {
        AttributeInstance movementSpeedAttribute = player.m_21051_(Attributes.f_22279_);
        if (movementSpeedAttribute != null) {
            movementSpeedAttribute.m_22120_(SPEED_MODIFIER_UUID);
        }
    }

    public boolean m_6584_(int pDuration, int pAmplifier) {
        return pDuration % 100 == 0;
    }
}

