/*
 * Decompiled with CFR 0.152.
 */
package net.grapes.hexalia.item.custom;

import java.util.function.Consumer;
import net.grapes.hexalia.item.client.BoggedBootsRenderer;
import net.minecraft.client.model.HumanoidModel;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ArmorItem;
import net.minecraft.world.item.ArmorMaterial;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraftforge.client.extensions.common.IClientItemExtensions;
import org.jetbrains.annotations.NotNull;
import software.bernie.geckolib.animatable.GeoItem;
import software.bernie.geckolib.core.animatable.GeoAnimatable;
import software.bernie.geckolib.core.animatable.instance.AnimatableInstanceCache;
import software.bernie.geckolib.core.animatable.instance.SingletonAnimatableInstanceCache;
import software.bernie.geckolib.core.animation.AnimatableManager;
import software.bernie.geckolib.core.animation.Animation;
import software.bernie.geckolib.core.animation.AnimationController;
import software.bernie.geckolib.core.animation.AnimationState;
import software.bernie.geckolib.core.animation.RawAnimation;
import software.bernie.geckolib.core.object.PlayState;

public class BoggedBootsItem
extends ArmorItem
implements GeoItem {
    private int dolphinsGraceTimer = 0;
    private AnimatableInstanceCache cache = new SingletonAnimatableInstanceCache((GeoAnimatable)this);

    public BoggedBootsItem(ArmorMaterial pMaterial, ArmorItem.Type pType, Item.Properties pProperties) {
        super(pMaterial, pType, pProperties);
    }

    public void initializeClient(Consumer<IClientItemExtensions> consumer) {
        consumer.accept(new IClientItemExtensions(){
            private BoggedBootsRenderer renderer;

            @NotNull
            public HumanoidModel<?> getHumanoidArmorModel(LivingEntity livingEntity, ItemStack itemStack, EquipmentSlot equipmentSlot, HumanoidModel<?> original) {
                if (this.renderer == null) {
                    this.renderer = new BoggedBootsRenderer();
                }
                this.renderer.prepForRender((Entity)livingEntity, itemStack, equipmentSlot, original);
                return this.renderer;
            }
        });
    }

    public void registerControllers(AnimatableManager.ControllerRegistrar controllerRegistrar) {
        controllerRegistrar.add(new AnimationController[]{new AnimationController((GeoAnimatable)this, "controller", 0, this::predicate)});
    }

    private PlayState predicate(AnimationState animationState) {
        animationState.getController().setAnimation(RawAnimation.begin().then("idle", Animation.LoopType.LOOP));
        return PlayState.CONTINUE;
    }

    public AnimatableInstanceCache getAnimatableInstanceCache() {
        return this.cache;
    }

    public void m_6883_(ItemStack pStack, Level pLevel, Entity pEntity, int pSlotId, boolean pIsSelected) {
        if (!pLevel.m_5776_() && pEntity instanceof Player) {
            Player pPlayer = (Player)pEntity;
            if (pPlayer.m_150109_().m_36052_(0).m_150930_((Item)this)) {
                if (pPlayer.m_6069_()) {
                    this.applyDolphinGraceEffect(pPlayer);
                }
                this.removePoisonEffect(pPlayer);
                this.resetTimers();
            } else {
                this.handleEffectRemoval(pPlayer);
            }
        }
        super.m_6883_(pStack, pLevel, pEntity, pSlotId, pIsSelected);
    }

    private void removePoisonEffect(Player pPlayer) {
        if (pPlayer.m_21023_(MobEffects.f_19614_)) {
            pPlayer.m_21195_(MobEffects.f_19614_);
            pPlayer.m_5634_(0.1f);
        }
    }

    private void applyDolphinGraceEffect(Player pPlayer) {
        int duration = 300;
        MobEffectInstance waterBreathingEffect = pPlayer.m_21124_(MobEffects.f_19608_);
        if (!pPlayer.m_21023_(MobEffects.f_19593_) || waterBreathingEffect != null && waterBreathingEffect.m_19557_() <= 200) {
            pPlayer.m_7292_(new MobEffectInstance(MobEffects.f_19593_, duration, 0, false, false, false));
        }
    }

    private void handleEffectRemoval(Player player) {
        if (this.dolphinsGraceTimer < 500) {
            ++this.dolphinsGraceTimer;
        } else {
            player.m_21195_(MobEffects.f_19593_);
        }
    }

    private void resetTimers() {
        this.dolphinsGraceTimer = 0;
    }
}

