/*
 * Decompiled with CFR 0.152.
 */
package net.grapes.hexalia.mixin;

import net.grapes.hexalia.item.ModItems;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.ExperienceOrb;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={LivingEntity.class})
public class ExperienceMixin {
    @Inject(method={"die"}, at={@At(value="HEAD")})
    public void onEntityKilled(DamageSource source, CallbackInfo ci) {
        Player player;
        ItemStack offHandStack;
        Entity entity = source.m_7639_();
        if (entity instanceof Player && (offHandStack = (player = (Player)entity).m_21120_(InteractionHand.OFF_HAND)).m_41720_() == ModItems.SAGE_PENDANT.get()) {
            System.out.println("Wisdom Gem detected in offhand");
            int experience = this.getExperiencePoints();
            System.out.println("Experience obtained: " + experience);
            if (experience > 0) {
                this.spawnExperienceOrbs(experience, player);
                this.reduceDurability(offHandStack, player);
            }
        }
    }

    private int getExperiencePoints() {
        return 40;
    }

    private void spawnExperienceOrbs(int experience, Player player) {
        int xpValue;
        for (int remainingExperience = experience; remainingExperience > 0; remainingExperience -= xpValue) {
            xpValue = ExperienceOrb.m_20782_((int)remainingExperience);
            player.m_9236_().m_7967_((Entity)new ExperienceOrb(player.m_9236_(), player.m_20185_(), player.m_20186_(), player.m_20189_(), xpValue));
        }
    }

    private void reduceDurability(ItemStack stack, Player player) {
        if (!player.m_150110_().f_35937_ && stack.m_41763_()) {
            System.out.println("Reducing durability by: 1");
            stack.m_41622_(1, (LivingEntity)player, p -> p.m_21190_(InteractionHand.OFF_HAND));
            if (stack.m_41619_()) {
                player.m_21008_(InteractionHand.OFF_HAND, ItemStack.f_41583_);
            }
        }
    }
}

