/*
 * Decompiled with CFR 0.152.
 */
package net.grapes.hexalia.mixin;

import java.util.Objects;
import net.grapes.hexalia.effect.ModMobEffects;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={LivingEntity.class})
public class LivingEntityMixin {
    @Unique
    private final LivingEntity livingEntity = (LivingEntity)this;

    @Inject(at={@At(value="HEAD")}, method={"hurt"})
    public void damageMixin(DamageSource source, float amount, CallbackInfoReturnable<Boolean> cir) {
        float healthStealAmount;
        Player player;
        Entity entity = source.m_7639_();
        if (entity instanceof Player && (player = (Player)entity).m_21023_((MobEffect)ModMobEffects.BLOODLUST.get()) && (healthStealAmount = Math.min(6.0f, amount / 4.0f)) >= 1.0f) {
            player.m_5496_(SoundEvents.f_12165_, 1.0f, 1.0f);
            player.m_5634_(healthStealAmount);
        }
    }

    @Inject(at={@At(value="TAIL")}, method={"getDamageAfterArmorAbsorb"})
    public void returnDamage(DamageSource source, float amount, CallbackInfoReturnable<Float> cir) {
        float newAmount = ((Float)cir.getReturnValue()).floatValue();
        Entity attacker = source.m_7639_();
        if (this.livingEntity.m_21023_((MobEffect)ModMobEffects.SPIKESKIN.get()) && attacker instanceof LivingEntity) {
            LivingEntity livingAttacker = (LivingEntity)attacker;
            livingAttacker.m_6469_(livingAttacker.m_269291_().m_269104_((Entity)livingAttacker, (Entity)this.livingEntity), (float)((double)newAmount * 0.2) + (float)Objects.requireNonNull(this.livingEntity.m_21124_((MobEffect)ModMobEffects.SPIKESKIN.get())).m_19564_() + 1.0f);
        }
    }
}

