/*
 * Decompiled with CFR 0.152.
 */
package net.grapes.hexalia.recipe;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.ArrayList;
import java.util.List;
import net.grapes.hexalia.block.entity.RitualTableBlockEntity;
import net.minecraft.core.RegistryAccess;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.GsonHelper;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.item.crafting.ShapedRecipe;
import net.minecraft.world.level.Level;

public class TransmutationRecipe
implements Recipe<RitualTableBlockEntity> {
    private final ResourceLocation id;
    private final ItemStack input;
    private final ItemStack output;
    private final List<ItemStack> saltItems;

    public TransmutationRecipe(ResourceLocation id, ItemStack input, ItemStack output, List<ItemStack> saltItems) {
        this.id = id;
        this.input = input;
        this.output = output;
        this.saltItems = saltItems;
    }

    public boolean matches(RitualTableBlockEntity blockEntity, Level world) {
        ItemStack itemInSlot = blockEntity.m_8020_(0);
        if (!ItemStack.m_41656_((ItemStack)itemInSlot, (ItemStack)this.input)) {
            return false;
        }
        return blockEntity.processSaltBlocks(world, blockEntity.m_58899_(), this, false);
    }

    public ItemStack assemble(RitualTableBlockEntity pContainer, RegistryAccess pRegistryAccess) {
        return this.output.m_41777_();
    }

    public boolean m_8004_(int width, int height) {
        return true;
    }

    public ItemStack m_8043_(RegistryAccess pRegistryAccess) {
        return this.output;
    }

    public ResourceLocation m_6423_() {
        return this.id;
    }

    public RecipeSerializer<?> m_7707_() {
        return Serializer.INSTANCE;
    }

    public List<ItemStack> getSaltItems() {
        return this.saltItems;
    }

    public ItemStack getInput() {
        return this.input;
    }

    public RecipeType<?> m_6671_() {
        return Type.INSTANCE;
    }

    public static class Serializer
    implements RecipeSerializer<TransmutationRecipe> {
        public static final Serializer INSTANCE = new Serializer();

        public TransmutationRecipe fromJson(ResourceLocation id, JsonObject json) {
            ItemStack input = ShapedRecipe.m_151274_((JsonObject)GsonHelper.m_13930_((JsonObject)json, (String)"input"));
            ItemStack output = ShapedRecipe.m_151274_((JsonObject)GsonHelper.m_13930_((JsonObject)json, (String)"output"));
            ArrayList<ItemStack> saltItems = new ArrayList<ItemStack>();
            JsonArray saltArray = GsonHelper.m_13933_((JsonObject)json, (String)"salt_items");
            for (JsonElement element : saltArray) {
                saltItems.add(ShapedRecipe.m_151274_((JsonObject)element.getAsJsonObject()));
            }
            return new TransmutationRecipe(id, input, output, saltItems);
        }

        public TransmutationRecipe fromNetwork(ResourceLocation id, FriendlyByteBuf buffer) {
            ItemStack input = buffer.m_130267_();
            ItemStack output = buffer.m_130267_();
            int saltSize = buffer.readInt();
            ArrayList<ItemStack> saltItems = new ArrayList<ItemStack>();
            for (int i = 0; i < saltSize; ++i) {
                saltItems.add(buffer.m_130267_());
            }
            return new TransmutationRecipe(id, input, output, saltItems);
        }

        public void toNetwork(FriendlyByteBuf buffer, TransmutationRecipe recipe) {
            buffer.m_130055_(recipe.input);
            buffer.m_130055_(recipe.output);
            buffer.writeInt(recipe.saltItems.size());
            for (ItemStack saltItem : recipe.saltItems) {
                buffer.m_130055_(saltItem);
            }
        }
    }

    public static class Type
    implements RecipeType<TransmutationRecipe> {
        public static final Type INSTANCE = new Type();
        public static final String ID = "transmutation";
    }
}

