/*
 * Decompiled with CFR 0.152.
 */
package net.astralya.hexalia.block.custom;

import java.util.Optional;
import net.astralya.hexalia.Configuration;
import net.astralya.hexalia.block.custom.EnchantedPlantBlock;
import net.astralya.hexalia.item.ModItems;
import net.astralya.hexalia.particle.ModParticleType;
import net.astralya.hexalia.recipe.MutationRecipe;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.SimpleParticleType;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.Container;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.BlockHitResult;

public class MorphoraBlock
extends EnchantedPlantBlock {
    public MorphoraBlock(BlockBehaviour.Properties properties) {
        super(properties);
    }

    protected boolean m_6266_(BlockState state, BlockGetter level, BlockPos pos) {
        return state.m_60713_(Blocks.f_50450_) || state.m_60804_(level, pos);
    }

    public InteractionResult m_6227_(BlockState state, Level level, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hit) {
        ItemStack stack = player.m_21120_(hand);
        if (stack.m_41619_() || stack.m_41720_() != ModItems.MUTAVIS.get()) {
            return InteractionResult.PASS;
        }
        if (level.f_46443_) {
            return InteractionResult.SUCCESS;
        }
        ServerLevel server = (ServerLevel)level;
        boolean anyConverted = false;
        int radius = (Integer)Configuration.MORPHORA_RADIUS.get();
        for (int dx = -radius; dx <= radius; ++dx) {
            for (int dz = -radius; dz <= radius; ++dz) {
                Optional match;
                ItemStack inputStack;
                BlockState targetState;
                BlockPos targetPos = pos.m_7918_(dx, 0, dz);
                if (targetPos.equals((Object)pos) || (targetState = server.m_8055_(targetPos)).m_60795_() || (inputStack = targetState.m_60734_().m_5456_().m_7968_()).m_41619_() || !(match = server.m_7465_().m_44015_((RecipeType)MutationRecipe.Type.INSTANCE, (Container)new SimpleContainer(new ItemStack[]{inputStack}), (Level)server)).isPresent()) continue;
                ItemStack result = ((MutationRecipe)match.get()).assemble(new SimpleContainer(new ItemStack[]{inputStack}), server.m_9598_());
                server.m_46961_(targetPos, false);
                if (!result.m_41619_()) {
                    server.m_7967_((Entity)new ItemEntity((Level)server, (double)targetPos.m_123341_() + 0.5, (double)targetPos.m_123342_() + 0.25, (double)targetPos.m_123343_() + 0.5, result.m_41777_()));
                }
                this.emitEffects(server, targetPos);
                anyConverted = true;
            }
        }
        if (anyConverted) {
            if (!player.m_150110_().f_35937_) {
                stack.m_41774_(1);
            }
            return InteractionResult.m_19078_((boolean)level.f_46443_);
        }
        return InteractionResult.PASS;
    }

    private void emitEffects(ServerLevel server, BlockPos pos) {
        server.m_5594_(null, pos, SoundEvents.f_11887_, SoundSource.BLOCKS, 0.5f, 1.0f);
        server.m_8767_((ParticleOptions)((SimpleParticleType)ModParticleType.LEAVES.get()), (double)pos.m_123341_() + 0.5, (double)pos.m_123342_() + 0.6, (double)pos.m_123343_() + 0.5, 15, 0.2, 0.25, 0.2, 0.0);
    }
}

