/*
 * Decompiled with CFR 0.152.
 */
package net.astralya.hexalia.block.custom;

import net.astralya.hexalia.block.custom.EnchantedPlantBlock;
import net.astralya.hexalia.block.entity.custom.NautiliteBlockEntity;
import net.astralya.hexalia.item.ModItems;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.tags.FluidTags;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.EntityBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.phys.BlockHitResult;
import org.jetbrains.annotations.Nullable;

public class NautiliteBlock
extends EnchantedPlantBlock
implements EntityBlock {
    public static final BooleanProperty WATERLOGGED = BlockStateProperties.f_61362_;

    public NautiliteBlock(BlockBehaviour.Properties pProperties) {
        super(pProperties);
        this.m_49959_((BlockState)this.m_49966_().m_61124_((Property)WATERLOGGED, (Comparable)Boolean.valueOf(false)));
    }

    protected boolean m_6266_(BlockState pState, BlockGetter pGetter, BlockPos pPos) {
        return pState.m_60783_(pGetter, pPos, Direction.UP) && !pState.m_60713_(Blocks.f_50450_);
    }

    public InteractionResult m_6227_(BlockState pState, Level pLevel, BlockPos pPos, Player pPlayer, InteractionHand pHand, BlockHitResult pHit) {
        if (pPlayer.m_21120_(pHand).m_41720_() == ModItems.HEX_FOCUS.get()) {
            NautiliteBlockEntity nautiliteBlockEntity;
            BlockEntity blockEntity;
            if (!pLevel.f_46443_ && (blockEntity = pLevel.m_7702_(pPos)) instanceof NautiliteBlockEntity && !(nautiliteBlockEntity = (NautiliteBlockEntity)blockEntity).isActive()) {
                nautiliteBlockEntity.activate();
                this.playActivationEffects((ServerLevel)pLevel, pPos);
            }
            return InteractionResult.SUCCESS;
        }
        return InteractionResult.PASS;
    }

    private void playActivationEffects(ServerLevel pLevel, BlockPos pPos) {
        pLevel.m_5594_(null, pPos, SoundEvents.f_11767_, SoundSource.BLOCKS, 1.0f, 1.0f);
        pLevel.m_8767_((ParticleOptions)ParticleTypes.f_123774_, (double)pPos.m_123341_() + 0.5, (double)pPos.m_123342_() + 0.5, (double)pPos.m_123343_() + 0.5, 50, 0.5, 0.5, 0.5, 0.1);
    }

    public FluidState m_5888_(BlockState pState) {
        return Fluids.f_76193_.m_76068_(false);
    }

    @Nullable
    public BlockState m_5573_(BlockPlaceContext pContext) {
        FluidState fluidstate = pContext.m_43725_().m_6425_(pContext.m_8083_());
        return fluidstate.m_205070_(FluidTags.f_13131_) && fluidstate.m_76186_() == 8 ? super.m_5573_(pContext) : null;
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> pBuilder) {
        pBuilder.m_61104_(new Property[]{WATERLOGGED});
    }

    @Nullable
    public BlockEntity m_142194_(BlockPos pPos, BlockState pState) {
        return new NautiliteBlockEntity(pPos, pState);
    }

    @Nullable
    public <T extends BlockEntity> BlockEntityTicker<T> m_142354_(Level pLevel, BlockState pState, BlockEntityType<T> pBlockEntityType) {
        return pLevel.f_46443_ ? null : (level, pos, state, blockEntity) -> {
            if (blockEntity instanceof NautiliteBlockEntity) {
                NautiliteBlockEntity nautilite = (NautiliteBlockEntity)blockEntity;
                NautiliteBlockEntity.tick(level, pos, state, nautilite);
            }
        };
    }
}

