/*
 * Decompiled with CFR 0.152.
 */
package net.astralya.hexalia.block.custom;

import java.util.function.BiFunction;
import javax.annotation.Nullable;
import net.astralya.hexalia.block.custom.ShroomBlock;
import net.minecraft.Util;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.RandomSource;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.BonemealableBlock;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;

public class PaleMushroomBlock
extends ShroomBlock
implements BonemealableBlock {
    public static final DirectionProperty FACING = BlockStateProperties.f_61374_;
    public static final IntegerProperty AMOUNT = IntegerProperty.m_61631_((String)"flower_amount", (int)1, (int)4);
    private static final BiFunction<Direction, Integer, VoxelShape> SHAPE_BY_PROPERTIES = Util.m_143821_((dir, amount) -> {
        VoxelShape[] quads = new VoxelShape[]{Block.m_49796_((double)8.0, (double)0.0, (double)8.0, (double)16.0, (double)6.0, (double)16.0), Block.m_49796_((double)8.0, (double)0.0, (double)0.0, (double)16.0, (double)6.0, (double)8.0), Block.m_49796_((double)0.0, (double)0.0, (double)0.0, (double)8.0, (double)6.0, (double)8.0), Block.m_49796_((double)0.0, (double)0.0, (double)8.0, (double)8.0, (double)6.0, (double)16.0)};
        VoxelShape shape = Shapes.m_83040_();
        for (int i = 0; i < amount; ++i) {
            int idx = Math.floorMod(i - dir.m_122416_(), 4);
            shape = Shapes.m_83110_((VoxelShape)shape, (VoxelShape)quads[idx]);
        }
        return shape;
    });

    public PaleMushroomBlock(BlockBehaviour.Properties properties) {
        super(properties);
        this.m_49959_((BlockState)((BlockState)((BlockState)this.f_49792_.m_61090_()).m_61124_((Property)FACING, (Comparable)Direction.NORTH)).m_61124_((Property)AMOUNT, (Comparable)Integer.valueOf(1)));
    }

    @Override
    public VoxelShape m_5940_(BlockState state, BlockGetter level, BlockPos pos, CollisionContext context) {
        return SHAPE_BY_PROPERTIES.apply((Direction)state.m_61143_((Property)FACING), (Integer)state.m_61143_((Property)AMOUNT));
    }

    public boolean m_6864_(BlockState state, BlockPlaceContext ctx) {
        return !ctx.m_7078_() && ctx.m_43722_().m_150930_(this.m_5456_()) && (Integer)state.m_61143_((Property)AMOUNT) < 4 || super.m_6864_(state, ctx);
    }

    @Override
    @Nullable
    public BlockState m_5573_(BlockPlaceContext ctx) {
        BlockState existing = ctx.m_43725_().m_8055_(ctx.m_8083_());
        if (existing.m_60713_((Block)this)) {
            int next = Math.min(4, (Integer)existing.m_61143_((Property)AMOUNT) + 1);
            return (BlockState)existing.m_61124_((Property)AMOUNT, (Comparable)Integer.valueOf(next));
        }
        BlockState base = (BlockState)this.m_49966_().m_61124_((Property)FACING, (Comparable)ctx.m_8125_().m_122424_());
        return this.m_7898_(base, (LevelReader)ctx.m_43725_(), ctx.m_8083_()) ? base : null;
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> b) {
        b.m_61104_(new Property[]{FACING, AMOUNT});
    }

    public BlockState m_6843_(BlockState state, Rotation rot) {
        return (BlockState)state.m_61124_((Property)FACING, (Comparable)rot.m_55954_((Direction)state.m_61143_((Property)FACING)));
    }

    public BlockState m_6943_(BlockState state, Mirror mirror) {
        return state.m_60717_(mirror.m_54846_((Direction)state.m_61143_((Property)FACING)));
    }

    public boolean m_7370_(LevelReader level, BlockPos pos, BlockState state, boolean isClientSide) {
        return true;
    }

    public boolean m_214167_(Level level, RandomSource random, BlockPos pos, BlockState state) {
        return true;
    }

    public void m_214148_(ServerLevel level, RandomSource random, BlockPos pos, BlockState state) {
        int amount = (Integer)state.m_61143_((Property)AMOUNT);
        if (amount < 4) {
            level.m_7731_(pos, (BlockState)state.m_61124_((Property)AMOUNT, (Comparable)Integer.valueOf(amount + 1)), 2);
        } else {
            PaleMushroomBlock.m_49840_((Level)level, (BlockPos)pos, (ItemStack)new ItemStack((ItemLike)this));
        }
    }
}

