/*
 * Decompiled with CFR 0.152.
 */
package net.astralya.hexalia.block.custom;

import net.astralya.hexalia.block.entity.custom.RitualBrazierBlockEntity;
import net.astralya.hexalia.item.ModItems;
import net.astralya.hexalia.util.ModTags;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.Containers;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.BaseEntityBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.EntityBlock;
import net.minecraft.world.level.block.HorizontalDirectionalBlock;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.Nullable;

public class RitualBrazierBlock
extends BaseEntityBlock
implements EntityBlock {
    public static final DirectionProperty FACING = HorizontalDirectionalBlock.f_54117_;
    public static final BooleanProperty SALTED = BooleanProperty.m_61465_((String)"salted");
    protected static final VoxelShape SHAPE = Shapes.m_83124_((VoxelShape)Block.m_49796_((double)3.0, (double)0.0, (double)3.0, (double)13.0, (double)1.0, (double)13.0), (VoxelShape[])new VoxelShape[0]);

    public RitualBrazierBlock(BlockBehaviour.Properties pProperties) {
        super(pProperties);
        this.m_49959_((BlockState)((BlockState)((BlockState)this.f_49792_.m_61090_()).m_61124_((Property)FACING, (Comparable)Direction.NORTH)).m_61124_((Property)SALTED, (Comparable)Boolean.valueOf(false)));
    }

    public VoxelShape m_5940_(BlockState pState, BlockGetter pLevel, BlockPos pPos, CollisionContext pContext) {
        return SHAPE;
    }

    @Nullable
    public BlockState m_5573_(BlockPlaceContext pContext) {
        return (BlockState)((BlockState)this.m_49966_().m_61124_((Property)FACING, (Comparable)pContext.m_8125_().m_122424_())).m_61124_((Property)SALTED, (Comparable)Boolean.valueOf(false));
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> pBuilder) {
        pBuilder.m_61104_(new Property[]{FACING, SALTED});
    }

    public RenderShape m_7514_(BlockState pState) {
        return RenderShape.MODEL;
    }

    public InteractionResult m_6227_(BlockState state, Level level, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hit) {
        BlockEntity tileEntity = level.m_7702_(pos);
        ItemStack stack = player.m_21120_(hand);
        if (!(tileEntity instanceof RitualBrazierBlockEntity)) {
            return InteractionResult.PASS;
        }
        RitualBrazierBlockEntity brazier = (RitualBrazierBlockEntity)tileEntity;
        ItemStack heldStack = player.m_21120_(hand);
        ItemStack offhandStack = player.m_21206_();
        if (hand == InteractionHand.MAIN_HAND && !((Boolean)state.m_61143_((Property)SALTED)).booleanValue() && stack.m_204117_(ModTags.Items.SALT) && !((Boolean)state.m_61143_((Property)SALTED)).booleanValue()) {
            level.m_7731_(pos, (BlockState)state.m_61124_((Property)SALTED, (Comparable)Boolean.valueOf(true)), 3);
            if (!player.m_7500_()) {
                heldStack.m_41774_(1);
            }
            level.m_5594_(null, pos, SoundEvents.f_144074_, SoundSource.BLOCKS, 1.0f, 1.0f);
            return InteractionResult.SUCCESS;
        }
        if (brazier.isEmpty()) {
            if (!offhandStack.m_41619_()) {
                if (hand == InteractionHand.MAIN_HAND && !offhandStack.m_204117_(ModTags.Items.OFFHAND_EQUIPMENT) && !(heldStack.m_41720_() instanceof BlockItem)) {
                    return InteractionResult.PASS;
                }
                if (hand == InteractionHand.OFF_HAND && offhandStack.m_204117_(ModTags.Items.OFFHAND_EQUIPMENT)) {
                    return InteractionResult.PASS;
                }
            }
            if (heldStack.m_41619_()) {
                return InteractionResult.PASS;
            }
            if (brazier.addItem(player.m_150110_().f_35937_ ? heldStack.m_41777_() : heldStack)) {
                this.playItemSound(level, pos);
                return InteractionResult.SUCCESS;
            }
        } else if (!heldStack.m_41619_() || !offhandStack.m_41619_()) {
            ItemStack focusStack;
            ItemStack itemStack = heldStack.m_150930_((Item)ModItems.HEX_FOCUS.get()) ? heldStack : (focusStack = offhandStack.m_150930_((Item)ModItems.HEX_FOCUS.get()) ? offhandStack : ItemStack.f_41583_);
            if (!focusStack.m_41619_()) {
                if (!level.m_5776_()) {
                    RitualBrazierBlockEntity.RitualResult result = brazier.tryCelestialRitual();
                    switch (result) {
                        case SUCCESS: {
                            RitualBrazierBlock.spawnPoofParticles(level, pos);
                            level.m_5594_(null, pos, SoundEvents.f_11887_, SoundSource.BLOCKS, 0.25f, 0.25f);
                            break;
                        }
                        case NO_CELESTIAL_BLOOMS: {
                            player.m_5661_((Component)Component.m_237115_((String)"message.hexalia.ritual_brazier.no_celestial_blooms"), true);
                            break;
                        }
                        case INVALID_ITEM: {
                            player.m_5661_((Component)Component.m_237115_((String)"message.hexalia.ritual_brazier.invalid_item"), true);
                        }
                    }
                }
                return InteractionResult.SUCCESS;
            }
        } else if (hand == InteractionHand.MAIN_HAND) {
            if (!player.m_7500_()) {
                if (!player.m_150109_().m_36054_(brazier.removeItem())) {
                    Containers.m_18992_((Level)level, (double)pos.m_123341_(), (double)pos.m_123342_(), (double)pos.m_123343_(), (ItemStack)brazier.removeItem());
                }
            } else {
                brazier.removeItem();
            }
            this.playItemSound(level, pos);
            return InteractionResult.SUCCESS;
        }
        return InteractionResult.PASS;
    }

    public void m_6810_(BlockState state, Level level, BlockPos pos, BlockState newState, boolean movedByPiston) {
        BlockEntity be;
        if (state.m_60734_() != newState.m_60734_() && (be = level.m_7702_(pos)) instanceof RitualBrazierBlockEntity) {
            RitualBrazierBlockEntity brazier = (RitualBrazierBlockEntity)be;
            Containers.m_18992_((Level)level, (double)pos.m_123341_(), (double)pos.m_123342_(), (double)pos.m_123343_(), (ItemStack)brazier.getStoredItem());
            if (((Boolean)state.m_61143_((Property)SALTED)).booleanValue()) {
                Containers.m_18992_((Level)level, (double)pos.m_123341_(), (double)pos.m_123342_(), (double)pos.m_123343_(), (ItemStack)new ItemStack((ItemLike)ModItems.SALT.get()));
            }
        }
        super.m_6810_(state, level, pos, newState, movedByPiston);
    }

    private static void spawnPoofParticles(Level level, BlockPos pos) {
        if (level instanceof ServerLevel) {
            ServerLevel server = (ServerLevel)level;
            server.m_8767_((ParticleOptions)ParticleTypes.f_123759_, (double)pos.m_123341_() + 0.5, (double)pos.m_123342_() + 1.0, (double)pos.m_123343_() + 0.5, 10, 0.2, 0.2, 0.2, 0.02);
        }
    }

    private void playItemSound(Level level, BlockPos pos) {
        level.m_5594_(null, pos, SoundEvents.f_12019_, SoundSource.BLOCKS, 0.25f, 0.25f);
    }

    @Nullable
    public BlockEntity m_142194_(BlockPos pos, BlockState state) {
        return new RitualBrazierBlockEntity(pos, state);
    }
}

