/*
 * Decompiled with CFR 0.152.
 */
package net.astralya.hexalia.block.custom.censer;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.WeakHashMap;
import java.util.function.BiConsumer;
import net.astralya.hexalia.Configuration;
import net.astralya.hexalia.block.ModBlocks;
import net.astralya.hexalia.block.custom.CenserBlock;
import net.astralya.hexalia.block.custom.censer.HerbCombination;
import net.astralya.hexalia.block.entity.custom.CenserBlockEntity;
import net.astralya.hexalia.item.ModItems;
import net.astralya.hexalia.sound.ModSoundEvents;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.Container;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobCategory;
import net.minecraft.world.entity.NeutralMob;
import net.minecraft.world.entity.animal.Animal;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.AnvilBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.HopperBlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;

public class CenserEffectHandler {
    private static final Map<Level, Set<BlockPos>> UNDEAD_VEIL_CACHE = new WeakHashMap<Level, Set<BlockPos>>();
    private static final int MINERS_RESPITE_EFFECT_REFRESH_TICKS = 300;
    public static final Map<HerbCombination, BiConsumer<Level, BlockPos>> EFFECTS = Map.of(new HerbCombination((Item)ModItems.SIREN_KELP.get(), ((Block)ModBlocks.SPIRIT_BLOOM.get()).m_5456_()), CenserEffectHandler::applyFireproofPresence, new HerbCombination(((Block)ModBlocks.GHOST_FERN.get()).m_5456_(), ((Block)ModBlocks.SPIRIT_BLOOM.get()).m_5456_()), CenserEffectHandler::applyUndeadVeil, new HerbCombination(((Block)ModBlocks.GHOST_FERN.get()).m_5456_(), (Item)ModItems.SIREN_KELP.get()), CenserEffectHandler::applyLivestockComfort, new HerbCombination(((Block)ModBlocks.DREAMSHROOM.get()).m_5456_(), ((Block)ModBlocks.SPIRIT_BLOOM.get()).m_5456_()), CenserEffectHandler::applyMinersRespite, new HerbCombination(((Block)ModBlocks.DREAMSHROOM.get()).m_5456_(), (Item)ModItems.SIREN_KELP.get()), CenserEffectHandler::applyFishersBoon, new HerbCombination(((Block)ModBlocks.DREAMSHROOM.get()).m_5456_(), ((Block)ModBlocks.GHOST_FERN.get()).m_5456_()), CenserEffectHandler::applySuctionZone);
    private static final Map<BlockPos, ActiveCenserEffect> ACTIVE_EFFECTS = new HashMap<BlockPos, ActiveCenserEffect>();

    public static void registerActiveEffect(Level level, BlockPos pos, HerbCombination combo, int remainingTime) {
        if (level.m_5776_()) {
            return;
        }
        ACTIVE_EFFECTS.put(pos, new ActiveCenserEffect(null, remainingTime, combo));
        CenserEffectHandler.applyEffects(level, pos, combo);
        if (CenserEffectHandler.getEffectTypeForCombination(combo) == EffectType.UNDEAD_VEIL) {
            UNDEAD_VEIL_CACHE.computeIfAbsent(level, k -> new HashSet()).add(pos.m_7949_());
        }
    }

    public static void removeActiveEffect(BlockPos pos) {
        EffectType effectType;
        ActiveCenserEffect effect = ACTIVE_EFFECTS.get(pos);
        if (effect != null && (effectType = CenserEffectHandler.getEffectTypeForCombination(effect.combo())) == EffectType.UNDEAD_VEIL) {
            for (Map.Entry<Level, Set<BlockPos>> entry : UNDEAD_VEIL_CACHE.entrySet()) {
                if (entry.getValue().remove(pos)) break;
            }
        }
        ACTIVE_EFFECTS.remove(pos);
    }

    public static void startEffect(Level level, BlockPos pos, HerbCombination combo) {
        if (level.m_5776_()) {
            return;
        }
        int duration = (Integer)Configuration.CENSER_EFFECT_DURATION.get();
        ACTIVE_EFFECTS.put(pos, new ActiveCenserEffect(null, duration, combo));
        CenserEffectHandler.applyEffects(level, pos, combo);
        BlockEntity blockEntity = level.m_7702_(pos);
        if (blockEntity instanceof CenserBlockEntity) {
            CenserBlockEntity censer = (CenserBlockEntity)blockEntity;
            censer.setActiveCombination(combo);
            censer.setBurnTime(duration);
        }
        if (CenserEffectHandler.getEffectTypeForCombination(combo) == EffectType.MINERS_RESPITE && level instanceof ServerLevel) {
            ServerLevel sl = (ServerLevel)level;
            CenserEffectHandler.repairAnvilsInArea(sl, pos, (Integer)Configuration.CENSER_EFFECT_RADIUS.get());
        }
    }

    public static void updateEffects(Level level) {
        Iterator<Map.Entry<BlockPos, ActiveCenserEffect>> it = ACTIVE_EFFECTS.entrySet().iterator();
        while (it.hasNext()) {
            Map.Entry<BlockPos, ActiveCenserEffect> entry = it.next();
            BlockPos pos = entry.getKey();
            ActiveCenserEffect effect = entry.getValue();
            effect.decrementDuration();
            if (effect.isExpired()) {
                CenserEffectHandler.clearEffect(level, pos, effect.combo());
                it.remove();
                continue;
            }
            CenserEffectHandler.applyEffects(level, pos, effect.combo());
        }
    }

    private static void clearEffect(Level level, BlockPos pos, HerbCombination combo) {
        int radius = (Integer)Configuration.CENSER_EFFECT_RADIUS.get();
        AABB area = new AABB(pos).m_82400_((double)radius);
        level.m_45976_(Player.class, area).forEach(player -> player.getPersistentData().m_128473_("HexaliaFishersBoon"));
    }

    public static void applyEffects(Level level, BlockPos pos, HerbCombination combo) {
        if (level.m_5776_()) {
            return;
        }
        EFFECTS.getOrDefault(combo, (l, p) -> {}).accept(level, pos);
    }

    private static void applyFireproofPresence(Level level, BlockPos pos) {
        int radius = (Integer)Configuration.CENSER_EFFECT_RADIUS.get();
        AABB area = new AABB(pos).m_82400_((double)radius);
        level.m_45976_(LivingEntity.class, area).forEach(entity -> {
            entity.m_7311_(0);
            entity.m_7292_(new MobEffectInstance(MobEffects.f_19607_, 100, 0, false, false, true));
        });
    }

    private static void applyUndeadVeil(Level level, BlockPos pos) {
        int radius = (Integer)Configuration.CENSER_EFFECT_RADIUS.get();
        AABB area = new AABB(pos).m_82400_((double)radius);
        level.m_6443_(Mob.class, area, e -> e instanceof Monster && e.getClassification(false) == MobCategory.MONSTER).forEach(mob -> {
            mob.m_6710_(null);
            mob.m_6703_(null);
            mob.m_6598_(null);
            if (mob instanceof NeutralMob) {
                NeutralMob neutralMob = (NeutralMob)mob;
                neutralMob.m_6925_(null);
                neutralMob.m_21662_();
            }
            if (!mob.m_21023_(MobEffects.f_19619_)) {
                mob.m_7292_(new MobEffectInstance(MobEffects.f_19619_, 140, 0, false, false));
            }
            mob.m_21310_(40);
        });
    }

    private static void applyLivestockComfort(Level level, BlockPos pos) {
        int radius = (Integer)Configuration.CENSER_EFFECT_RADIUS.get();
        AABB area = new AABB(pos).m_82400_((double)radius);
        level.m_45976_(Animal.class, area).forEach(animal -> {
            if (animal.m_146764_() < 0) {
                animal.m_146740_((int)((double)animal.m_146764_() * 0.5), true);
            }
        });
    }

    private static void applyMinersRespite(Level level, BlockPos censerPos) {
        if (!(level instanceof ServerLevel)) {
            return;
        }
        ServerLevel serverLevel = (ServerLevel)level;
        int radius = (Integer)Configuration.CENSER_EFFECT_RADIUS.get();
        AABB area = new AABB(censerPos).m_82400_((double)radius);
        serverLevel.m_45976_(Player.class, area).forEach(player -> {
            player.m_7292_(new MobEffectInstance(MobEffects.f_19611_, 300, 0, false, false, true));
            player.m_7292_(new MobEffectInstance(MobEffects.f_19598_, 300, 1, false, false, true));
        });
    }

    private static void repairAnvilsInArea(ServerLevel level, BlockPos center, int radius) {
        AABB area = new AABB(center).m_82400_((double)radius);
        BlockPos min = BlockPos.m_274561_((double)area.f_82288_, (double)area.f_82289_, (double)area.f_82290_);
        BlockPos max = BlockPos.m_274561_((double)area.f_82291_, (double)area.f_82292_, (double)area.f_82293_);
        for (BlockPos bp : BlockPos.m_121940_((BlockPos)min, (BlockPos)max)) {
            BlockState state = level.m_8055_(bp);
            if (!(state.m_60734_() instanceof AnvilBlock)) continue;
            Direction facing = state.m_61138_((Property)AnvilBlock.f_48764_) ? (Direction)state.m_61143_((Property)AnvilBlock.f_48764_) : Direction.NORTH;
            BlockState repaired = null;
            if (state.m_60713_(Blocks.f_50324_)) {
                repaired = Blocks.f_50323_.m_49966_();
            } else if (state.m_60713_(Blocks.f_50323_)) {
                repaired = Blocks.f_50322_.m_49966_();
            }
            if (repaired == null) continue;
            if (repaired.m_61138_((Property)AnvilBlock.f_48764_)) {
                repaired = (BlockState)repaired.m_61124_((Property)AnvilBlock.f_48764_, (Comparable)facing);
            }
            level.m_7731_(bp, repaired, 3);
            level.m_5594_(null, bp, SoundEvents.f_11671_, SoundSource.BLOCKS, 0.35f, 1.2f);
            level.m_8767_((ParticleOptions)ParticleTypes.f_123748_, (double)bp.m_123341_() + 0.5, (double)bp.m_123342_() + 1.0, (double)bp.m_123343_() + 0.5, 3, 0.25, 0.15, 0.25, 0.0);
        }
    }

    private static void applyFishersBoon(Level level, BlockPos pos) {
        int radius = (Integer)Configuration.CENSER_EFFECT_RADIUS.get();
        level.m_45976_(Player.class, new AABB(pos).m_82400_((double)radius)).forEach(player -> player.getPersistentData().m_128379_("HexaliaFishersBoon", true));
    }

    private static void applySuctionZone(Level level, BlockPos pos) {
        if (!(level instanceof ServerLevel)) {
            return;
        }
        ServerLevel serverLevel = (ServerLevel)level;
        int radius = (Integer)Configuration.CENSER_EFFECT_RADIUS.get();
        AABB area = new AABB(pos).m_82400_((double)radius);
        List items = serverLevel.m_45976_(ItemEntity.class, area);
        if (items.isEmpty()) {
            return;
        }
        List<HopperBlockEntity> hoppers = BlockPos.m_121990_((BlockPos)BlockPos.m_274561_((double)area.f_82288_, (double)area.f_82289_, (double)area.f_82290_), (BlockPos)BlockPos.m_274561_((double)area.f_82291_, (double)area.f_82292_, (double)area.f_82293_)).map(arg_0 -> ((ServerLevel)serverLevel).m_7702_(arg_0)).filter(be -> be instanceof HopperBlockEntity).map(be -> (HopperBlockEntity)be).toList();
        for (ItemEntity item : items) {
            if (item.m_213877_()) continue;
            Vec3 itemPos = item.m_20182_();
            boolean itemAbsorbed = false;
            if (!hoppers.isEmpty()) {
                for (HopperBlockEntity hopper : hoppers) {
                    ItemStack remaining = HopperBlockEntity.m_59326_(null, (Container)hopper, (ItemStack)item.m_32055_().m_41777_(), null);
                    if (remaining.m_41619_()) {
                        itemAbsorbed = true;
                        break;
                    }
                    if (remaining.m_41613_() >= item.m_32055_().m_41613_()) continue;
                    item.m_32045_(remaining);
                    CenserEffectHandler.playSuctionEffects(serverLevel, itemPos);
                }
            } else {
                Player nearestPlayer = (Player)CenserEffectHandler.findNearestEntity(itemPos, serverLevel.m_45976_(Player.class, area));
                if (nearestPlayer != null) {
                    item.m_6123_(nearestPlayer);
                }
            }
            if (!itemAbsorbed) continue;
            CenserEffectHandler.playSuctionEffects(serverLevel, itemPos);
            item.m_146870_();
        }
    }

    private static void playSuctionEffects(ServerLevel level, Vec3 pos) {
        level.m_6263_(null, pos.f_82479_, pos.f_82480_, pos.f_82481_, (SoundEvent)ModSoundEvents.WIND_BURST.get(), SoundSource.BLOCKS, 0.7f, 0.9f + level.f_46441_.m_188501_() * 0.2f);
        for (int i = 0; i < 8; ++i) {
            double angle = level.f_46441_.m_188500_() * 2.0 * Math.PI;
            double radius = level.f_46441_.m_188500_() * 0.5;
            double x = pos.f_82479_ + radius * Math.cos(angle);
            double z = pos.f_82481_ + radius * Math.sin(angle);
            double y = pos.f_82480_ + level.f_46441_.m_188500_() * 0.5;
            level.m_8767_((ParticleOptions)ParticleTypes.f_123806_, x, y, z, 1, 0.0, 0.0, 0.0, 0.1);
        }
    }

    private static <T extends Entity> T findNearestEntity(Vec3 position, List<T> entities) {
        Entity nearest = null;
        double closestDistance = Double.MAX_VALUE;
        for (Entity entity : entities) {
            double distance = position.m_82557_(entity.m_20182_());
            if (!(distance < closestDistance)) continue;
            closestDistance = distance;
            nearest = entity;
        }
        return (T)nearest;
    }

    public static boolean isValidCombination(Item item1, Item item2) {
        HerbCombination combo = new HerbCombination(item1, item2);
        return EFFECTS.containsKey(combo);
    }

    public static void clearPlayerEffectsInRange(Level level, BlockPos pos) {
        int radius = (Integer)Configuration.CENSER_EFFECT_RADIUS.get();
        AABB area = new AABB(pos).m_82400_((double)radius);
        level.m_45976_(Player.class, area).forEach(player -> player.getPersistentData().m_128473_("HexaliaFishersBoon"));
    }

    public static boolean isUndeadVeilActiveInArea(Level level, BlockPos pos) {
        if (level.m_5776_()) {
            return false;
        }
        Set<BlockPos> veilPositions = UNDEAD_VEIL_CACHE.get(level);
        if (veilPositions == null || veilPositions.isEmpty()) {
            return false;
        }
        double radiusSquared = (Integer)Configuration.CENSER_EFFECT_RADIUS.get() * (Integer)Configuration.CENSER_EFFECT_RADIUS.get();
        for (BlockPos center : veilPositions) {
            if (!(pos.m_123331_((Vec3i)center) <= radiusSquared)) continue;
            return true;
        }
        return false;
    }

    public static boolean isEffectActiveInArea(Level level, BlockPos pos, EffectType effectType) {
        if (effectType == EffectType.UNDEAD_VEIL) {
            return CenserEffectHandler.isUndeadVeilActiveInArea(level, pos);
        }
        AABB area = new AABB(pos).m_82400_((double)((Integer)Configuration.CENSER_EFFECT_RADIUS.get()).intValue());
        return BlockPos.m_121990_((BlockPos)BlockPos.m_274561_((double)area.f_82288_, (double)area.f_82289_, (double)area.f_82290_), (BlockPos)BlockPos.m_274561_((double)area.f_82291_, (double)area.f_82292_, (double)area.f_82293_)).map(arg_0 -> ((Level)level).m_7702_(arg_0)).filter(be -> be instanceof CenserBlockEntity).map(be -> (CenserBlockEntity)((Object)be)).anyMatch(censer -> {
            if (!((Boolean)censer.m_58900_().m_61143_((Property)CenserBlock.LIT)).booleanValue()) {
                return false;
            }
            ItemStack herb1 = censer.getItem(0);
            ItemStack herb2 = censer.getItem(1);
            if (herb1.m_41619_() || herb2.m_41619_()) {
                return false;
            }
            return CenserEffectHandler.getEffectTypeForCombination(new HerbCombination(herb1.m_41720_(), herb2.m_41720_())) == effectType;
        });
    }

    private static EffectType getEffectTypeForCombination(HerbCombination combo) {
        Map<HerbCombination, EffectType> combinationToEffect = Map.of(new HerbCombination((Item)ModItems.SIREN_KELP.get(), ((Block)ModBlocks.SPIRIT_BLOOM.get()).m_5456_()), EffectType.FIREPROOF_PRESENCE, new HerbCombination(((Block)ModBlocks.GHOST_FERN.get()).m_5456_(), ((Block)ModBlocks.SPIRIT_BLOOM.get()).m_5456_()), EffectType.UNDEAD_VEIL, new HerbCombination(((Block)ModBlocks.GHOST_FERN.get()).m_5456_(), (Item)ModItems.SIREN_KELP.get()), EffectType.LIVESTOCK_COMFORT, new HerbCombination(((Block)ModBlocks.DREAMSHROOM.get()).m_5456_(), ((Block)ModBlocks.SPIRIT_BLOOM.get()).m_5456_()), EffectType.MINERS_RESPITE, new HerbCombination(((Block)ModBlocks.DREAMSHROOM.get()).m_5456_(), (Item)ModItems.SIREN_KELP.get()), EffectType.FISHERS_BOON, new HerbCombination(((Block)ModBlocks.DREAMSHROOM.get()).m_5456_(), ((Block)ModBlocks.GHOST_FERN.get()).m_5456_()), EffectType.SUCTION_ZONE);
        return combinationToEffect.getOrDefault(combo, null);
    }

    public static String getMessageKeyForCombination(HerbCombination combo) {
        if (combo.equals(new HerbCombination((Item)ModItems.SIREN_KELP.get(), ((Block)ModBlocks.SPIRIT_BLOOM.get()).m_5456_()))) {
            return "message.hexalia.censer.fireproof_presence";
        }
        if (combo.equals(new HerbCombination(((Block)ModBlocks.GHOST_FERN.get()).m_5456_(), ((Block)ModBlocks.SPIRIT_BLOOM.get()).m_5456_()))) {
            return "message.hexalia.censer.undead_veil";
        }
        if (combo.equals(new HerbCombination(((Block)ModBlocks.GHOST_FERN.get()).m_5456_(), (Item)ModItems.SIREN_KELP.get()))) {
            return "message.hexalia.censer.livestock_comfort";
        }
        if (combo.equals(new HerbCombination(((Block)ModBlocks.DREAMSHROOM.get()).m_5456_(), ((Block)ModBlocks.SPIRIT_BLOOM.get()).m_5456_()))) {
            return "message.hexalia.censer.miners_respite";
        }
        if (combo.equals(new HerbCombination(((Block)ModBlocks.DREAMSHROOM.get()).m_5456_(), (Item)ModItems.SIREN_KELP.get()))) {
            return "message.hexalia.censer.fishers_boon";
        }
        if (combo.equals(new HerbCombination(((Block)ModBlocks.DREAMSHROOM.get()).m_5456_(), ((Block)ModBlocks.GHOST_FERN.get()).m_5456_()))) {
            return "message.hexalia.censer.suction_zone";
        }
        return "message.hexalia.censer.generic_effect";
    }

    private static class ActiveCenserEffect {
        private final EffectType type;
        private int duration;
        private final HerbCombination combo;

        public ActiveCenserEffect(EffectType type, int duration, HerbCombination combo) {
            this.type = type;
            this.duration = duration;
            this.combo = combo;
        }

        public void decrementDuration() {
            --this.duration;
        }

        public boolean isExpired() {
            return this.duration <= 0;
        }

        public HerbCombination combo() {
            return this.combo;
        }
    }

    public static enum EffectType {
        FIREPROOF_PRESENCE,
        UNDEAD_VEIL,
        LIVESTOCK_COMFORT,
        MINERS_RESPITE,
        FISHERS_BOON,
        SUCTION_ZONE;

    }
}

