/*
 * Decompiled with CFR 0.152.
 */
package net.astralya.hexalia.block.entity.custom;

import net.astralya.hexalia.Configuration;
import net.astralya.hexalia.block.entity.ModBlockEntityTypes;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.tags.BlockTags;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.BonemealableBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import org.jetbrains.annotations.Nullable;

public class AstrylisBlockEntity
extends BlockEntity {
    private long activationTime = -1L;
    private int duration = (Integer)Configuration.ASTRYLIS_DURATION.get();
    private long lastBonemealTime = -1L;

    public AstrylisBlockEntity(BlockPos pPos, BlockState pBlockState) {
        super((BlockEntityType)ModBlockEntityTypes.ASTRYLIS_BE.get(), pPos, pBlockState);
    }

    public static void tick(Level level, BlockPos pos, BlockState state, AstrylisBlockEntity entity) {
        if (level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            if (entity.isActive()) {
                long actualBonemealApplications;
                int interval = Math.max(1, (Integer)Configuration.ASTRYLIS_BONEMEAL_INTERVAL.get());
                long currentTime = level.m_46467_();
                long elapsedTime = currentTime - entity.activationTime;
                if (elapsedTime >= (long)entity.duration) {
                    entity.deactivate();
                    return;
                }
                long expectedBonemealApplications = elapsedTime / (long)interval;
                long l = actualBonemealApplications = entity.lastBonemealTime == -1L ? 0L : (entity.lastBonemealTime - entity.activationTime) / (long)interval + 1L;
                if (expectedBonemealApplications > actualBonemealApplications) {
                    long missedApplications = Math.min(expectedBonemealApplications - actualBonemealApplications, 5L);
                    for (long i = 0L; i < missedApplications; ++i) {
                        AstrylisBlockEntity.applyBonemealToCropsAndSaplings(serverLevel, pos);
                    }
                    entity.lastBonemealTime = currentTime;
                } else if (elapsedTime % (long)interval == 0L && elapsedTime > 0L) {
                    AstrylisBlockEntity.applyBonemealToCropsAndSaplings(serverLevel, pos);
                    entity.lastBonemealTime = currentTime;
                }
                entity.m_6596_();
            }
        }
    }

    private static void applyBonemealToCropsAndSaplings(ServerLevel level, BlockPos centerPos) {
        BlockPos.m_121990_((BlockPos)centerPos.m_7918_(-4, -2, -4), (BlockPos)centerPos.m_7918_(4, 2, 4)).forEach(pos -> {
            BlockState s = level.m_8055_(pos);
            Block patt2936$temp = s.m_60734_();
            if (patt2936$temp instanceof BonemealableBlock) {
                BonemealableBlock growable = (BonemealableBlock)patt2936$temp;
                if ((s.m_204336_(BlockTags.f_13073_) || s.m_204336_(BlockTags.f_13104_)) && growable.m_7370_((LevelReader)level, pos, s, false)) {
                    growable.m_214148_(level, level.f_46441_, pos, s);
                    level.m_8767_((ParticleOptions)ParticleTypes.f_123748_, (double)pos.m_123341_() + 0.5, (double)pos.m_123342_() + 0.5, (double)pos.m_123343_() + 0.5, 1, 0.2, 0.2, 0.2, 0.0);
                }
            }
        });
    }

    public boolean isActive() {
        return this.activationTime > 0L && this.f_58857_ != null && this.f_58857_.m_46467_() >= this.activationTime;
    }

    public void activate(long gameTime) {
        this.activate(gameTime, (Integer)Configuration.ASTRYLIS_DURATION.get());
    }

    public void activate(long gameTime, int customDuration) {
        this.activationTime = gameTime;
        this.duration = Math.max(1, customDuration);
        this.lastBonemealTime = -1L;
        this.m_6596_();
    }

    public void deactivate() {
        this.activationTime = -1L;
        this.lastBonemealTime = -1L;
        this.m_6596_();
    }

    public int getDuration() {
        return this.duration;
    }

    public float getProgress() {
        if (!this.isActive() || this.f_58857_ == null) {
            return 0.0f;
        }
        long elapsed = this.f_58857_.m_46467_() - this.activationTime;
        return Math.min(1.0f, (float)elapsed / (float)this.duration);
    }

    protected void m_183515_(CompoundTag tag) {
        super.m_183515_(tag);
        tag.m_128356_("activationTime", this.activationTime);
        tag.m_128405_("duration", this.duration);
        tag.m_128356_("lastBonemealTime", this.lastBonemealTime);
    }

    public void m_142466_(CompoundTag tag) {
        super.m_142466_(tag);
        this.activationTime = tag.m_128454_("activationTime");
        this.duration = tag.m_128441_("duration") ? Math.max(1, tag.m_128451_("duration")) : Math.max(1, (Integer)Configuration.ASTRYLIS_DURATION.get());
        this.lastBonemealTime = tag.m_128454_("lastBonemealTime");
    }

    public CompoundTag m_5995_() {
        CompoundTag tag = super.m_5995_();
        tag.m_128356_("activationTime", this.activationTime);
        tag.m_128405_("duration", this.duration);
        tag.m_128356_("lastBonemealTime", this.lastBonemealTime);
        return tag;
    }

    @Nullable
    public Packet<ClientGamePacketListener> m_58483_() {
        return ClientboundBlockEntityDataPacket.m_195640_((BlockEntity)this);
    }
}

