/*
 * Decompiled with CFR 0.152.
 */
package net.astralya.hexalia.block.entity.custom;

import net.astralya.hexalia.block.custom.CenserBlock;
import net.astralya.hexalia.block.custom.censer.CenserEffectHandler;
import net.astralya.hexalia.block.custom.censer.HerbCombination;
import net.astralya.hexalia.block.entity.ModBlockEntityTypes;
import net.astralya.hexalia.util.ModUtil;
import net.minecraft.core.BlockPos;
import net.minecraft.core.NonNullList;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.ContainerHelper;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;

public class CenserBlockEntity
extends BlockEntity {
    private static final int SIZE = 2;
    private final NonNullList<ItemStack> items = NonNullList.m_122780_((int)2, (Object)ItemStack.f_41583_);
    private HerbCombination activeCombination = null;
    private int burnTime = 0;
    private static final int EFFECT_INTERVAL = 40;
    private boolean effectActive = false;

    public CenserBlockEntity(BlockPos pos, BlockState state) {
        super((BlockEntityType)ModBlockEntityTypes.CENSER_BE.get(), pos, state);
    }

    public void tick(Level level, BlockPos pos, BlockState state) {
        if (!((Boolean)state.m_61143_((Property)CenserBlock.LIT)).booleanValue()) {
            return;
        }
        if (this.burnTime > 0) {
            --this.burnTime;
            if (this.burnTime % 40 == 0 && this.activeCombination != null) {
                CenserEffectHandler.applyEffects(level, pos, this.activeCombination);
                if (!this.effectActive) {
                    CenserEffectHandler.registerActiveEffect(level, pos, this.activeCombination, this.burnTime);
                    this.effectActive = true;
                }
            }
            if (this.burnTime <= 0) {
                this.extinguish(level, pos, state);
            }
            this.m_6596_();
        }
    }

    private void extinguish(Level level, BlockPos pos, BlockState state) {
        if (this.activeCombination != null) {
            CenserEffectHandler.clearPlayerEffectsInRange(level, pos);
            CenserEffectHandler.removeActiveEffect(pos);
            this.activeCombination = null;
            this.effectActive = false;
        }
        level.m_46597_(pos, (BlockState)state.m_61124_((Property)CenserBlock.LIT, (Comparable)Boolean.valueOf(false)));
        level.m_5594_(null, pos, SoundEvents.f_11937_, SoundSource.BLOCKS, 0.5f, 1.0f);
        this.m_6596_();
        this.sendUpdate();
    }

    public void reactivateEffect() {
        if (this.activeCombination != null && this.burnTime > 0 && !this.effectActive && this.f_58857_ != null) {
            CenserEffectHandler.registerActiveEffect(this.f_58857_, this.f_58858_, this.activeCombination, this.burnTime);
            this.effectActive = true;
        }
    }

    public void setBurnTime(int time) {
        this.burnTime = time;
        this.m_6596_();
    }

    public int getBurnTime() {
        return this.burnTime;
    }

    public ItemStack getItem(int slot) {
        if (slot < 0 || slot >= 2) {
            return ItemStack.f_41583_;
        }
        return (ItemStack)this.items.get(slot);
    }

    public void setItem(int slot, ItemStack stack) {
        if (slot < 0 || slot >= 2) {
            return;
        }
        this.items.set(slot, (Object)stack);
        this.m_6596_();
        this.sendUpdate();
    }

    public void clearItems() {
        for (int i = 0; i < 2; ++i) {
            this.items.set(i, (Object)ItemStack.f_41583_);
        }
        this.m_6596_();
        this.sendUpdate();
    }

    private void sendUpdate() {
        if (this.f_58857_ != null && !this.f_58857_.m_5776_()) {
            Packet<ClientGamePacketListener> updatePacket = this.m_58483_();
            for (ServerPlayer player : ModUtil.tracking((ServerLevel)this.f_58857_, this.f_58858_)) {
                player.f_8906_.m_9829_(updatePacket);
            }
            this.f_58857_.m_7260_(this.f_58858_, this.m_58900_(), this.m_58900_(), 3);
        }
    }

    public NonNullList<ItemStack> getItems() {
        return this.items;
    }

    public void setActiveCombination(HerbCombination combo) {
        this.activeCombination = combo;
        this.m_6596_();
    }

    public HerbCombination getActiveCombination() {
        return this.activeCombination;
    }

    public void m_142466_(CompoundTag tag) {
        super.m_142466_(tag);
        ContainerHelper.m_18980_((CompoundTag)tag, this.items);
        for (int i = 0; i < this.items.size(); ++i) {
            ItemStack stack = (ItemStack)this.items.get(i);
            if (stack.m_41619_() || stack.m_41613_() > 0 && stack.m_41613_() <= stack.m_41741_()) continue;
            stack.m_41764_(1);
        }
        if (tag.m_128441_("ActiveCombination")) {
            CompoundTag comboTag = tag.m_128469_("ActiveCombination");
            Item item1 = Item.m_41445_((int)comboTag.m_128451_("Item1"));
            Item item2 = Item.m_41445_((int)comboTag.m_128451_("Item2"));
            this.activeCombination = new HerbCombination(item1, item2);
        }
        this.burnTime = tag.m_128451_("BurnTime");
        this.effectActive = tag.m_128471_("EffectActive");
    }

    protected void m_183515_(CompoundTag tag) {
        super.m_183515_(tag);
        ContainerHelper.m_18973_((CompoundTag)tag, this.items);
        tag.m_128405_("BurnTime", this.burnTime);
        tag.m_128379_("EffectActive", this.effectActive);
        if (this.activeCombination != null) {
            CompoundTag comboTag = new CompoundTag();
            comboTag.m_128405_("Item1", Item.m_41393_((Item)this.activeCombination.item1()));
            comboTag.m_128405_("Item2", Item.m_41393_((Item)this.activeCombination.item2()));
            tag.m_128365_("ActiveCombination", (Tag)comboTag);
        }
    }

    public void onLoad() {
        super.onLoad();
        if (this.f_58857_ != null && !this.f_58857_.f_46443_ && this.activeCombination != null && this.burnTime > 0) {
            this.reactivateEffect();
        }
    }

    public CompoundTag m_5995_() {
        return this.m_187482_();
    }

    public Packet<ClientGamePacketListener> m_58483_() {
        return ClientboundBlockEntityDataPacket.m_195640_((BlockEntity)this);
    }

    public boolean isEmpty() {
        return this.items.stream().allMatch(ItemStack::m_41619_);
    }

    public ItemStack removeStack(int slot) {
        if (slot < 0 || slot >= 2) {
            return ItemStack.f_41583_;
        }
        ItemStack stack = ((ItemStack)this.items.get(slot)).m_41777_();
        this.items.set(slot, (Object)ItemStack.f_41583_);
        this.m_6596_();
        this.sendUpdate();
        return stack;
    }
}

