/*
 * Decompiled with CFR 0.152.
 */
package net.astralya.hexalia.block.entity.custom;

import java.util.Optional;
import net.astralya.hexalia.block.ModBlocks;
import net.astralya.hexalia.block.custom.RitualBrazierBlock;
import net.astralya.hexalia.block.entity.ModBlockEntityTypes;
import net.astralya.hexalia.block.entity.custom.SyncBlockEntity;
import net.astralya.hexalia.particle.ModParticleType;
import net.astralya.hexalia.recipe.RitualBrazierRecipe;
import net.astralya.hexalia.util.ModUtil;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.SimpleParticleType;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.Connection;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.Container;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.event.AttachCapabilitiesEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemStackHandler;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Mod.EventBusSubscriber(modid="hexalia", bus=Mod.EventBusSubscriber.Bus.FORGE)
public class RitualBrazierBlockEntity
extends SyncBlockEntity {
    private final ItemStackHandler inventory = this.createHandler();
    private final LazyOptional<IItemHandler> inventoryOptional = LazyOptional.of(() -> this.inventory);
    private boolean isRitualFocusItem = false;
    private float rotation;

    public RitualBrazierBlockEntity(BlockPos pos, BlockState state) {
        super((BlockEntityType)ModBlockEntityTypes.RITUAL_BRAZIER_BE.get(), pos, state);
    }

    private ItemStackHandler createHandler() {
        return new ItemStackHandler(1){

            protected void onContentsChanged(int slot) {
                RitualBrazierBlockEntity.this.inventoryChanged();
            }

            public int getSlotLimit(int slot) {
                return 1;
            }
        };
    }

    public RitualResult tryCelestialRitual() {
        if (this.f_58857_ == null || this.isRitualFocusItem) {
            return RitualResult.INVALID_ITEM;
        }
        BlockPos bloomPos = this.findNearbyCelestialBloom();
        if (bloomPos == null) {
            return RitualResult.NO_CELESTIAL_BLOOMS;
        }
        Optional match = this.f_58857_.m_7465_().m_44015_((RecipeType)RitualBrazierRecipe.Type.INSTANCE, (Container)new SimpleContainer(new ItemStack[]{this.getStoredItem()}), this.f_58857_);
        if (match.isEmpty()) {
            return RitualResult.INVALID_ITEM;
        }
        ItemStack resultStack = ((RitualBrazierRecipe)match.get()).m_8043_(this.f_58857_.m_9598_());
        Direction eject = ((Direction)this.m_58900_().m_61143_((Property)RitualBrazierBlock.FACING)).m_122428_();
        ModUtil.spawnItemEntity(this.f_58857_, resultStack.m_41777_(), (double)this.f_58858_.m_123341_() + 0.5 + (double)eject.m_122429_() * 0.2, (double)this.f_58858_.m_123342_() + 0.2, (double)this.f_58858_.m_123343_() + 0.5 + (double)eject.m_122431_() * 0.2, (float)eject.m_122429_() * 0.2f, 0.0, (float)eject.m_122431_() * 0.2f);
        this.removeItem();
        if (!this.f_58857_.f_46443_) {
            this.f_58857_.m_7731_(bloomPos, Blocks.f_50036_.m_49966_(), 3);
            Level level = this.f_58857_;
            if (level instanceof ServerLevel) {
                ServerLevel server = (ServerLevel)level;
                this.emitEffects(server, bloomPos);
            }
        }
        return RitualResult.SUCCESS;
    }

    private BlockPos findNearbyCelestialBloom() {
        if (this.f_58857_ == null) {
            return null;
        }
        BlockPos origin = this.m_58899_();
        for (int dx = -3; dx <= 3; ++dx) {
            for (int dz = -3; dz <= 3; ++dz) {
                BlockPos check;
                if (dx == 0 && dz == 0 || !this.f_58857_.m_8055_(check = origin.m_7918_(dx, 0, dz)).m_60713_((Block)ModBlocks.CELESTIAL_BLOOM.get())) continue;
                return check;
            }
        }
        return null;
    }

    private void emitEffects(ServerLevel server, BlockPos at) {
        server.m_8767_((ParticleOptions)((SimpleParticleType)ModParticleType.LEAVES.get()), (double)at.m_123341_() + 0.5, (double)at.m_123342_() + 0.6, (double)at.m_123343_() + 0.5, 15, 0.2, 0.25, 0.2, 0.0);
    }

    public void playSound(SoundEvent sound, float volume, float pitch) {
        if (this.f_58857_ != null) {
            this.f_58857_.m_6263_(null, (double)((float)this.f_58858_.m_123341_() + 0.5f), (double)((float)this.f_58858_.m_123342_() + 0.5f), (double)((float)this.f_58858_.m_123343_() + 0.5f), sound, SoundSource.BLOCKS, volume, pitch);
        }
    }

    public boolean addItem(ItemStack stack) {
        if (this.isEmpty() && !stack.m_41619_()) {
            this.inventory.setStackInSlot(0, stack.m_41620_(1));
            this.isRitualFocusItem = false;
            this.inventoryChanged();
            return true;
        }
        return false;
    }

    public ItemStack removeItem() {
        if (!this.isEmpty()) {
            this.isRitualFocusItem = false;
            ItemStack taken = this.getStoredItem().m_41620_(1);
            this.inventoryChanged();
            return taken;
        }
        return ItemStack.f_41583_;
    }

    public IItemHandler getInventory() {
        return this.inventory;
    }

    public ItemStack getStoredItem() {
        return this.inventory.getStackInSlot(0);
    }

    public boolean isEmpty() {
        return this.inventory.getStackInSlot(0).m_41619_();
    }

    public float getRenderingRotation() {
        this.rotation += 0.5f;
        if (this.rotation >= 360.0f) {
            this.rotation = 0.0f;
        }
        return this.rotation;
    }

    public void m_7651_() {
        super.m_7651_();
        this.inventoryOptional.invalidate();
    }

    @Override
    public CompoundTag m_5995_() {
        CompoundTag tag = super.m_5995_();
        tag.m_128379_("IsItemImbued", this.isRitualFocusItem);
        tag.m_128365_("Inventory", (Tag)this.inventory.serializeNBT());
        return tag;
    }

    public void handleUpdateTag(CompoundTag tag) {
        super.handleUpdateTag(tag);
        this.isRitualFocusItem = tag.m_128471_("IsItemImbued");
        this.inventory.deserializeNBT(tag.m_128469_("Inventory"));
    }

    @Nullable
    public ClientboundBlockEntityDataPacket getUpdatePacket() {
        return ClientboundBlockEntityDataPacket.m_195640_((BlockEntity)this);
    }

    public void onDataPacket(Connection net, ClientboundBlockEntityDataPacket pkt) {
        super.onDataPacket(net, pkt);
        if (this.f_58857_ != null && this.f_58857_.f_46443_) {
            this.f_58857_.m_7260_(this.f_58858_, this.m_58900_(), this.m_58900_(), 3);
        }
    }

    public void m_142466_(CompoundTag tag) {
        super.m_142466_(tag);
        this.isRitualFocusItem = tag.m_128471_("IsItemImbued");
        this.inventory.deserializeNBT(tag.m_128469_("Inventory"));
    }

    protected void m_183515_(CompoundTag tag) {
        super.m_183515_(tag);
        tag.m_128379_("IsItemImbued", this.isRitualFocusItem);
        tag.m_128365_("Inventory", (Tag)this.inventory.serializeNBT());
    }

    @NotNull
    public <T> LazyOptional<T> getCapability(@NotNull Capability<T> cap, @Nullable Direction side) {
        if (cap == ForgeCapabilities.ITEM_HANDLER) {
            return this.inventoryOptional.cast();
        }
        return super.getCapability(cap, side);
    }

    @SubscribeEvent
    public static void attachCapabilities(AttachCapabilitiesEvent<BlockEntity> event) {
        if (event.getObject() instanceof RitualBrazierBlockEntity) {
            // empty if block
        }
    }

    public static enum RitualResult {
        SUCCESS,
        NO_CELESTIAL_BLOOMS,
        INVALID_ITEM;

    }
}

