/*
 * Decompiled with CFR 0.152.
 */
package net.astralya.hexalia.block.entity.custom;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import net.astralya.hexalia.block.custom.RitualBrazierBlock;
import net.astralya.hexalia.block.entity.ModBlockEntityTypes;
import net.astralya.hexalia.block.entity.custom.RitualBrazierBlockEntity;
import net.astralya.hexalia.particle.ModParticleType;
import net.astralya.hexalia.sound.ModSoundEvents;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.ItemParticleOption;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.core.particles.SimpleParticleType;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.Container;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.CropBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.items.ItemStackHandler;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class RitualTableBlockEntity
extends BlockEntity
implements Container {
    public static final int DURATION = 160;
    private final ItemStackHandler inventory = new ItemStackHandler(1){

        protected void onContentsChanged(int slot) {
            RitualTableBlockEntity.this.m_6596_();
            if (RitualTableBlockEntity.this.f_58857_ != null && !((RitualTableBlockEntity)RitualTableBlockEntity.this).f_58857_.f_46443_) {
                RitualTableBlockEntity.this.f_58857_.m_7260_(RitualTableBlockEntity.this.f_58858_, RitualTableBlockEntity.this.m_58900_(), RitualTableBlockEntity.this.m_58900_(), 3);
            }
        }
    };
    private LazyOptional<ItemStackHandler> itemCap = LazyOptional.of(() -> this.inventory);
    private ItemStack cachedParticleItem = ItemStack.f_41583_;
    private List<RitualBrazierBlockEntity> activeBraziers = Collections.emptyList();
    private List<BlockPos> grownCrops = Collections.emptyList();
    private ItemStack pendingOutput = ItemStack.f_41583_;
    private int transformTicksRemaining = 0;
    private int totalTransformTicks = 0;
    private int nextBrazierIndex = 0;
    private float rotation = 0.0f;

    public RitualTableBlockEntity(BlockPos pos, BlockState state) {
        super((BlockEntityType)ModBlockEntityTypes.RITUAL_TABLE_BE.get(), pos, state);
    }

    @NotNull
    public <T> LazyOptional<T> getCapability(@NotNull Capability<T> cap, @Nullable Direction side) {
        if (cap == ForgeCapabilities.ITEM_HANDLER) {
            return this.itemCap.cast();
        }
        return super.getCapability(cap, side);
    }

    public void invalidateCaps() {
        super.invalidateCaps();
        this.itemCap.invalidate();
    }

    public void reviveCaps() {
        super.reviveCaps();
        this.itemCap = LazyOptional.of(() -> this.inventory);
    }

    public ItemStackHandler getItemHandler() {
        return this.inventory;
    }

    public int m_6643_() {
        return 1;
    }

    public boolean m_7983_() {
        return this.inventory.getStackInSlot(0).m_41619_();
    }

    public ItemStack m_8020_(int i) {
        return this.inventory.getStackInSlot(i);
    }

    public ItemStack m_7407_(int index, int count) {
        ItemStack extracted = this.inventory.extractItem(index, count, false);
        this.m_6596_();
        return extracted;
    }

    public ItemStack m_8016_(int index) {
        ItemStack current = this.inventory.getStackInSlot(index);
        if (!current.m_41619_()) {
            this.inventory.setStackInSlot(index, ItemStack.f_41583_);
            this.m_6596_();
        }
        return current;
    }

    public void m_6836_(int index, ItemStack stack) {
        if (!stack.m_41619_()) {
            stack = stack.m_255036_(1);
        }
        this.inventory.setStackInSlot(index, stack);
        this.m_6596_();
    }

    public boolean m_6542_(Player player) {
        double dz;
        double dy;
        if (this.f_58857_ == null || this.f_58857_.m_7702_(this.f_58858_) != this) {
            return false;
        }
        double dx = player.m_20185_() - ((double)this.f_58858_.m_123341_() + 0.5);
        return dx * dx + (dy = player.m_20186_() - ((double)this.f_58858_.m_123342_() + 0.5)) * dy + (dz = player.m_20189_() - ((double)this.f_58858_.m_123343_() + 0.5)) * dz <= 64.0;
    }

    public void m_6211_() {
        this.inventory.setStackInSlot(0, ItemStack.f_41583_);
    }

    public int m_6893_() {
        return 1;
    }

    public float getRenderingRotation() {
        this.rotation = (this.rotation + 0.5f) % 360.0f;
        return this.rotation;
    }

    public void startTransformation(ItemStack output, int durationTicks, List<RitualBrazierBlockEntity> braziers, List<BlockPos> grownCropPositions) {
        if (this.transformTicksRemaining > 0) {
            return;
        }
        this.totalTransformTicks = this.transformTicksRemaining = Math.max(1, durationTicks);
        this.pendingOutput = output.m_41777_();
        this.activeBraziers = new ArrayList<RitualBrazierBlockEntity>(braziers);
        this.grownCrops = new ArrayList<BlockPos>(grownCropPositions);
        this.nextBrazierIndex = 0;
        this.cachedParticleItem = ItemStack.f_41583_;
        this.m_6596_();
    }

    public static void serverTick(Level level, BlockPos pos, BlockState st, RitualTableBlockEntity be) {
        if (be.transformTicksRemaining <= 0) {
            return;
        }
        if (be.m_7983_() || RitualTableBlockEntity.hasMissingBrazierItems(be)) {
            RitualTableBlockEntity.cancelRitual(level, pos, be);
            return;
        }
        int base = be.totalTransformTicks > 0 ? be.totalTransformTicks : 160;
        int elapsed = base - be.transformTicksRemaining;
        RitualTableBlockEntity.handleActiveBraziers(level, pos, be, elapsed);
        --be.transformTicksRemaining;
        if (be.transformTicksRemaining == 0) {
            RitualTableBlockEntity.completeRitual(level, pos, be);
        }
    }

    private static boolean hasMissingBrazierItems(RitualTableBlockEntity be) {
        for (int i = be.nextBrazierIndex; i < be.activeBraziers.size(); ++i) {
            RitualBrazierBlockEntity brazier = be.activeBraziers.get(i);
            if (i == be.nextBrazierIndex && !be.cachedParticleItem.m_41619_() || brazier != null && !brazier.m_58901_() && !brazier.isEmpty()) continue;
            return true;
        }
        return false;
    }

    private static void handleActiveBraziers(Level level, BlockPos pos, RitualTableBlockEntity be, int elapsed) {
        ServerLevel server;
        if (be.activeBraziers.isEmpty() || be.nextBrazierIndex >= be.activeBraziers.size()) {
            return;
        }
        int ticksPerBrazier = 40;
        int currentTime = elapsed - be.nextBrazierIndex * ticksPerBrazier;
        RitualBrazierBlockEntity brazier = be.activeBraziers.get(be.nextBrazierIndex);
        if (brazier == null) {
            return;
        }
        if (currentTime == 0) {
            be.cachedParticleItem = brazier.getStoredItem().m_41777_();
            brazier.removeItem();
            BlockState bs = level.m_8055_(brazier.m_58899_());
            if (bs.m_60734_() instanceof RitualBrazierBlock && bs.m_61138_((Property)RitualBrazierBlock.SALTED) && ((Boolean)bs.m_61143_((Property)RitualBrazierBlock.SALTED)).booleanValue()) {
                level.m_7731_(brazier.m_58899_(), (BlockState)bs.m_61124_((Property)RitualBrazierBlock.SALTED, (Comparable)Boolean.valueOf(false)), 3);
            }
        }
        if (currentTime >= 0 && currentTime < ticksPerBrazier && level instanceof ServerLevel) {
            server = (ServerLevel)level;
            RitualTableBlockEntity.spawnItemParticles(server, be.cachedParticleItem, brazier.m_58899_(), pos, currentTime, ticksPerBrazier);
        }
        if (currentTime == ticksPerBrazier - 1) {
            if (level instanceof ServerLevel) {
                server = (ServerLevel)level;
                RitualTableBlockEntity.spawnAbsorbBurst(server, pos, be.cachedParticleItem);
            }
            ++be.nextBrazierIndex;
            be.cachedParticleItem = ItemStack.f_41583_;
        }
    }

    private static void spawnItemParticles(ServerLevel server, ItemStack item, BlockPos from, BlockPos to, int time, int totalTime) {
        if (item.m_41619_()) {
            return;
        }
        ItemParticleOption particle = new ItemParticleOption(ParticleTypes.f_123752_, item);
        double startX = (double)from.m_123341_() + 0.5;
        double startY = (double)from.m_123342_() + 0.4;
        double startZ = (double)from.m_123343_() + 0.5;
        double endX = (double)to.m_123341_() + 0.5;
        double endY = (double)to.m_123342_() + 1.15;
        double endZ = (double)to.m_123343_() + 0.5;
        double progress = (double)time / (double)totalTime;
        double px = startX + (endX - startX) * progress;
        double py = startY + (endY - startY) * progress;
        double pz = startZ + (endZ - startZ) * progress;
        for (int i = 0; i < 3; ++i) {
            double offsetX = (server.f_46441_.m_188500_() - 0.5) * 0.05;
            double offsetY = (server.f_46441_.m_188500_() - 0.5) * 0.05;
            double offsetZ = (server.f_46441_.m_188500_() - 0.5) * 0.05;
            double speed = 0.008 + server.f_46441_.m_188500_() * 0.004;
            double velX = (endX - startX) * speed;
            double velY = (endY - startY) * speed + 0.003;
            double velZ = (endZ - startZ) * speed;
            server.m_8767_((ParticleOptions)particle, px + offsetX, py + offsetY, pz + offsetZ, 1, velX, velY, velZ, 0.0);
        }
    }

    private static void spawnAbsorbBurst(ServerLevel server, BlockPos pos, ItemStack item) {
        double vz;
        double vy;
        double vx;
        double oz;
        double oy;
        double ox;
        int i;
        double cx = (double)pos.m_123341_() + 0.5;
        double cy = (double)pos.m_123342_() + 1.1;
        double cz = (double)pos.m_123343_() + 0.5;
        for (i = 0; i < 12; ++i) {
            ox = (server.f_46441_.m_188500_() - 0.5) * 0.5;
            oy = server.f_46441_.m_188500_() * 0.3;
            oz = (server.f_46441_.m_188500_() - 0.5) * 0.5;
            vx = (server.f_46441_.m_188500_() - 0.5) * 0.02;
            vy = 0.04 + server.f_46441_.m_188500_() * 0.02;
            vz = (server.f_46441_.m_188500_() - 0.5) * 0.02;
            server.m_8767_((ParticleOptions)ParticleTypes.f_123771_, cx + ox, cy + oy, cz + oz, 1, vx, vy, vz, 0.0);
        }
        if (!item.m_41619_()) {
            for (i = 0; i < 8; ++i) {
                ox = (server.f_46441_.m_188500_() - 0.5) * 0.2;
                oy = server.f_46441_.m_188500_() * 0.2;
                oz = (server.f_46441_.m_188500_() - 0.5) * 0.2;
                vx = (server.f_46441_.m_188500_() - 0.5) * 0.005;
                vy = 0.015 + server.f_46441_.m_188500_() * 0.005;
                vz = (server.f_46441_.m_188500_() - 0.5) * 0.005;
                server.m_8767_((ParticleOptions)new ItemParticleOption(ParticleTypes.f_123752_, item), cx + ox, cy + oy, cz + oz, 1, vx, vy, vz, 0.0);
            }
        }
        server.m_5594_(null, pos, SoundEvents.f_11887_, SoundSource.BLOCKS, 0.4f, 1.2f + server.f_46441_.m_188501_() * 0.2f);
    }

    private static void completeRitual(Level level, BlockPos pos, RitualTableBlockEntity be) {
        be.m_6836_(0, be.pendingOutput);
        be.pendingOutput = ItemStack.f_41583_;
        for (BlockPos cropPos : be.grownCrops) {
            BlockState state = level.m_8055_(cropPos);
            Block block = state.m_60734_();
            if (!(block instanceof CropBlock)) continue;
            CropBlock crop = (CropBlock)block;
            if (!state.m_61138_((Property)CropBlock.f_52244_)) continue;
            level.m_7731_(cropPos, (BlockState)state.m_61124_((Property)CropBlock.f_52244_, (Comparable)Integer.valueOf(0)), 3);
        }
        be.activeBraziers = Collections.emptyList();
        be.nextBrazierIndex = 0;
        be.cachedParticleItem = ItemStack.f_41583_;
        be.grownCrops = Collections.emptyList();
        level.m_5594_(null, pos, (SoundEvent)ModSoundEvents.RITUAL_SUCCESS.get(), SoundSource.BLOCKS, 0.8f, 1.0f);
        if (level instanceof ServerLevel) {
            ServerLevel server = (ServerLevel)level;
            server.m_8767_((ParticleOptions)((SimpleParticleType)ModParticleType.LEAVES.get()), (double)pos.m_123341_() + 0.5, (double)pos.m_123342_() + 1.0, (double)pos.m_123343_() + 0.5, 15, 0.3, 0.3, 0.3, 0.0);
        }
        be.m_6596_();
    }

    private static void cancelRitual(Level level, BlockPos pos, RitualTableBlockEntity be) {
        be.transformTicksRemaining = 0;
        be.totalTransformTicks = 0;
        be.pendingOutput = ItemStack.f_41583_;
        be.activeBraziers = Collections.emptyList();
        be.nextBrazierIndex = 0;
        be.cachedParticleItem = ItemStack.f_41583_;
        be.grownCrops = Collections.emptyList();
        if (level instanceof ServerLevel) {
            ServerLevel server = (ServerLevel)level;
            server.m_8767_((ParticleOptions)ParticleTypes.f_123762_, (double)pos.m_123341_() + 0.5, (double)pos.m_123342_() + 1.0, (double)pos.m_123343_() + 0.5, 12, 0.4, 0.4, 0.4, 0.02);
            Player nearest = server.m_45924_((double)pos.m_123341_(), (double)pos.m_123342_(), (double)pos.m_123343_(), 5.0, false);
            if (nearest != null) {
                nearest.m_5661_((Component)Component.m_237115_((String)"message.hexalia.ritual.stopped_ritual"), true);
            }
        }
        level.m_5594_(null, pos, SoundEvents.f_144098_, SoundSource.BLOCKS, 0.4f, 0.6f);
        be.m_6596_();
    }

    protected void m_183515_(CompoundTag tag) {
        super.m_183515_(tag);
        tag.m_128365_("Inv", (Tag)this.inventory.serializeNBT());
        tag.m_128405_("TicksLeft", this.transformTicksRemaining);
        tag.m_128405_("TotalTicks", this.totalTransformTicks);
        if (!this.pendingOutput.m_41619_()) {
            CompoundTag out = new CompoundTag();
            this.pendingOutput.m_41739_(out);
            tag.m_128365_("PendingOut", (Tag)out);
        }
    }

    public void m_142466_(CompoundTag tag) {
        super.m_142466_(tag);
        this.inventory.deserializeNBT(tag.m_128469_("Inv"));
        this.transformTicksRemaining = tag.m_128451_("TicksLeft");
        this.totalTransformTicks = tag.m_128451_("TotalTicks");
        this.pendingOutput = tag.m_128441_("PendingOut") ? ItemStack.m_41712_((CompoundTag)tag.m_128469_("PendingOut")) : ItemStack.f_41583_;
    }

    public CompoundTag m_5995_() {
        return this.m_187482_();
    }

    @Nullable
    public ClientboundBlockEntityDataPacket getUpdatePacket() {
        return ClientboundBlockEntityDataPacket.m_195640_((BlockEntity)this);
    }

    public void setGrownCropPositions(List<BlockPos> crops) {
        this.grownCrops = new ArrayList<BlockPos>(crops);
    }

    public static List<BlockPos> collectGrownCrops(Level level, BlockPos tablePos) {
        BlockPos[] positions;
        ArrayList<BlockPos> list = new ArrayList<BlockPos>(16);
        for (BlockPos p : positions = new BlockPos[]{tablePos.m_7918_(-2, 0, -2), tablePos.m_7918_(-1, 0, -2), tablePos.m_7918_(1, 0, -2), tablePos.m_7918_(2, 0, -2), tablePos.m_7918_(-2, 0, -1), tablePos.m_7918_(-1, 0, -1), tablePos.m_7918_(1, 0, -1), tablePos.m_7918_(2, 0, -1), tablePos.m_7918_(-2, 0, 1), tablePos.m_7918_(-1, 0, 1), tablePos.m_7918_(1, 0, 1), tablePos.m_7918_(2, 0, 1), tablePos.m_7918_(-2, 0, 2), tablePos.m_7918_(-1, 0, 2), tablePos.m_7918_(1, 0, 2), tablePos.m_7918_(2, 0, 2)}) {
            CropBlock crop;
            BlockState st = level.m_8055_(p);
            Block block = st.m_60734_();
            if (!(block instanceof CropBlock) || (crop = (CropBlock)block).m_52305_(st) < crop.m_7419_()) continue;
            list.add(p.m_7949_());
        }
        return list;
    }
}

