/*
 * Decompiled with CFR 0.152.
 */
package net.astralya.hexalia.block.entity.custom;

import net.astralya.hexalia.block.entity.ModBlockEntityTypes;
import net.astralya.hexalia.util.ModUtil;
import net.minecraft.core.BlockPos;
import net.minecraft.core.NonNullList;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.ContainerHelper;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;

public class ShelfBlockEntity
extends BlockEntity {
    private static final int SIZE = 6;
    private final NonNullList<ItemStack> items = NonNullList.m_122780_((int)6, (Object)ItemStack.f_41583_);

    public ShelfBlockEntity(BlockPos pos, BlockState state) {
        super((BlockEntityType)ModBlockEntityTypes.SHELF_BE.get(), pos, state);
    }

    public ItemStack getItem(int slot) {
        if (slot < 0 || slot >= 6) {
            return ItemStack.f_41583_;
        }
        return (ItemStack)this.items.get(slot);
    }

    public void setItem(int slot, ItemStack stack) {
        if (slot < 0 || slot >= 6) {
            return;
        }
        this.items.set(slot, (Object)stack);
        this.m_6596_();
        this.sendUpdate();
    }

    private void sendUpdate() {
        if (this.f_58857_ != null && !this.f_58857_.m_5776_()) {
            Packet<ClientGamePacketListener> updatePacket = this.m_58483_();
            for (ServerPlayer player : ModUtil.tracking((ServerLevel)this.f_58857_, this.f_58858_)) {
                player.f_8906_.m_9829_(updatePacket);
            }
            this.f_58857_.m_7260_(this.f_58858_, this.m_58900_(), this.m_58900_(), 3);
        }
    }

    public NonNullList<ItemStack> getItems() {
        return this.items;
    }

    public void m_142466_(CompoundTag tag) {
        super.m_142466_(tag);
        ContainerHelper.m_18980_((CompoundTag)tag, this.items);
        for (int i = 0; i < this.items.size(); ++i) {
            ItemStack stack = (ItemStack)this.items.get(i);
            if (stack.m_41619_() || stack.m_41613_() > 0 && stack.m_41613_() <= stack.m_41741_()) continue;
            stack.m_41764_(1);
        }
    }

    protected void m_183515_(CompoundTag tag) {
        super.m_183515_(tag);
        ContainerHelper.m_18973_((CompoundTag)tag, this.items);
    }

    public CompoundTag m_5995_() {
        return this.m_187482_();
    }

    public Packet<ClientGamePacketListener> m_58483_() {
        return ClientboundBlockEntityDataPacket.m_195640_((BlockEntity)this);
    }

    public boolean isEmpty() {
        return this.items.stream().allMatch(ItemStack::m_41619_);
    }

    public ItemStack removeStack(int slot) {
        if (slot < 0 || slot >= 6) {
            return ItemStack.f_41583_;
        }
        ItemStack stack = ((ItemStack)this.items.get(slot)).m_41777_();
        this.items.set(slot, (Object)ItemStack.f_41583_);
        this.m_6596_();
        this.sendUpdate();
        return stack;
    }
}

